/*
 * Decompiled with CFR 0.152.
 */
package csm.util;

import csm.util.SpaceTime;
import csm.util.TargetStatistic;
import java.awt.geom.Point2D;
import java.util.LinkedList;

public class EnemyRobot {
    private String name;
    private double bearing;
    private double heading;
    private double speed;
    private double x;
    private double y;
    private double last_x = 0.0;
    private double last_y = 0.0;
    private double distance;
    private double changehead;
    private double energy;
    private long ctime;
    private boolean live;
    private double PI = Math.PI;
    private boolean jiggling = false;
    private double jiggleTime1 = 0.0;
    private double jiggleTime2 = 0.0;
    private double timeBetweenJiggles = 0.0;
    private TargetStatistic targetStatistic = new TargetStatistic();
    private LinkedList lastCoordinates = new LinkedList();
    private long numSnapshots = 0L;
    private double damageInflicted = 0.0;
    private long roundsSinceLastScan = 1L;
    private boolean firstScan = true;

    public EnemyRobot() {
    }

    public EnemyRobot(SpaceTime spaceTime) {
        this.x = spaceTime.getX();
        this.y = spaceTime.getY();
        this.ctime = spaceTime.getTime();
        this.heading = spaceTime.getHeading();
        this.speed = spaceTime.getSpeed();
    }

    public SpaceTime getLastSpaceTime() {
        if (this.lastCoordinates.size() > 0) {
            return (SpaceTime)this.lastCoordinates.getLast();
        }
        return null;
    }

    public void snapshot() {
        SpaceTime prevSpaceTime = null;
        if (this.lastCoordinates.size() > 0) {
            prevSpaceTime = (SpaceTime)this.lastCoordinates.getLast();
        }
        boolean reverseCondition = false;
        if (prevSpaceTime != null) {
            reverseCondition = Math.abs(this.heading - prevSpaceTime.getHeading()) > this.PI - this.PI / 6.0;
        }
        SpaceTime spaceTime = new SpaceTime(this.x, this.y, this.ctime, this.heading, reverseCondition);
        this.lastCoordinates.addLast(spaceTime);
        if (this.lastCoordinates.size() > 50) {
            this.lastCoordinates.removeFirst();
        }
        ++this.numSnapshots;
        this.last_x = this.x;
        this.last_y = this.y;
    }

    public Point2D.Double guessPosition(long when) {
        double newX;
        double newY;
        double diff = when - this.ctime;
        double proportionPredicted = 1.0;
        double proportionReversed = 0.0;
        if (Math.abs(this.changehead) > 1.0E-5) {
            double radius = this.speed / this.changehead;
            double tothead = diff * this.changehead;
            newY = this.y + proportionPredicted * (Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius) - proportionReversed * (Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius);
            newX = this.x + proportionPredicted * (Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius) - proportionReversed * (Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius);
        } else {
            double ydistance = Math.cos(this.heading) * this.speed * diff;
            double xdistance = Math.sin(this.heading) * this.speed * diff;
            newY = this.y + ydistance * (proportionPredicted - proportionReversed);
            newX = this.x + xdistance * (proportionPredicted - proportionReversed);
        }
        if (this.name.startsWith("labg") || this.name.startsWith("aac2") || this.name.startsWith("csm")) {
            return new Point2D.Double(this.x, this.y);
        }
        return new Point2D.Double(newX, newY);
    }

    public double getBearing() {
        return this.bearing;
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }

    public double getChangehead() {
        return this.changehead;
    }

    public void setChangehead(double changehead) {
        this.changehead = changehead;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        if (!this.firstScan) {
            this.roundsSinceLastScan = ctime - this.ctime;
        }
        this.firstScan = false;
        this.ctime = ctime;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public boolean isJiggling() {
        return this.jiggling;
    }

    public void setJiggling(boolean jiggling) {
        this.jiggling = jiggling;
    }

    public double getJiggleTime1() {
        return this.jiggleTime1;
    }

    public void setJiggleTime1(double jiggleTime1) {
        this.jiggleTime1 = jiggleTime1;
    }

    public double getJiggleTime2() {
        return this.jiggleTime2;
    }

    public void setJiggleTime2(double jiggleTime2) {
        this.jiggleTime2 = jiggleTime2;
    }

    public TargetStatistic getTargetStatistic() {
        return this.targetStatistic;
    }

    public void setTargetStatistic(TargetStatistic targetStatistic) {
        this.targetStatistic = targetStatistic;
    }

    public double getDamageInflicted() {
        return this.damageInflicted;
    }

    public void setDamageInflicted(double damageInflicted) {
        this.damageInflicted = damageInflicted;
    }

    public long getRoundsSinceLastScan() {
        return this.roundsSinceLastScan;
    }

    public void setRoundsSinceLastScan(long roundsSinceLastScan) {
        this.roundsSinceLastScan = roundsSinceLastScan;
    }
}

