/*
 * Decompiled with CFR 0.152.
 */
package Gecko;

import Gecko.advancedEnemyBot;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ultimateGeckoBot
extends AdvancedRobot {
    public static final double ALLERT_DISTANCE = 200.0;
    public static final double MOVEMENT = 300.0;
    public static final double SHOOT_POWER = 600.0;
    public static final int BULLET_BEFORE_MOVING = 3;
    public static final double MAX_TURN_REMAINING = 5.0;
    private advancedEnemyBot enemy = new advancedEnemyBot();
    private int count = 0;

    public void run() {
        this.setColors(Color.BLUE, Color.GREEN, Color.CYAN);
        this.setScanColor(Color.GREEN);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0 && this.enemy.none()) {
                this.setTurnRadarRight(10.0);
            }
            this.execute();
            this.geckoShoot();
            this.geckoMove();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.enemy.none() || e.getName().equals(this.enemy.getName()) || e.getDistance() < this.enemy.getDistance()) {
            this.enemy.update(e, (Robot)this);
        }
        this.setTurnRadarRight(this.normalizeBearing(this.getHeading() - this.getRadarHeading() + e.getBearing()));
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(this.enemy.getName())) {
            this.out.println("Gecko: " + this.enemy.getName() + " is dead!");
            this.enemy.reset();
        }
    }

    private void geckoMove() {
        this.setTurnRight(this.normalizeBearing(this.enemy.getBearing() + 90.0));
        Random random = Utils.getRandom();
        if (this.getDistanceRemaining() == 0.0) {
            double movement;
            double speed;
            do {
                double a = 100.0 * random.nextDouble();
                double b = 100.0 * random.nextDouble();
                speed = -200.0 * Math.sin((double)this.getTime() / a) * a * (1.0 / Math.pow(a, 2.0)) * Math.sin((double)this.getTime() / b) + 200.0 * Math.cos((double)this.getTime() / a) * Math.cos((double)this.getTime() / b) * b * (1.0 / Math.pow(b, 2.0));
                movement = 200.0 * Math.sin((double)this.getTime() / b) * Math.cos((double)this.getTime() / a);
            } while (speed > 8.0 && speed < 7.0);
            this.setAhead(movement);
            this.out.println("Gecko: moving " + movement);
        }
    }

    private void geckoShoot() {
        double firePower = Math.min(600.0 / this.enemy.getDistance(), 3.0);
        double bulletSpeed = 20.0 - firePower * 3.0;
        long time = (long)(this.enemy.getDistance() / bulletSpeed);
        double futureX = this.enemy.getFutureX(time);
        double futureY = this.enemy.getFutureY(time);
        double absDeg = this.absoluteBearing(this.getX(), this.getY(), futureX, futureY);
        this.setTurnGunRight(this.normalizeBearing(absDeg - this.getGunHeading()));
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 5.0) {
            this.setFire(firePower);
            ++this.count;
        }
    }

    private double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    private double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }
}

