/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.strategy.fire;

import de.simpleworks.robocode.botUtil.AngleCalc;
import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.CsCalc;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;

public abstract class FireStrategy {
    private Coordinate FTargetPos = null;
    private Coordinate FMyPos = null;
    private RobotStatus FMyStatus = null;
    private double FTargetVelocity = 0.0;
    private double FTargetHeading = 0.0;
    private double FTargetDistance = 0.0;
    private double FAngVelDPS = 0.0;
    private double FBFHeigh = 0.0;
    private double FBFWid = 0.0;

    protected double getBFHeigh() {
        return this.FBFHeigh;
    }

    protected double getBFWid() {
        return this.FBFWid;
    }

    protected Coordinate getTargetPos() {
        return this.FTargetPos;
    }

    protected Coordinate getMyPos() {
        return this.FMyPos;
    }

    protected double getTargetVelocity() {
        return this.FTargetVelocity;
    }

    protected double getTargetHeading() {
        return this.FTargetHeading;
    }

    protected double getTargetDistance() {
        return this.FTargetDistance;
    }

    protected double getMyHeading() {
        return this.FMyStatus.getHeading();
    }

    protected double getGunHeat() {
        return this.FMyStatus.getGunHeat();
    }

    protected double getAngVelDPS() {
        return this.FAngVelDPS;
    }

    protected abstract boolean canHit();

    public abstract boolean isGoodTarget();

    public abstract String getStrategyName();

    protected boolean canFire() {
        return this.getGunHeat() == 0.0;
    }

    public abstract double getGunAngle();

    public abstract double getEstimatedDist();

    public abstract double getPower();

    public void update(ScannedRobotEvent _sre, RobotStatus _rs, double angVelocityDegPerSec, double _bfHeigh, double _bfWid) {
        this.FMyStatus = _rs;
        this.FTargetVelocity = _sre.getVelocity();
        this.FTargetHeading = AngleCalc.absTargetPos(this.getMyHeading(), _sre.getBearing());
        this.FTargetDistance = _sre.getDistance();
        this.FAngVelDPS = angVelocityDegPerSec;
        this.FMyPos = new Coordinate(_rs.getX(), _rs.getY());
        this.FTargetPos = CsCalc.calcEndPoint(this.FMyPos, this.FTargetDistance, this.FTargetHeading);
        this.FBFHeigh = _bfHeigh;
        this.FBFWid = _bfWid;
    }

    public boolean willFire() {
        return this.canFire() && this.canHit() && this.isGoodTarget();
    }
}

