/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor;

import java.util.Arrays;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.PeakDensity;
import rdt.Wraith.Profiling.Profiler;
import robocode.util.Utils;

public final class KernelDensity {
    public static final int NumKernelDensityDivisions = 201;
    public final double[] Values = new double[201];
    public double MaxKernelDensity = 0.0;
    public double Mean = 0.0;
    public double StdDeviation = 0.0;
    public double FirstStdDeviation = 0.0;
    public static final int MaxNumPeaks = 6;
    public final PeakDensity[] SortedPeaks = new PeakDensity[6];

    public KernelDensity() {
        for (int index = 0; index < 6; ++index) {
            this.SortedPeaks[index] = new PeakDensity();
        }
        this.ResetPeaks();
    }

    public double GetNormalisedKernelDensity01(double lookupAt01) {
        int nearestDivision = (int)Math.round(((double)this.Values.length - 1.0) * lookupAt01);
        return this.Values[nearestDivision] / this.MaxKernelDensity;
    }

    public PeakDensity GetPeakToFill(double maxVal) {
        double lowestPeakVal = 1.0E7;
        PeakDensity lowestPeak = null;
        for (int peakIndex = 0; peakIndex < 6; ++peakIndex) {
            PeakDensity peak = this.SortedPeaks[peakIndex];
            if (!peak.Valid) {
                return peak;
            }
            if (!(peak.MaxValue < lowestPeakVal)) continue;
            lowestPeakVal = peak.MaxValue;
            lowestPeak = peak;
        }
        if (lowestPeak.MaxValue >= maxVal) {
            return null;
        }
        return lowestPeak;
    }

    public void SortPeaks() {
        Arrays.sort(this.SortedPeaks);
    }

    public double GetPeakValue01(int peakIndex, double forwardBandwidth, double rearBandwidth) {
        Profiler.StartScope("KernelDensity.GetPeakValue01");
        assert (this.SortedPeaks[peakIndex].Valid);
        PeakDensity peak = this.SortedPeaks[peakIndex];
        int halfBandwidthInDivisions = (int)Math.round(forwardBandwidth * 201.0 * 0.5);
        if (peak.MaxValueDivision < 100) {
            halfBandwidthInDivisions = (int)Math.round(rearBandwidth * 201.0 * 0.5);
        }
        int consecutiveCount = 0;
        double highestAvgTotal = 0.0;
        int highestCentreDivision = peak.StartDivision;
        for (int centreDivision = peak.StartDivision; centreDivision <= peak.EndDivision; ++centreDivision) {
            int checkMin = Math.max(0, centreDivision - halfBandwidthInDivisions);
            int checkMax = Math.min(200, centreDivision + halfBandwidthInDivisions);
            double checkTotal = 0.0;
            for (int checkIndex = checkMin; checkIndex <= checkMax; ++checkIndex) {
                checkTotal += this.Values[checkIndex];
            }
            double NumDivisions = checkMax - checkMin + 1;
            double checkAvg = checkTotal / NumDivisions;
            if (checkAvg > highestAvgTotal) {
                highestCentreDivision = centreDivision;
                highestAvgTotal = checkAvg;
                consecutiveCount = 0;
                continue;
            }
            if (!Utils.isNear((double)checkAvg, (double)highestAvgTotal)) continue;
            ++consecutiveCount;
        }
        Profiler.EndScope();
        double highestDivision01 = ((double)highestCentreDivision + 0.5) / 201.0;
        if (consecutiveCount > 0) {
            double maxConsecutiveDivision01 = ((double)(highestCentreDivision + consecutiveCount) + 0.5) / 201.0;
            return highestDivision01 + (maxConsecutiveDivision01 - highestDivision01) * 0.5;
        }
        return highestDivision01;
    }

    public void ResetPeaks() {
        for (int index = 0; index < 6; ++index) {
            this.SortedPeaks[index].Valid = false;
        }
    }

    public boolean IsValidPeak(int peakIndex) {
        return this.SortedPeaks[peakIndex].Valid;
    }

    public double GetPeakWeight(int peakIndex) {
        assert (this.IsValidPeak(peakIndex));
        return this.SortedPeaks[peakIndex].MaxValue / this.MaxKernelDensity;
    }
}

