/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import pedersen.misc.CalculatedValue;

public class RollingAverage
implements CalculatedValue {
    private final double rad;
    private final double raw;
    private double ra;
    private int sampleSize;
    private boolean thresholdMet = false;

    public RollingAverage(double newRollingAverageDepth, double newRollingAverageWeight) {
        this.rad = newRollingAverageDepth;
        this.raw = newRollingAverageWeight;
    }

    public void add(double value) {
        if (this.thresholdMet) {
            this.ra = this.calculateRollingAverage(value, this.rad);
        } else {
            int n;
            this.ra = this.calculateRollingAverage(value, this.sampleSize);
            this.sampleSize = (int)((double)this.sampleSize + 1.0);
            if ((double)n >= this.rad) {
                this.thresholdMet = true;
            }
        }
    }

    private double calculateRollingAverage(double value, double depth) {
        return (this.ra * depth + value * this.raw) / (depth + this.raw);
    }

    public double value() {
        return this.ra;
    }
}

