/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import bigpete.EnemyRobot;
import bigpete.EnemyRobotList;
import bigpete.Stewie;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;

public class Targeting {
    EnemyRobotList target_list;
    EnemyRobot best_target = null;
    Stewie robot;

    Targeting(Stewie robot_in, EnemyRobotList targets_in) {
        this.target_list = targets_in;
        this.robot = robot_in;
    }

    public void shoot() {
        if (this.bestTarget() == null) {
            return;
        }
        this.robot.turnGunTo(this.bestTarget().getRelativeBearing());
        if (this.robot.getGunHeat() != 0.0) {
            return;
        }
        if (this.robot.getEnergy() <= 0.1) {
            return;
        }
        Point2D target_position = new Point2D.Double();
        target_position.setLocation(this.bestTarget().getPosition());
        double distance = this.robot.currentPosition().distance(target_position);
        double fire_power = this.firePower(distance, this.robot.getEnergy());
        double bullet_speed = 20.0 - fire_power * 3.0;
        double angle = 0.0;
        long time_to = 0L;
        for (int i = 0; i < 5; ++i) {
            distance = this.robot.currentPosition().distance(target_position);
            time_to = (long)(distance / bullet_speed) + 1L + this.robot.gunTurnTime(angle);
            target_position = this.bestTarget().getFuturePosition(time_to);
            angle = CustFunct.pointsToBearing(this.robot.currentPosition(), target_position);
            this.robot.turnGunTo(angle);
        }
        if (((Point2D)target_position).getX() < 0.0 || ((Point2D)target_position).getY() < 0.0 || ((Point2D)target_position).getX() > this.robot.getBattleFieldWidth() || ((Point2D)target_position).getY() > this.robot.getBattleFieldHeight()) {
            return;
        }
        this.robot.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this.robot));
        this.robot.fire(fire_power);
    }

    private double firePower(double distance, double energy) {
        return Math.min(Math.min(800.0 / distance, 3.0), energy - 0.1);
    }

    public EnemyRobot bestTarget() {
        int tmp = 0;
        double closest = Double.MAX_VALUE;
        for (int i = 0; i < this.target_list.getNumber(); ++i) {
            double distance = this.target_list.getRobot(i).getDistance();
            if (!(distance < closest)) continue;
            tmp = i;
            closest = distance;
        }
        return this.target_list.getRobot(tmp);
    }
}

