/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.GunnerCommand;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.BulletPowerUtils;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.Rules;

public class GunnerBlastEnemy
implements GunnerCommand {
    private double shootingPowerDecayFactor;
    private int remainingBullets = 5;
    private EnemyRobot enemy;
    private CommandBasedRobot myRobot;
    private Location impactLocation;
    private double impactSuccessRating;
    private AimingStrategy impactAimingStrategy;
    private AimingStrategy previousAimingStrategy;
    private double impactBulletPower;
    private double fullPowerSuccess;
    private double shootingMaxPower;
    private long impactTimeOfPreviousShot = -5L;
    private Location impactLocationOfPreviousShot;
    private long numberOfPlannedMoves = 0L;
    private boolean keepAlive = false;
    double keepAliveLimit = 0.05;

    public GunnerBlastEnemy(CommandBasedRobot myRobot, EnemyRobot enemy, int remainingBullets, double fullPowerSuccess, double shootingPowerDecayFactor) {
        this.enemy = enemy;
        this.myRobot = myRobot;
        this.fullPowerSuccess = fullPowerSuccess;
        this.remainingBullets = remainingBullets;
        this.shootingPowerDecayFactor = shootingPowerDecayFactor;
        this.shootingMaxPower = 3.0;
        this.setupAimingStrategies();
        this.setImpactLocation();
    }

    @Override
    public boolean isDone() {
        return !this.enemy.isAlive();
    }

    @Override
    public double getRightTurn() {
        if (this.impactLocation != null) {
            double requiredHeading = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), this.impactLocation);
            return Geometry.getRelativeBearing(this.myRobot.getGunHeading(), requiredHeading);
        }
        return 0.0;
    }

    @Override
    public AimingStrategy getAimingStrategy() {
        return this.impactAimingStrategy;
    }

    private void setImpactLocation() {
        if (this.myRobot.getGunHeat() / this.myRobot.getGunCoolingRate() > 5.0) {
            this.impactLocation = this.enemy.getLatestRadarObservation().getLocation();
        } else {
            this.impactBulletPower = this.getMaximumBulletPower();
            this.calculateBestImpactLocation();
            if (this.impactSuccessRating < this.fullPowerSuccess) {
                double highBulletPower = this.impactBulletPower;
                Location highTargetLocation = this.impactLocation;
                double highSuccessRating = this.impactSuccessRating;
                this.impactBulletPower = this.getLowerBulletPower();
                this.calculateBestImpactLocation();
                if (this.getRateOfDamage(this.impactBulletPower, this.impactLocation, this.impactSuccessRating) < this.getRateOfDamage(highBulletPower, highTargetLocation, highSuccessRating)) {
                    this.impactBulletPower = highBulletPower;
                    this.impactLocation = highTargetLocation;
                    this.impactSuccessRating = highSuccessRating;
                }
            }
        }
    }

    private double getRateOfDamage(double bulletPower, Location impactLocation, double successRating) {
        long timeBetweenShots = Math.round(Rules.getGunHeat((double)bulletPower) / BattleConstants.getInstance().getGunCoolingRate());
        double damagePerShot = Rules.getBulletDamage((double)bulletPower);
        return damagePerShot / (double)timeBetweenShots * successRating;
    }

    private double getLowerBulletPower() {
        return this.impactBulletPower * 0.75;
    }

    private void calculateBestImpactLocation() {
        double bulletSpeed = Rules.getBulletSpeed((double)this.impactBulletPower);
        String category = this.myRobot.getShootingCategory(this.enemy, bulletSpeed);
        this.impactLocation = null;
        if (this.previousAimingStrategy != null && this.previousAimingStrategy.isUnfinishedPattern()) {
            this.impactAimingStrategy = this.previousAimingStrategy;
            this.impactSuccessRating = this.impactAimingStrategy.getEstimatedSuccessOfShot(category, bulletSpeed);
            this.impactLocation = this.impactAimingStrategy.getTargetForShot(bulletSpeed);
        }
        if (this.impactLocation == null) {
            this.impactSuccessRating = -99.0;
            for (AimingStrategy strategy : this.enemy.getAimingStrategies()) {
                double estimatedSuccess = strategy.getEstimatedSuccessOfShot(category, bulletSpeed);
                if (!(estimatedSuccess > this.impactSuccessRating)) continue;
                this.impactSuccessRating = estimatedSuccess;
                this.impactAimingStrategy = strategy;
            }
            if (this.impactAimingStrategy != null) {
                this.impactLocation = this.impactAimingStrategy.getTargetForShot(bulletSpeed);
            }
        }
    }

    private void setupAimingStrategies() {
        if (this.enemy.getAimingStrategies().isEmpty()) {
            this.myRobot.setupEnemyStrategies(this.enemy);
        }
    }

    @Override
    public double getFire() {
        if (this.impactLocation != null && this.impactSuccessRating >= 0.0 && this.impactLocation.isOnBattlefield(this.myRobot.getBattleFieldWidth(), this.myRobot.getBattleFieldHeight()) && this.enemy.isAlive() && this.impactBulletPower > 0.0 && this.myRobot.getGunTurnRemaining() == 0.0 && this.numberOfPlannedMoves >= 2L && this.enemy.getLatestRadarObservation() != null && this.enemy.getLatestRadarObservation().getTimeSeen() == this.myRobot.getTime()) {
            return this.impactBulletPower;
        }
        return 0.0;
    }

    private double getMaximumBulletPower() {
        if (this.myRobot.getEnergy() < 0.1 && this.enemy.getLatestRadarObservation().getEnergy() > 0.0) {
            return 0.0;
        }
        double safeMaxPower = this.myRobot.getEnergy() / (double)(this.remainingBullets + 1);
        double enemyEnergy = this.enemy.getLatestRadarObservation().getEnergy();
        if (this.keepAlive) {
            enemyEnergy -= this.keepAliveLimit;
        }
        double optimumKillingPower = 3.0;
        if (Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), this.enemy.getLatestRadarObservation().getLocation()) > 100.0 && (enemyEnergy < 20.0 || this.enemy.getDamageRatio() < 20.0)) {
            optimumKillingPower = BulletPowerUtils.getAverageBulletPowerToDestroy(enemyEnergy);
        }
        if (this.keepAlive && enemyEnergy <= this.keepAliveLimit) {
            optimumKillingPower = 0.0;
        }
        double result = Math.min(safeMaxPower, Math.min(this.shootingMaxPower, optimumKillingPower));
        if (this.myRobot.getOthers() == 1 && this.myRobot.getEnemies().getNumberOfEnemies() <= 2 && result > 2.5 && Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), this.enemy.getLatestRadarObservation().getLocation()) > 300.0) {
            result = 2.5;
        }
        return result;
    }

    @Override
    public void executed() {
        this.keepAlive = false;
        if (this.myRobot.getJustFired()) {
            this.shootingMaxPower *= this.shootingPowerDecayFactor;
            this.impactTimeOfPreviousShot = this.myRobot.getTime() + Math.round(Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), this.impactLocation) / Rules.getBulletSpeed((double)this.impactBulletPower));
            this.impactLocationOfPreviousShot = this.impactLocation;
            this.previousAimingStrategy = this.impactAimingStrategy;
        }
        this.setImpactLocation();
        this.numberOfPlannedMoves = this.impactLocation == null ? 0L : ++this.numberOfPlannedMoves;
        for (AimingStrategy strategy : this.enemy.getAimingStrategies()) {
            strategy.processTurn();
        }
    }

    @Override
    public EnemyRobot getEnemyTarget() {
        return this.enemy;
    }

    public static void displayAimingDebugStats() {
    }

    @Override
    public void hitEnemy(EnemyRobot enemy) {
        this.shootingMaxPower = 3.0;
    }

    @Override
    public void paint(Graphics2D g) {
        this.enemy.drawCircle(g, Color.WHITE, 45);
    }
}

