/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.key;

import robocode.util.Utils;

public class TimeAndHeadingKey {
    private int heading;
    private int time;
    private byte zone;
    private byte velocity;

    public TimeAndHeadingKey(long time, double heading, double velocity, byte zone) {
        if (velocity < 0.0) {
            heading += 180.0;
            velocity = -velocity;
        }
        heading = Utils.normalNearAbsoluteAngleDegrees((double)heading);
        this.time = (int)(time / 2L);
        this.zone = zone == 1 || zone == 5 || zone == 21 || zone == 25 ? (byte)1 : (zone < 4 || zone > 21 ? (byte)2 : (zone == 6 || zone == 10 || zone == 11 || zone == 15 || zone == 16 || zone == 20 ? (byte)3 : (byte)4));
        this.heading = 0;
        this.velocity = 0;
    }

    public String toString() {
        return this.time * 5 + ":" + this.heading * 45 + ":" + this.velocity * 2 + ":" + this.zone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.heading;
        result = 31 * result + this.time;
        result = 31 * result + this.velocity;
        result = 31 * result + this.zone;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeAndHeadingKey other = (TimeAndHeadingKey)obj;
        if (this.heading != other.heading) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if (this.velocity != other.velocity) {
            return false;
        }
        return this.zone == other.zone;
    }
}

