/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import robocode.AdvancedRobot;
import robocode.util.Utils;

abstract class State {
    protected List<Change> changes = new LinkedList<Change>();
    protected int speed;
    protected double lkh = 0.0;

    public abstract Change amIStillHere(AdvancedRobot var1, SelfTracking var2, Opponent var3, long var4, State[] var6, boolean var7, long var8, boolean var10, long var11, long var13, double var15) throws Exception;

    public double getLikelihood() {
        return this.lkh;
    }

    public void deleteChange(Change change) {
        this.changes.remove(change);
    }

    public State(int n) {
        this.speed = n;
    }

    public void increaseNoChangeLikelihood(long l, boolean bl, long l2, long l3, double d) {
        this.lkh += 1.0;
    }

    public double advancePosition(Position position, double d, double d2, int n) {
        if (this.speed == 0 || n == 0) {
            return d;
        }
        position.check();
        Position position2 = new Position(position);
        position.modify(1L, this.speed * n, d);
        position.adjustForWalls(position2, 1, null, 0.0, n == -1 ? Utils.normalAbsoluteAngle((double)(d + Math.PI)) : d);
        return d;
    }

    public Change advance(Position position, long l, boolean bl, long l2, long l3, double d) {
        Iterator<Change> iterator = this.changes.iterator();
        if (this.changes.isEmpty()) {
            return null;
        }
        LinkedList<Change> linkedList = new LinkedList<Change>();
        double d2 = 0.0;
        double d3 = this.lkh;
        while (iterator.hasNext()) {
            Change change = iterator.next();
            if (!change.isApplicable(l, bl, l2, l3, d)) continue;
            d2 += change.getLikelihood();
            linkedList.add(change);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        double d4 = Utils.getRandom().nextDouble() * (d3 + d2);
        if (d4 < d3) {
            return null;
        }
        iterator = linkedList.iterator();
        d2 = d3;
        while (iterator.hasNext()) {
            Change change = iterator.next();
            if (!(d4 <= (d2 += change.getLikelihood()))) continue;
            return change;
        }
        assert (false);
        return null;
    }

    protected Change checkChanges(Change change, long l, boolean bl, long l2, long l3, double d) {
        for (Change object : this.changes) {
            if (!change.isSpecialCaseOf(object)) continue;
            return object;
        }
        this.changes.add(change);
        if (this.changes.size() > 4) {
            LinkedList<Change> linkedList = new LinkedList<Change>();
            ListIterator<Change> listIterator = this.changes.listIterator();
            Change change2 = null;
            Change change3 = null;
            double d2 = 0.0;
            while (listIterator.hasNext()) {
                Change change4 = listIterator.next();
                listIterator.remove();
                linkedList.add(change4);
                ListIterator<Change> listIterator2 = this.changes.listIterator();
                while (listIterator2.hasNext()) {
                    Change change5 = listIterator2.next();
                    double d3 = change4.cmp(change5);
                    if (!(d3 > d2)) continue;
                    change2 = change4;
                    change3 = change5;
                    d2 = d3;
                }
            }
            if (change2 != null) {
                Log.log(3, "Generalizing " + change2 + " with " + change3);
                change2.generalizeWith(change3);
                Log.log(3, "  result " + change2);
            }
            this.changes = linkedList;
            this.changes.remove(change3);
        }
        return change;
    }

    public void dumpChanges() {
        for (Change change : this.changes) {
            Log.log(4, "  " + change);
        }
    }

    public int getSpeed() {
        return this.speed;
    }
}

