/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.debug.Debug;
import pedersen.physics.StaticVelocity;

public class StaticVelocityImpl
implements StaticVelocity {
    private final double velocity;

    public StaticVelocityImpl(double newVelocity) {
        this.velocity = newVelocity;
    }

    public StaticVelocityImpl(StaticVelocity other) {
        this.velocity = other.getVelocity();
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getRelativeVelocity(double other) {
        return StaticVelocityImpl.getRelativeVelocity(this.velocity, other);
    }

    public double getCompoundVelocity(double other) {
        return StaticVelocityImpl.getCompoundVelocity(this.velocity, other);
    }

    public static double getRelativeVelocity(double a, double b) {
        return b - a;
    }

    public static double getCompoundVelocity(double a, double b) {
        return a + b;
    }

    public void debug() {
        Debug.debug("Static velocity: " + this.velocity);
    }
}

