/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.move;

import catcat20.core.bot.Bot;
import catcat20.core.bot.BotState;
import catcat20.core.move.Surfing;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.TeamRobot;
import robocode.util.Utils;

public class NonWaveMove {
    public TeamRobot robot;
    public boolean isMelee = false;
    public String myName;
    Rectangle2D.Double field;
    Point2D.Double myPos;
    Point2D.Double centerPos;
    double myEnergy;

    public NonWaveMove(TeamRobot _robot) {
        this.robot = _robot;
        this.field = new Rectangle2D.Double(0.0, 0.0, this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight());
        this.myName = this.robot.getName();
        this.centerPos = new Point2D.Double(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
    }

    public void onTick() {
        BotState en;
        this.myEnergy = this.robot.getEnergy();
        this.isMelee = this.robot.getOthers() > 1;
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Bot nearestBot = Radar.nearestBot;
        if (nearestBot != null && (en = nearestBot.currentState) != null) {
            Graphics2D g = this.robot.getGraphics();
            ArrayList<Pos> poss = new ArrayList<Pos>();
            Pos bestPos = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            Line2D.Double myEnLine = new Line2D.Double(this.myPos.x, this.myPos.y, en.x, en.y);
            double dist = en.distance(this.myPos.x, this.myPos.y);
            if (!this.isMelee) {
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double ran = Math.random() * 36.0;
                    double directions = 36.0;
                    if (Surfing.DIA_MODE || Surfing.TRON_MODE) {
                        directions = 4.0;
                    }
                    int i = 0;
                    while (i < 360) {
                        double length = Math.random() * dist;
                        Pos pos = new Pos();
                        double angle = Math.toRadians((double)i + ran);
                        if (Surfing.DIA_MODE || Surfing.TRON_MODE) {
                            angle = Math.toRadians((double)i + ran / 2.0 - 9.0);
                        }
                        if (Surfing.DIA_MODE) {
                            angle += 0.7853981633974483;
                        }
                        pos.pos = LUtils.project(this.myPos, angle, length);
                        pos.pos = this.chkOutOfField(pos.pos);
                        if (!(myEnLine.ptLineDist(pos.pos) <= 20.0)) {
                            pos.risk = this.getRisk(pos.pos, en);
                            if (bestRisk > pos.risk) {
                                bestPos = pos;
                                bestRisk = pos.risk;
                            }
                            poss.add(pos);
                        }
                        i = (int)((double)i + 360.0 / directions);
                    }
                }
            } else {
                double count = 100.0;
                double length = 100.0 + Math.random() * 100.0;
                length = Math.min(this.myPos.distance(en.x, en.y), length);
                for (double i = 0.0; i < 360.0; i += 360.0 / count) {
                    Pos pos = new Pos();
                    pos.pos = LUtils.project(this.myPos, Math.toRadians(i), length);
                    pos.pos = this.chkOutOfField(pos.pos);
                    if (myEnLine.ptLineDist(pos.pos) <= 20.0) continue;
                    pos.risk = this.getRisk(pos.pos, en);
                    if (bestRisk > pos.risk) {
                        bestPos = pos;
                        bestRisk = pos.risk;
                    }
                    poss.add(pos);
                }
            }
            if (bestPos != null) {
                this.goTo(bestPos.pos.x, bestPos.pos.y);
            }
            double[] risks = new double[poss.size()];
            int x = 0;
            double lowestRisk = Double.POSITIVE_INFINITY;
            double highestRisk = Double.NEGATIVE_INFINITY;
            for (Pos riskPos : poss) {
                risks[x++] = riskPos.risk;
                if (riskPos.risk < lowestRisk) {
                    lowestRisk = riskPos.risk;
                }
                if (!(riskPos.risk > highestRisk)) continue;
                highestRisk = riskPos.risk;
            }
            double avg = NonWaveMove.average(risks);
            double stDev = NonWaveMove.standardDeviation(risks);
            for (Pos riskPos : poss) {
                g.setColor(NonWaveMove.riskColor(riskPos.risk - lowestRisk, avg - lowestRisk, stDev, true, 1.0));
                if (riskPos.risk <= bestRisk || riskPos.risk <= lowestRisk) {
                    g.setColor(Color.yellow);
                }
                g.fillOval((int)riskPos.pos.x - 3, (int)riskPos.pos.y - 3, 6, 6);
            }
            if (bestPos != null) {
                g.setColor(Color.yellow);
                g.fillOval((int)bestPos.pos.x - 5, (int)bestPos.pos.y - 5, 10, 10);
            }
            double bestMaxVelocity = 8.0;
            if (Surfing.RABBIT_MODE) {
                bestMaxVelocity = Surfing.getRabbitVelocity(this.robot.getTime());
            } else if (Surfing.CURVE_DECEL && Math.abs(this.robot.getTurnRemaining()) > 22.5) {
                bestMaxVelocity = 3.0;
            }
            this.robot.setMaxVelocity(bestMaxVelocity);
            if (nearestBot != null && nearestBot.currentState != null && nearestBot.currentState.energy <= 0.0) {
                this.goTo(nearestBot.currentState.x, nearestBot.currentState.y);
            }
        }
    }

    public double getDuelRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        double absBearing = LUtils.absoluteBearing(enemy.x, enemy.y, this.myPos.x, this.myPos.y);
        double goAngle = LUtils.absoluteBearing(this.myPos, pos);
        double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
        sui = Math.pow(sui, 0.15);
        double dist = pos.distance(enemy.x, enemy.y) * 1.5;
        risk += 60.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        if (enemy.energy < 1.0) {
            risk -= 120.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        }
        for (double[] edge : this.getEdges()) {
            risk += 5.0 / (1.0 + Line2D.ptSegDistSq(edge[0], edge[1], edge[2], edge[3], pos.x, pos.y));
        }
        for (double[] corner : this.getCorners()) {
            corner[0] = (corner[0] + enemy.x) / 2.0;
            corner[1] = (corner[1] + enemy.y) / 2.0;
            if (!(Point2D.Double.distanceSq(enemy.x, enemy.y, corner[0], corner[1]) < 22500.0)) continue;
            risk += 5.0 / (1.0 + pos.distanceSq(corner[0], corner[1]));
        }
        return risk;
    }

    public double getMeleeRisk(Point2D.Double pos) {
        double risk = 0.0;
        double goAngle = LUtils.absoluteBearing(this.myPos, pos);
        for (Bot bot : Radar.enemyList) {
            if (!bot.isAlive || bot.currentState == null) continue;
            BotState en = bot.currentState;
            double energyRatio = Math.min(en.energy / this.myEnergy, 2.0);
            double distance = pos.distance(en.x, en.y);
            int closer = Radar.botsCloser(distance * distance * 0.8);
            double absBearing = LUtils.absoluteBearing(en.x, en.y, pos.x, pos.y);
            double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
            risk += energyRatio * (1.0 + sui) / (distance * (double)closer * Math.pow(this.centerPos.distanceSq(pos), 0.125));
        }
        return risk;
    }

    public double getRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        risk = !this.isMelee ? (risk += this.getDuelRisk(pos, enemy)) : (risk += this.getMeleeRisk(pos));
        return risk;
    }

    public double[][] getCorners() {
        return new double[][]{{this.field.x, this.field.y}, {this.field.x, this.field.y + this.field.getHeight()}, {this.field.x + this.field.width, this.field.y}, {this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public double[][] getEdges() {
        return new double[][]{{this.field.x, this.field.y, this.field.x + this.field.width, this.field.y}, {this.field.x, this.field.y, this.field.x, this.field.y + this.field.height}, {this.field.x, this.field.y + this.field.height, this.field.x + this.field.width, this.field.y + this.field.height}, {this.field.x + this.field.width, this.field.y, this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public Point2D.Double chkOutOfField(Point2D.Double p) {
        return new Point2D.Double(LUtils.limit(35.0, p.x, this.field.width - 35.0), LUtils.limit(35.0, p.y, this.field.height - 35.0));
    }

    private void goTo(double x, double y) {
        double angleToTarget = Math.atan2(x -= this.robot.getX(), y -= this.robot.getY());
        if (Surfing.ZIGZAG && Math.abs(this.robot.getVelocity()) > 4.0) {
            angleToTarget += Surfing.getZigZag(this.robot.getTime());
        }
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - this.robot.getHeadingRadians()));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        this.robot.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            this.robot.setAhead(distance);
        } else {
            this.robot.setBack(distance);
        }
    }

    public static double standardDeviation(double[] values) {
        double avg = NonWaveMove.average(values);
        double sumSquares = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sumSquares += NonWaveMove.square(avg - values[x]);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sum += values[x];
        }
        return sum / (double)values.length;
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)LUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)LUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0));
    }

    public class Pos {
        public Point2D.Double pos;
        public double risk;
    }
}

