/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;
import java.lang.Math;

/* Utility methods useful in robot computations etc.
 */
public class Util
{
   /* normalizes given angle in radians so that
    * 0 <= angle < 2*pi
    */
   public static double normalAbsoluteAngle( double radians )
   {
      return robocode.util.Utils.normalAbsoluteAngle( radians );
   }
   
   /* normalizes given angle in radians so that
    * -pi <= angle < pi
    */
   public static double normalRelativeAngle( double radians )
   {
      return robocode.util.Utils.normalRelativeAngle( radians );
   }
   
   /* returns a random double number between min and max
    */
   public static double randomDouble( double min, double max )
   {
      return min + Math.random() * ( max - min );
   }
   
   /* returns a random long integer number between min and max inclusive
    */
   public static long randomLong( long min, long max )
   {
      return Math.round( randomDouble( ((double)min)-0.49, ((double)max)+0.49 ) );
   }
   
   /* clips given value to the given boundaries so that
    * minimum <= result <= maximum;
    * if maximum < minimum they are swapped
    */
   public static double clipDouble( double value, double minimum, double maximum )
   {
      if ( minimum > maximum ) {
         double swapValue = maximum;
         maximum = minimum;
         minimum = swapValue;
      }
      
      if ( value < minimum )
         value = minimum;
      else if ( value > maximum )
         value = maximum;
         
      return value;
   }
  
   // random number generator used to generatore gaussian distributed numbers
   static java.util.Random randomNumberGenerator = new java.util.Random();
  
   public static double randomGaussian()
   {
      return randomNumberGenerator.nextGaussian();
   }
  

}