package asd.gun.neuralib;

/**
 * Current code size of these file is 433 and whole library is 591
 * can be around 500 if you don't use momentum, bias check comment to see shrinking options
 *
 * If you want to use IO functions just uncomment the method init() in both files
 * to load use (nn=(NeuralNetwork)ois.readObject()).init();
 * codesize will be 657
 *
 * NeuralNetworkFloat files are half size of the double version
 *
 * if you have any questions, comment, bug report, or modification please e-mail me at synnalagma@hotmail.com
 *
 * These library is under LGPL license (you can use it whithout publishing the code, but must publish modification you make to this code) and is provided "as is" whithout any warranty
 *
 * @author Synnalagma
 * @version 1.2
 *
 * version history :
 *   0.9 first release
 *   1.0 shrinked to code size 390
 *   1.1 added momentum (avoid some local minima) code size 430
 *   1.2 codesize 433 changed some code possibly 430 or less reads comments
 *
 * Next :
 *	 your propositions
 */
public class NeuronLayer implements java.io.Serializable {
	//hard coded to reduce code size
	transient private double learningRate = 5.0, momentum=0.3;

	/**input size of these layer
	*/
	private int in;

	/**ouptut size of these layer
	*/
	private int out;


	/**Store temp data about output of these layer (temp => transient to reduce file size)
	*/
	private transient double[] output;

	
	/**Store temp data about error of these layer (temp => transient to reduce file size)
	 * removed
	*/
//	private transient double[] delta;

	
	/**Store temp data about input of these layer (temp => transient to reduce file size)
	*/
	private transient double[] input;

	/**weight connection the only thing saved (with size)
	*/
	private double[][] weight;

	/**last weight changes used for momentum
	 *Comment this if you don't want to use momentum
	*/
	private transient double[][] lastWeightChange;

	
	public NeuronLayer(int in, int out) {
		this.in = in;
		this.out = out;
		//change the next 3 lines with init(); if you use IO functions, should reduce codesize
		this.input = new double[in];
		output = new double[out];
		//Comment this if you don't want to use momentum remove +1 if you don't use bias
		this.lastWeightChange = new double[in + 1][out];
		//init();
		//remove +1 if you don't use bias
		weight = new double[in + 1][out];
		
	
//		delta = new double[in];
//Possible to comment the next lines, but you will need much more training
		for(int i = 0; i <= in; i++) {
			for(int o = 0; o < out; o++) {
				weight[i][o] = Math.random() - 0.5;
			}
		}
	}

	/**
	 * get the output for these layer
	 *
	 * @param inp input
	 *
	 * @return output
	 */
	public double[] getOutput(double[] inp) {
		/*for(int i=0;i<in;i++)     //Copy value for backpropagation
		{
		    this.input[i]=inp[i];
		}*/
		//Change the following line to gain 3 bytes, personnaly I don't like to generate to much object
		//If you make the change you can also remove the line this.input = new double[in] in the constructor and/or in the init() method and you gain more
		System.arraycopy(inp, 0, this.input, 0, in);
		//this.input=(double[])inp.clone();

		for(int o = 0; o < out; o++) {
			this.output[o] = 0;

			for(int i = 0; i <= in; i++) {//If you don't want to use bias change to i<in
				//If you don't want to use bias also change here ((i == in) ? 1 : input[i])) by input[i]
				output[o] += (weight[i][o] * ((i == in) ? 1 : input[i])); //compute the sum
			}

			//output[o]+=weight[in][o];		//bias
			output[o] = 1.0 / (1.0 + Math.exp(-output[o])); //function
		}

		return (double[])output.clone()/*output*/;          //output reused
	}

	/**
	 * backpropagation methode
	 *
	 * @param error error from last layer
	 *
	 * @return error for next layer
	 */
	public double[] propagate(double[] error) //error[o] is Sumk dk*wko
	 {
		double[] deltaE = new double[out], delta= new double[in];

		//changing weights
		for(int o = 0; o < out; o++) {
			deltaE[o] = error[o] * (output[o] * (1 - output[o])); //error signal

			for(int i = 0; i <= in; i++) {//If you don't want to use bias change to i<in
				//Comment this if you don't want to use momentum
				//also comment "this.lastWeightChange[i][o] = " next line
				weight[i][o] += (this.lastWeightChange[i][o] * 0.3) /*this.momentum*/;
				//If you don't want to use bias also change here ((i == in) ? 1 : input[i])) by input[i]
				weight[i][o]+= /*weight[i][o]+*/ (this.lastWeightChange[i][o] = 0.3 * deltaE[o] * ((i == in) ? 1 : input[i])) /*checking bias*/;
			}

			//weight[in][o]=weight[in][o]+this.learningRate*deltaE[o];	//bias
		}

		//computing error signals
		for(int i = 0; i < in; i++) {
			//delta[i] = 0;

			for(int o = 0; o < out; o++) {
				delta[i] += (deltaE[o] * weight[i][o]);
			}
		}

		return delta;
	}
	
	///////////////////////////////////////////////////////////////
	////Utility function changed to hard code (reduced code size)
	//////////////////////////////////////////////////////////////

	/*public int getInputSize(){return in;}
	public int getOutputSize(){return out;}*/
	/*public void randomizeWeight()
	{
	    for(int i=0; i<in+1;i++)
	    {
	        for(int o=0;o<out;o++)
	        {
	            weight[i][o]=Math.random()-0.5;
	        }
	    }
	}*/
	/*public static double sigmoid(double d)
	{
	    return 1.0/(1.0+Math.exp(-d));
	}*/
	///////////////////////////////////////////////////////////////////////
	///////IO functions
	//////////////////////////////////////////////////////////////////////

/*	public void init(){
		this.input = new double[in];
		output = new double[out];
		//Comment this if you don't want to use momentum remove +1 if you don't use bias
		this.lastWeightChange = new double[in + 1][out];
	}*/
}
