/*
 * Created on 24-oct-2004
 * 
 * $Id: AHEB.java,v 1.1.2.3 2004/10/24 19:00:18 lolo Exp $
 */
package mnt;

import java.awt.Color;

import robocode.*;
import mnt.utils.*;

/**
 * 									<b>-= AHEB =-</b>
 * 
 * Movimiento:	Esquiva las balas describiendo arcos alrededor del enemigo, en una
 * 				dirección aleatoria. (Ver la clase MovimientoEsquivaBalas).
 * 
 * Arma:		Utiliza un método estadístico conocido en <b><i>Robowiki</i></b>
 * 				como <b><i>Guess Factor</i></b>. Básicamente consiste en determinar
 * 				una función de probabilidad (o varias en este caso) para el
 * 				movimiento de nuestro contrincante, basándonos en factores como:
 * 				velocidad, distancia, aceleración, ... 
 * 				(Ver la clase Wave y WaveGun).
 * 
 * AHEB (Arma de (H)ondas, movimientoEsquivaBalas)(la 'H' es por que no me
 * 													gustaba AOEB)
 * 
 * @author Manuel Nogales
 */
public class AHEB extends AdvancedRobot {
    private WaveGun wg;
    
    private MovimientoEsquivaBalas meb;
    
    private Radar r;
    
    public void run(){
        setColors(new Color(170,150,20),new Color(170,150,20), new Color(170,150,20));
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        wg = new WaveGun(this);
        meb = new MovimientoEsquivaBalas(this);
        r = new Radar(this);
        setTurnRadarRight(360);
        addCustomEvent(new CondicionDeGiroDeRadarCompleto(this));
        while(true){
            meb.hacerMovimiento();
            execute();
        }
    }
    
    public void onScannedRobot (ScannedRobotEvent e){
        Enemigo en = new Enemigo(e, this);
        r.setObjetivo(en);
        wg.onScannedRobot(e);
        meb.onScannedRobot(e);
    }
    
    public void onCustomEvent (CustomEvent e){
        if(e.getCondition() instanceof CondicionDeGiroDeRadarCompleto){
            r.hacerGiro();
        }
    }
}
