package davidalves.net.gun;

import java.util.HashMap;
import java.util.Iterator;

import robocode.Bullet;

import davidalves.PhoenixOS;
import davidalves.net.util.*;

public class GuessFactorGunManager {
	GuessFactorGun[] guns;
	HashMap bullets = new HashMap();
	public int GF0;
	int minVisits;
	
	GuessFactorGun bestGun;
	
	public GuessFactorGunManager(GuessFactorGun[] guns, int minVisits){
		this.minVisits = minVisits;
		this.GF0 = guns[0].getGF0();
		this.guns = guns;
		this.bestGun = guns[0];
	}
	
	public GuessFactorGun getBestGun(RobotState shooter, RobotState target, double bulletPower){
		//int best = (int) Math.floor(Math.random() * guns.length);
		//*
		int best = 0;
		if(guns.length == 1) return guns[0];
		for(int i = 1; i < guns.length; i++){
			int[] segments = guns[i].getSegments(shooter, target, bulletPower);
			if(guns[i].getVisits(segments) > minVisits){
				best = i;	
			}
		}
		//*/
		//Phoenix.info("Best gun is " + best);
		bestGun = guns[best];
		return guns[best];
	}
	
	public GuessFactorGun getBestGun(){
		
		return bestGun;
	}
	
	public void doWave(Wave wave, Point impactPoint, double weight){
		for(int i = 0; i < guns.length; i++){
			//YALT.info("Entering data for gun " + i);
			guns[i].doWave(wave, impactPoint, weight);
		}
	}
	/*
	public void randomize(){
		for(int i = 0; i < guns.length; i++){
			guns[i].randomize();
		}
	}*/
	/*
	public void printUnsegmented(){
		String stats = ": ";
		for(int i = 0; i < GF0 * 2 + 1; i++) stats += " " + Math.round(guns[0].getScore(new int[]{0,0,0,0,0,0}, i, 0));		
		/YALT.info(stats);
	}
	*/
	public void printStats(){
		for(int i = 0; i < guns.length; i++)
		PhoenixOS.info(" Gun " + i + "    Shots: " + guns[i].getShotsFired() + " Accuracy: " + Utils.format(guns[i].getAccuracy()));
	}
	
	public void shotFired(GuessFactorGun gun, Bullet b){
		bullets.put(b, gun);
	}
	public void hit(Bullet b){
		GuessFactorGun gun = (GuessFactorGun) bullets.get(b);
		bullets.remove(b);
		gun.hit();
	}
	
	public void updateBulletTracker(boolean targetAlive){
		if(bullets.size() == 0) return;
		if(targetAlive){
			Iterator i = bullets.keySet().iterator();
			while(i.hasNext()){
				Bullet b = (Bullet) i.next();
				if(!b.isActive()){
					GuessFactorGun gun = (GuessFactorGun) bullets.get(b);
					gun.miss();
					i.remove();
				}
			}
		} else {
			bullets.clear();
		}
	}
	
	/*
	public int getShotsFired(int gun){
		return guns[gun].getShotsFired();
	}
	public int getHits(int gun){
		return guns[gun].getHits();
	}*/

	public void reset() {
		bullets.clear();
		for(int i = 0; i < guns.length; i++){
			//guns[i].printSegmentationInfo();
			guns[i].reset();
		}
	}
}
