package kvk.Radar;
import kvk.ExtendedRobot;
import kvk.Utils.C;
import kvk.Utils.Manager;
import robocode.*;

/**
 *  Classe de gestion des radars
 *
 * @author     Ssin.le.Terrible
 * @created    9 janvier 2004
 */
public class RadarManager extends Manager {
	//{{{*** VARIABLES
	private  Manager[]  radarList;                                                 //Liste des types de radars
	private  int        currentRadar;                                              //Position du radar en cours d'utilisation
	//**********************************************************//}}}

	public RadarManager(ExtendedRobot er) {
		super(er);
		radarList = new Manager[C.RADAR_MODES];
		// Initialisation des modes radar
		radarList[C.RADAR_FULL_ROTATION] = new RadarFullRotation(myBot);              //Radar  rotation permanente
		radarList[C.RADAR_SCAN_ALL] = new RadarScanAll(myBot);                        //Recherche de tous les bots
		// Initialisation du radar courant
		currentRadar = C.RADAR_SCAN_ALL;
	}

	/**
	 *  Action  raliser chaque tour
	 */
	public void action() {
		radarList[currentRadar].action();
	}

	/**
	 *  Rinitialisation  effectuer chaque round
	 */
	public void reinitialise() {
		// Initialisation du radar courant
		currentRadar = C.RADAR_SCAN_ALL;
		radarList[currentRadar].reinitialise();
	}
}

