package gh.ghutils;

import robocode.*;
import java.util.ArrayList;

public class EnFireEval {

	static ArrayList<Double> eFirePower = new ArrayList<Double>();
	static double eAvgFirePower;
	static int totalFireDelay;		// try to identify 'extends Robot'
	static int totalFired;

    // addFired: add a fired bullet to evaluate type of opponent.
    public static void addFired( long delay, double epow) {

		totalFireDelay += delay;
		totalFired++;
		putFirePower( epow);
	}

	// putFirePower: put in new fired bullet and calculate average enemy firepower
	public static void putFirePower( double bpow ) {
		eFirePower.add(0, bpow);
		eAvgFirePower = 0.0;
		int i = 0;
		while (i < 9 && i < eFirePower.size()) {
			double bpowa = (double)eFirePower.get(i);
			eAvgFirePower += bpowa;
			i++;
		}
		eAvgFirePower = eAvgFirePower / (double)i;
//		System.out.println("Average BPower last " + i +" shots = " + eAvgFirePower);
	}

	// checkFired: check if enemy could have fired while killed
	public static double checkFired( long fireoffset, double energy ) {
        double estBPow = 0.0;
		if ((fireoffset >= 0) && (energy > 0.09)) {
			estBPow = Math.max( 0.01, Math.min( eAvgFirePower, energy));
//			if (fireoffset > (getAvgFireDelay() * 2)) { estBPow = 0.0; }
		}
		return estBPow;
	}

	// isPeaShooter: determine if opponent is shooting only peas lately
    public static boolean isPeaShooter() {
        return (eAvgFirePower < 0.16);
    }

	// isRobot: determine if opponent is Robot
    public static boolean isRobot() {
        return (getAvgFireDelay() > 30);
    }

	// isPacifist: determine if opponent is not firing (anymore)
    public static boolean isPacifist( long time) {
        return (time > 50);
    }

	// getAvgFireDelay: get the average fire dely after firewindow is open (for Robot detection)
	static int getAvgFireDelay( ) {
		int avgdelay = 0;
		if (totalFired > 0) {
			avgdelay = totalFireDelay / totalFired;
		}
//		System.out.println("Average Fire Delay = " + avgdelay);
		return avgdelay;
	}

	
}
