package gh.ghutils;

import robocode.*;
import robocode.util.Utils;
import robocode.Rules;
import java.util.ArrayList;
import java.awt.geom.Point2D;

/**
 * TickState
 *
 * This class represents a the state of one tick.
 * Credit: Idea derived from the implementation of Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class TickState {
    private static ArrayList<BotState> enTickList;
    private static ArrayList<BotState> myTickList;

    private static Point2D.Double myPos;    
    private static Point2D.Double myNextPos = new Point2D.Double();    
    private static Point2D.Double enemyPos;    
    private static Point2D.Double enemyNextPos = new Point2D.Double();    

	public static long currTime;
    private static int battleRound;
	private static int battleSize;

	private static double absBearing;
	private static double enDistance;
    private static int  myDirection;
    private static double mySpeed;
	private static int  myAccBin;
	private static int  myVelBin;
	private static int  myWallBin;
	private static int  myDL14Bin;
	private static int  myTimeSinceVChange;
	private static double myFirePower;

	private static int  enDirection;
	private static double enSpeed;
	private static double enSpeedSign;
	private static int  enAccBin;
	private static int  enVelBin;
	private static int  enWallBin;
	private static int  enDL14Bin;
	private static int  enTimeSinceVChange;

	// anything about enemy firecontrol
	private static long fireWindowOpen;
    private static double enemyFirePower;
    private static double enemyAssumedFirePower; // did enemy fire while killed ?
	private static double energyDropCorrection;	// energydrop correction (wallhits, bullethits, collisions etc)
	private static boolean sittingDuck;

	private static int	  enemyCollision = 0;
	private static boolean enemyHitMe;

    // statistics
	private static int		wallhit;	// the total number of times I hit the wall
	private static double	wallhitdam;	// the total amount of damage due to wallhits
	private static int		b_hit_b;	// the total number of times my bullet hit his bullet
	private static int		bullhit;	// the total number of my bullets that hit	
	private static int		bullmis;	// the total number of my bullets that missed
	// virtual gun statistics
	public static int		gunfired;	// bullets fired that would have reached target
	// enemy gun statistics
	private static int		enemyfired;	// number of times enemy fired
	private static int		enemyhitme;	// number of times I got hit by a bullet

    // onScannedRobot: keep all relevant info of this tick
    public static void onScannedRobot(AdvancedRobot robot, ScannedRobotEvent e) {

		currTime = robot.getTime();
		absBearing = Utils.normalRelativeAngle(robot.getHeadingRadians() + e.getBearingRadians());
		enDistance = e.getDistance();
		// information about me
		double newSpeed = robot.getVelocity();
		myPos = new Point2D.Double( robot.getX(), robot.getY());

		// Calculating my next position does take acc/decel into account
		myNextPos.setLocation( GHUtils.doProjectPos( myPos, robot.getHeadingRadians(), GHUtils.getEstNextSpeed(newSpeed, mySpeed)));
//		myNextPos.setLocation( GHUtils.doProjectPos( myPos, robot.getHeadingRadians(), newSpeed));

		if (newSpeed != 0.0) {
            myDirection = ( newSpeed * Math.sin( e.getBearingRadians()) >= 0 ? 1 : -1);
		}

		if (Math.abs( newSpeed - mySpeed) > 0.5) {
			myAccBin = ( Math.abs(newSpeed) - Math.abs(mySpeed) > 0 ? 0 : 1);
			myTimeSinceVChange = 0;
		} else {
			myTimeSinceVChange++;
			if (myTimeSinceVChange < 6) myAccBin = 2;
			else if (myTimeSinceVChange < 16) myAccBin = 3;
			else myAccBin = 4;
		}
		myVelBin   = (int)((Math.abs( newSpeed) + 1.99) / 4);
		mySpeed = newSpeed;

 		// distance last 14 ticks segment
		if (myTickList.size() > 0) {
			myDL14Bin = (int)( myPos.distance((Point2D.Double)myTickList.get((Math.min(13, myTickList.size() - 1))).getPosition()) / 28);
			myDL14Bin = Math.min(myDL14Bin, 3);
		}

        BotState myTick =
            new BotState(
				myPos,
				absBearing,
				e.getBearingRadians(),
                robot.getHeadingRadians(),
				enDistance,
				Math.abs(mySpeed),		// why absolute value ??
				robot.getEnergy(),
				myDirection,
				myAccBin,
				myVelBin,
				myWallBin,
				myDL14Bin,
				currTime);
				
        myTickList.add(0, myTick);
		if (myTickList.size() < 3) {
			myTickList.add(0, myTick);
			if (myTickList.size() < 3) {
			    myTickList.add(0, myTick);
			}
		}
        // if we are over the scan limit, drop the oldest data
        if (myTickList.size() > 20) {
            myTickList.remove(20);
        }

		// information about enemy
		sittingDuck = (e.getEnergy() == 0.0) && (e.getVelocity() == 0.0);
		enemyPos = GHUtils.doProjectPos( myPos, absBearing, enDistance);		
		// Calculating next enemy position does take acc/decel into account
		enemyNextPos.setLocation(GHUtils.doProjectPos( enemyPos, e.getHeadingRadians(), GHUtils.getEstNextSpeed(e.getVelocity(), enSpeed)));
//		enemyNextPos.setLocation(GHUtils.doProjectPos( enemyPos, e.getHeadingRadians(), e.getVelocity()));
		double latVelocity = e.getVelocity() * Math.sin( e.getHeadingRadians() - absBearing);
		if (latVelocity != 0.0) { enDirection = (int)Math.signum( latVelocity); }

		// calculate the active segments of the attributes for this tick
		enVelBin = (int)((Math.abs( latVelocity) + 2.0) / 4.5);
		// accelerationsegment, ignore small variances in speed
		if (Math.abs( e.getVelocity() - enSpeed) > 0.9) {
			enAccBin = (Math.abs( e.getVelocity()) - Math.abs( enSpeed) > 0 ? 0 : 1);
			enTimeSinceVChange = 0;
		}
		else {
			enTimeSinceVChange++;
			if (enTimeSinceVChange < 6 ) enAccBin = 2;
			else if (enTimeSinceVChange < 16) enAccBin = 3;
			else if (enTimeSinceVChange < 36) enAccBin = 4;
			else enAccBin = 5;
		}
		enSpeed = e.getVelocity();
		if (enSpeed != 0.0) { enSpeedSign = Math.signum( enSpeed); }
		double MEA = Math.asin( Rules.MAX_VELOCITY / Rules.getBulletSpeed( myFirePower));

        // Check when enemy reaches the wall when circling me.
		int ewallbinbck = enWallBin = 0;
		for (int i = 0; i < GHUtils.GBINS; i++) {
			if (!GHUtils.fireField.contains( GHUtils.doProjectPos( myPos,
					 absBearing + (enDirection * (i/(double)GHUtils.GBINS) * MEA), enDistance))) {
				enWallBin = (i < GHUtils.GMIDBIN ? 1 : 2);
				break;
			}
		}
		for (int i = 0; i < GHUtils.GBINS; i++) {
			if (!GHUtils.fireField.contains( GHUtils.doProjectPos( myPos, absBearing - (enDirection * (i/(double)GHUtils.GBINS) * MEA), enDistance))) {
				ewallbinbck = (i < GHUtils.GMIDBIN ? 3 : 4);
				break;
			}
		}
		if (enWallBin == 0)
			enWallBin = ewallbinbck;
		else if ((enWallBin == 1) && (ewallbinbck == 3))
			enWallBin = 5;
						
 		// distance last 14 ticks segment
		if (enTickList.size() > 0) {
			enDL14Bin = (int)( enemyPos.distance((Point2D.Double)enTickList.get((Math.min(13, enTickList.size() - 1))).getPosition()) / 28);
			enDL14Bin = Math.min(enDL14Bin, GHUtils.GDL14SEG -1);
		}

        BotState enTick =
            new BotState( 
				enemyPos,
				Utils.normalRelativeAngle(absBearing + Math.PI), // ??!!!??
				e.getBearingRadians(),
				e.getHeadingRadians(),
				enDistance,
				Math.abs( e.getVelocity()),	// why absolute value ??!!??
				e.getEnergy(),
				enDirection,
				enAccBin,
				enVelBin,
				enWallBin,
				enDL14Bin,
				currTime);

        enTickList.add(0, enTick);
		if (enTickList.size() < 3) {
			enTickList.add(0, enTick);
			if (enTickList.size() < 3) {
			    enTickList.add(0, enTick);
			}
		}

        // if we are over the scan limit, drop the oldest data
        if (enTickList.size() > 20) {
            enTickList.remove(20);
		}
    }

    //simulatedScannedRobot: keep all relevant info this tick although there is no opponent
    public static void simulatedScannedRobot(AdvancedRobot robot) {

		currTime = robot.getTime();
		
		// information about me
		mySpeed = robot.getVelocity();
		myPos = new Point2D.Double( robot.getX(), robot.getY());

		absBearing = Utils.normalRelativeAngle(GHUtils.doGetAngle( myPos, enemyPos));
		enDistance = myPos.distance(enemyPos);
		double bearing = Utils.normalRelativeAngle(absBearing - robot.getHeadingRadians());
		if (mySpeed != 0.0) {
            myDirection = ( mySpeed * Math.sin( bearing) >= 0 ? 1 : -1);
		}
    }

    // onBulletHit: my bullet hit the opponent
	public static void onBulletHit(AdvancedRobot robot, BulletHitEvent e) {
		energyDropCorrection += Rules.getBulletDamage(e.getBullet().getPower());
		// check if enemy could have fired while killed
		if (robot.getOthers() == 0) {
			enemyAssumedFirePower = EnFireEval.checkFired( robot.getTime() - fireWindowOpen, enTickList.get(0).getEnergy());
		} else {
		    enemyAssumedFirePower = 0.0;
		}	
		bullhit++;
	}

    // onBulletMissed: my bullet missed
	public static void onBulletMissed(BulletMissedEvent e) {
		bullmis++;
    }

    // onBulletHitBullet: my bullet hit the opponents bullet
	public static void onBulletHitBullet(BulletHitBulletEvent e) {
		b_hit_b++;
    }

    // onHitByBullet: I am hit by a opponents bullet
	public static void onHitByBullet(HitByBulletEvent e) {
		energyDropCorrection += -Rules.getBulletHitBonus( e.getPower());
	}

    // onHitRobot: the tanks crashed into eachother
	public static void onHitRobot(HitRobotEvent e) {
		enemyHitMe = true;
		enemyCollision++;
    }

    // on HitWall: I hit the wall, and that should not really happen
	public static void onHitWall(HitWallEvent e) {
		wallhit++;
		double estSpeed = GHUtils.getEstNextSpeed(myTickList.get(0).getSpeed(), mySpeed);
//System.out.println(currTime+1+" Hit wall with est speed "+estSpeed);
		if (Math.abs(estSpeed) > 2.0)
			wallhitdam += Rules.getWallHitDamage( estSpeed); 
    }

//    public static void onWin(WinEvent e) {
//    }

//    public static void onDeath(DeathEvent e) {
//    }


    // reset: reset all round-specific variables
	public static void reset(AdvancedRobot r) {
		currTime = -1;
		enemyHitMe = false;
        myDirection = (Math.random() < 0.5 ? -1 : 1);
		mySpeed = 0;
        myAccBin = 0;
	    myVelBin = 0;
	    myWallBin = 0;
	    myTimeSinceVChange = 0;
		myFirePower = 0;
        enemyFirePower = 0;
        enemyAssumedFirePower = 0;
		energyDropCorrection = 0;
		
		enDirection = 1;
		enSpeed = 0;
		enSpeedSign = 1;
		enAccBin = 0;
		enVelBin = 0;
		enWallBin = 0;
		enDL14Bin = 0;
		enTimeSinceVChange = 0;

		battleRound = r.getRoundNum();
		fireWindowOpen = (long)(3.0 / r.getGunCoolingRate());
		battleSize = r.getNumRounds();

        if (myTickList == null) {
            myTickList = new ArrayList<BotState>();
            enTickList = new ArrayList<BotState>();
        } else {
            myTickList.clear();
            enTickList.clear();
        }
		GunBullets.reset();
    }

	// doCheckRadar: Let the radar produce a nice sweep
	public static void doCheckRadar( AdvancedRobot robot ) {
		// make a nice 'botwide' scanarc, should be done from 'next' positions
		double radarMove = Utils.normalRelativeAngle( getAbsBearing(0) - robot.getRadarHeadingRadians());
		radarMove += Math.atan( (Math.signum( radarMove) * 25) / getDistance(0));
		robot.setTurnRadarRightRadians( radarMove);
	}

	// doCheckEnemyFired: Check if the enemy has fired a bullet. If so, remember it
	public static double doCheckEnemyFired() {

		enemyFirePower = 0.0;
		if ((currTime >= fireWindowOpen) && (enTickList.get(0).getEnergy() != enTickList.get(1).getEnergy())) {
			if (enemyHitMe == true) {
				energyDropCorrection += 0.6;
			}
			else {
				// check if enemy could have hit the wall
				double estVelocity = enTickList.get(1).getSpeed() * 2 - enTickList.get(2).getSpeed();
				if ((enTickList.get(0).getSpeed() == 0.0) &&
					(enTickList.get(1).getSpeed() != 0.0) && ( estVelocity > 2.0)) {
					if ((enemyPos.x < 19) || (enemyPos.x > (GHUtils.battleFieldWidth - 19)) ||
					    (enemyPos.y < 19) || (enemyPos.y > (GHUtils.battleFieldHeight - 19))) {
							energyDropCorrection += Rules.getWallHitDamage( estVelocity);
					}
				}
			}
			enemyFirePower = enTickList.get(1).getEnergy() - (enTickList.get(0).getEnergy() + energyDropCorrection);
			if ((enemyFirePower < 0.09) && (enTickList.get(0).getEnergy() > 0.01)) enemyFirePower = 0.0;
			if (enemyFirePower > 3.0) enemyFirePower = 3.0;
		}
//		if (enemyFirePower != 0.0) System.out.println(currTime+" Bullet Fired !!! Energydrop: "+enemyFirePower);
		energyDropCorrection = 0.0;
		enemyHitMe = false;
		if (enemyFirePower != 0.0) {
			EnFireEval.addFired( currTime - fireWindowOpen, enemyFirePower);
			fireWindowOpen = currTime + (long)( Rules.getGunHeat( enemyFirePower) / GHUtils.gunCoolingRate);
		}
		return enemyFirePower;
	}

	// getCollisions: evaluate whether the opponent acts like a rammer
    public static int getCollisions() {
	    return ( enemyCollision);
	}

	// useShortDistance: evaluate whether to go close or not
    public static boolean useShortDistance() {
	    if (currTime < 32) return false;	// always start at long range
		boolean harmless = (EnFireEval.isPeaShooter() &&
							(myTickList.get(0).getEnergy() > 1.0) &&
							(myTickList.get(0).getEnergy()*3 > enTickList.get(0).getEnergy()));
		harmless |= EnFireEval.isRobot();
		harmless |= EnFireEval.isPacifist( currTime - fireWindowOpen);
		return harmless;
	}

	// getHitRate: return the hitrate of my gun
    public static double getHitRate() {
	    if (bullhit == 0) return 0.0;
		return ((double)bullhit / (bullhit+bullmis));
	}

	// getEnemyHitRate: return the hitrate of the enemy
    public static double getEnemyHitRate() {
	    if (enemyfired == 0) return 0.0;
		return ((double)enemyhitme / enemyfired);
	}

	// checkUseBulletShadows: return if bulletshadows should be used
    public static boolean checkUseBulletShadows() {
	    boolean shadow = true;
//		if (getHitRate() > 0.30) { shadow = false; }  // no shadows if rammer
		if (battleRound < 10) {
			if (getEnemyHitRate() < 0.11 ) { shadow = false; }  // only shadow really good guns
		} else {
			if (getEnemyHitRate() < 0.095 ) { shadow = false; }  // also shadow mediocre guns
		}
		if (battleRound < 3) { shadow = false; }  // no shadows in first 3 rounds
//		return false;
		return shadow;
	}

    // getMyWallBin: calculate wallbin only when neccesary because of slow execution
	public static int getMyWallBin() {
        double defAngle = getEneBearing(1);
        double MEA = Math.asin( Rules.MAX_VELOCITY / Rules.getBulletSpeed( enemyFirePower));
        int myOldDir = getDirection(1);
		int wbin = 0;
		for (int i = 0; i < (GHUtils.MBINS*2); i++) {
			if (!GHUtils.moveField.contains( GHUtils.doProjectPos( getEnemyPos(1), defAngle + (myOldDir * (i/(GHUtils.MBINS*2.0)) * MEA), getDistance(0)))) {
				wbin = (i < GHUtils.MBINS ? 1 : 2);
				break;
			}
		}
		if (wbin == 0) {
		// also check turning away
			for (int i = 0; i < (GHUtils.MBINS*2); i++) {
				if (!GHUtils.moveField.contains( GHUtils.doProjectPos( getEnemyPos(1), defAngle - (myOldDir * (i/(GHUtils.MBINS*2.0)) * MEA), getDistance(0)))) {
					wbin = (i < GHUtils.MBINS ? 3 : 4);
					break;
				}
			}
		}
		myWallBin = wbin;	// really necessary ?
		return wbin;
	}

//    // getMyBFTBin: calculate bullet-fly-time bin (due to distancing no real use for it)
//	public static int getMyBFTBin() {
//        double bft = getDistance(0) / Rules.getBulletSpeed(myFirePower);
////System.out.println(currTime+" BFT "+bft);
//		if (bft < 10) return 0;
//		else if (bft < 27) return 1;
//		else if (bft < 40) return 2;
//		else return 3;
//	}

	// addEnFired: keep statistics of Enemy fired and been hit
	public static void addEnFired( double bpow, boolean hit) {
		enemyfired++;
		if (hit) { enemyhitme++; }
	}

	// printStats: Print statistics on end of round
	public static void printStats()	{
		boolean lastRound = ((battleRound + 1) == battleSize);
		if (lastRound == true) {
			if (wallhitdam > 0) {
				System.out.println("Wall hits  : " + wallhit);
				System.out.println("Wallhitdam : " + wallhitdam);
			}
			System.out.println("Bullet hit bullet: "+ b_hit_b);
		}

		System.out.println("Robot collisions: " + enemyCollision );
		// Enemy hitrate
		if (enemyfired > 0) {
			System.out.println("Enemy hitrate: "+enemyhitme+"/"+enemyfired+"  " + Math.round(enemyhitme * 10000 / enemyfired) / 100.0 );
		}
		// My gunstats
		if (bullmis + bullhit > 0) {
//			if (scanmis > numberRound)
//				System.out.println("Lock lost  :" + (scanmis - battleRound));
			System.out.print("BulletStats: " + bullhit);
			System.out.print("/" + (bullhit+bullmis));
			System.out.println("   [" + ((float)bullhit*100)/(float)(bullhit + bullmis) + "%]");
		}
	}

    public static Point2D.Double getMyPos()    { return myPos; }
    public static Point2D.Double getEnemyPos() { return enemyPos; }
    public static Point2D.Double getMyNextPos()      { return myNextPos; }
    public static Point2D.Double getEnemyNextPos()   { return enemyNextPos; }
    public static Point2D.Double getMyPos( int t)    { return myTickList.get(t).getPosition(); }
    public static Point2D.Double getEnemyPos( int t) { return enTickList.get(t).getPosition(); }
    public static double getMySpeed()          { return mySpeed; }
    public static double getAbsBearing( int t) { return myTickList.get(t).getAbsBearing(); }
    public static double getHeading( int t)    { return myTickList.get(t).getHeading(); }
    public static double getDistance( int t)   { return myTickList.get(t).getDistance(); }
    public static double getDistance()         { return enDistance; }
    public static int getDirection( int t)     { return myTickList.get(t).getDirection(); }
    public static int getMyAccBin( int t)  { return myTickList.get(t).getAccBin(); }
    public static int getMyVelBin( int t)  { return myTickList.get(t).getVelBin(); }
    public static int getMyWallBin( int t) { return myTickList.get(t).getWallBin(); }
    public static int getMyDL14Bin( int t) { return myTickList.get(t).getDL14Bin(); }
	public static double getMyFirePower()  { return myFirePower; }
	public static void setMyFirePower( double fp) { myFirePower = fp; }

	public static double getEnSpeed( int t)    { return enTickList.get(t).getSpeed(); }
	public static double getEnSpeed()          { return enSpeed; }
	public static double getEnSpeedSign()      { return enSpeedSign; }
    public static double getEneBearing( int t) { return enTickList.get(t).getAbsBearing(); }
    public static double getEneBearing()       { return absBearing + Math.PI; }
    public static double getEnHeading( int t)  { return enTickList.get(t).getHeading(); }
    public static double getEnEnergy( int t)   { return enTickList.get(t).getEnergy(); }
    public static double getAssFirePower()     { return enemyAssumedFirePower; }
	public static int getEnDirection( int t)   { return enTickList.get(t).getDirection(); }
    public static int getEnAccBin()      { return enAccBin; }
    public static int getEnVelBin()      { return enVelBin; }
    public static int getEnWallBin()     { return enWallBin; }
    public static int getEnDL14Bin()     { return enDL14Bin; }
	
	public static boolean isSittingDuck()	{ return sittingDuck; }

}
