/*
 Evolved in generation 10
 Average fitness: 2289.264262069051
 Single fitness values:
 1. 662.7311009586789
 2. 1825.325105440936
 3. 4379.736579807538
 */
package jgap;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

public class JGAP12584
    extends AdvancedRobot {
  static double lastEnemyHeading;
  static double radarturn = 1;
  static int i2 = 0;
  static double x = 2.0;
  static double y = 1.0;
  static double z = 3.0;
  static double enemyX = 0;
  static double enemyY = 0;
  static double distance = -1.0;
  static double[] memory = new double[50];
  static Point2D robotLocation = new Point2D.Double();
  static Point2D enemyLocation = new Point2D.Double();
  static final double BATTLE_FIELD_WIDTH = 800;
  static final double BATTLE_FIELD_HEIGHT = 600;
  static final double WALL_MARGIN = 18;
  void toLocation(double angle, double length, Point2D sourceLocation,
                  Point2D targetLocation) {
    targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
                               sourceLocation.getY() + Math.cos(angle) * length);
  }

  double normalize(double angle) {
    return angle - 2 * Math.PI * Math.floor( (angle + Math.PI) / (2 * Math.PI));
  }

  static double absoluteBearing(Point2D source, Point2D target) {
    return Math.atan2(target.getX() - source.getX(),
                      target.getY() - source.getY());
  }

  public void run() {
    setColors(Color.red, Color.blue, Color.green);
    setAdjustRadarForGunTurn(true);
    // Initialization stuff
    do {
      turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    while (true);
  }

  public void onScannedRobot(ScannedRobotEvent e) {
    x = getHeading() + e.getBearing();
    y = getRadarTurnRemaining();
    distance = e.getDistance();
    robotLocation.setLocation(getX(), getY());
    Rectangle2D fieldRectangle = new Rectangle2D.Double(WALL_MARGIN,
        WALL_MARGIN, BATTLE_FIELD_WIDTH - WALL_MARGIN * 2,
        BATTLE_FIELD_HEIGHT - WALL_MARGIN * 2);
    double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
    toLocation(enemyAbsoluteBearing, distance, robotLocation, enemyLocation);
    enemyX = enemyLocation.getX();
    enemyY = enemyLocation.getY();
    {
      setAhead( ( -180.0d));
      setAhead(1000 / Math.sin(e.getEnergy() / 2));
      setFire(getHeading());
      {
        {
          setAhead( (int) getTime());
          setTurnRight(getGunTurnRemaining());
          setBack( (59.02530288696289d));
        }

        setFireBullet( ( -90));
      }

    }

  }

  public void onHitByBullet(HitByBulletEvent e) {
    e.getPower();
    {
      setBack(getY());
      setFireBullet(Math.sqrt(Math.abs( (55.90187072753906d))));
    }

  }

  public void onHitWall(HitWallEvent e) {
    {
      if ( ( (getHeading() + ( -46.200965881347656d)) > (130.46640014648438d))) {
        setAhead(getHeading());
        setTurnRight( ( (130.46640014648438d) * getHeading()));
      }
      {
        setTurnLeft( (130.46640014648438d));
        setTurnRight( (130.46640014648438d));
      }
      if ( ( ( -45) == (6.743239402770996d))) {
        setTurnRadarLeft( (130.46640014648438d));
      }
      else {
        setTurnLeft( ( -45));
      }
      setTurnRight(getHeading());
    }

  }

  public void onHitRobot(HitRobotEvent e) {
    setTurnGunLeft(getGunTurnRemaining());
  }

}
