package dsekercioglu.mega.wfMove;

import dsekercioglu.mega.wfMove.move.DecayingKNNView;
import dsekercioglu.mega.wfMove.move.EnsembleView;
import dsekercioglu.mega.wfMove.move.View;
import dsekercioglu.mega.wfMove.move.KNNView;
import dsekercioglu.mega.wfMove.move.RangeView;
import dsekercioglu.mega.wfMove.move.formulas.Formula1K;
import dsekercioglu.mega.wfMove.move.formulas.FormulaNormal;
import dsekercioglu.mega.wfMove.move.formulas.FormulaFlattener;
import dsekercioglu.mega.wfMove.move.formulas.FormulaRecent;
import dsekercioglu.mega.wfMove.move.formulas.FormulaSimple;
import dsekercioglu.mega.wfMove.move.formulas.FormulaSimple2;
import dsekercioglu.mega.wfMove.precise.WallSmoothingMEACalculator;
import dsekercioglu.mega.wfMove.move.thresholds.DecreasingThreshold;
import dsekercioglu.mega.wfMove.move.thresholds.NoThreshold;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import static robocode.util.Utils.normalRelativeAngle;

public class Lightning {

    AdvancedRobot a;

    public final int BINS = 151;
    public final int WALL_STICK = 120;
    public final double WALL_MARGIN = 18;
    public final int PREFERRED_DISTANCE = 450;
    public final double AGGRESSION = 0.002;
    public final double MAX_CENTER_DISTANCE = 18 * Math.sqrt(2);
    public final double TO_DEGREES = 180 / Math.PI;

    public double SIMPLE_BAND_WIDTH = 4;
    public double BAND_WIDTH = 4;
    public double L_FLATTENER_BAND_WIDTH = 4;
    public double FLATTENER_BAND_WIDTH = 4;

    public final double SECOND_WAVE_DANGER = 0.2;

    public final double SIMPLE_LEARNER_WEIGHT = 1;
    public final double LEARNER_WEIGHT = 1;
    public final double FLATTENER_WEIGHT = 1;

    public final double HIT_RATE_DECAY = 0.0;

    public final ArrayList<View> PREDICTORS = new ArrayList<>();
    public final ArrayList<Double> WEIGHTS = new ArrayList<>();
    public final ArrayList<Double> BAND_WIDTHS = new ArrayList<>();

    ArrayList<Wave> waves = new ArrayList<>();
    ArrayList<ShadowBullet> bullets = new ArrayList();
    ArrayList<BattleInfo> battleInfo = new ArrayList<>();
    BattleInfo currentBattleInfo = new BattleInfo();
    BotInfo botInfo;

    WaveSurfing waveSurfing = new WaveSurfing();

//    public double enemyFireTime = 0.0001;
//    public double enemyHitTime = 0;
    public final int SIMPLE_DIVISOR = 1;
    public final int SIMPLE_K = 100;

    public final int NORMAL_DIVISOR = 1;
    public final int NORMAL_K = 50;

    public final int F_DIVISOR = 1;
    public final int F_K = 20;

    public Lightning(AdvancedRobot a) {
        this.a = a;
        botInfo = new BotInfo(a);

        EnsembleView antiSimple = new EnsembleView(BINS,
                new KNNView(BINS, new FormulaSimple(), SIMPLE_K, SIMPLE_DIVISOR, new NoThreshold(), true, false),
                new KNNView(BINS, new FormulaSimple2(), SIMPLE_K, SIMPLE_DIVISOR, new NoThreshold(), true, false));
        PREDICTORS.add(antiSimple);
        BAND_WIDTHS.add(SIMPLE_BAND_WIDTH);
        WEIGHTS.add(0.01);
////
        EnsembleView learner = new EnsembleView(BINS,
                new KNNView(BINS, new FormulaNormal(), NORMAL_K, NORMAL_DIVISOR, new DecreasingThreshold(0.03, 0.03, 0.03), true, false));
        PREDICTORS.add(learner);
        BAND_WIDTHS.add(BAND_WIDTH);
        WEIGHTS.add(1D);

        EnsembleView oneK = new EnsembleView(BINS,
                new KNNView(BINS, new Formula1K(), 1, 1, new DecreasingThreshold(0.08, 0.08, 0.04), true, false),
                new KNNView(BINS, new FormulaNormal(), 1, 1, new DecreasingThreshold(0.08, 0.08, 0.04), true, false),
                new KNNView(BINS, new FormulaFlattener(), 1, 1, new DecreasingThreshold(0.08, 0.08, 0.04), true, false));
        PREDICTORS.add(oneK);
        BAND_WIDTHS.add(BAND_WIDTH);
        WEIGHTS.add(1D);

        EnsembleView flattener = new EnsembleView(BINS,
                new DecayingKNNView(BINS, new FormulaFlattener(), F_K, F_DIVISOR, new DecreasingThreshold(0.09, 0.09, 0), true, true, 1, 0),
                new DecayingKNNView(BINS, new FormulaRecent(), F_K, F_DIVISOR, new DecreasingThreshold(0.09, 0.09, 0), true, true, 1, 0)
        );
        PREDICTORS.add(flattener);
        BAND_WIDTHS.add(FLATTENER_BAND_WIDTH);
        WEIGHTS.add(1.5D);

//        EnsembleView tickFlattener = new EnsembleView(BINS,
//                new KNNView(BINS, new FormulaFlattener(), F_K, F_DIVISOR, new DecreasingThreshold(0.1, 0.1, 0), true, true));
//        PREDICTORS.add(flattener);
//        BAND_WIDTHS.add(FLATTENER_BAND_WIDTH);
//        WEIGHTS.add(1.0);

        /*
                //Main Predictor
        PREDICTORS.add(new CustomProfile(BINS, new NormalFormula(), 60, 5, 0, 0, true, false));
        WEIGHTS.add(1.0);

        //Anti Simple Predictor
        PREDICTORS.add(new CustomProfile(BINS, new SimpleFormula(), 60, 5, 0, 0, true, false));
        WEIGHTS.add(0.5);
 
        //Light Flattener
        PREDICTORS.add(new CustomProfile(BINS, new SimpleFormula(), 20, 10, 1.2, 1, false, true));
        WEIGHTS.add(0.5);

        //Normal Flattener
        PREDICTORS.add(new CustomProfile(BINS, new FlattenerFormula(), 20, 10, 1.5, 1.2, false, true));
        WEIGHTS.add(1.5);
         */
    }

    public void run() {
        currentBattleInfo.run();
        botInfo.run();
        battleInfo = new ArrayList<>();
        waves = new ArrayList<>();
        bullets = new ArrayList<>();
    }

    public Point2D.Double getNextPosition() {
        return waveSurfing.nextPosition == null ? currentBattleInfo.location : waveSurfing.nextPosition;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        currentBattleInfo.onScannedRobot(e);
        botInfo.onScannedRobot(e);
        updateWaves();
        double firePower = currentBattleInfo.enemyFired();
        if (firePower != -1) {
            BattleInfo infoWhenFired = (BattleInfo) battleInfo.get(battleInfo.size() - 1);
            int lateralDir = infoWhenFired.lateralDirection;
            infoWhenFired.firePower = firePower;
            Wave w = new Wave(firePower, infoWhenFired.enemyLocation, infoWhenFired.location, lateralDir, (int) (a.getTime() - 2));
            setWave(infoWhenFired, w);
            waves.add(w);
        }
        if (this.botInfo.botFired()) {
            this.bullets.add(new ShadowBullet(this.botInfo.getFireLocation(), this.botInfo.getGunHeading(), 20.0D - 3.0D * this.botInfo.getFirePower()));
        }
        waveSurfing.surf();
        try {
            battleInfo.add((BattleInfo) currentBattleInfo.clone());
        } catch (CloneNotSupportedException ex) {
            Logger.getLogger(Lightning.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (waves.isEmpty()) {
            System.out.println("No active wave");
        } else {
            bulletDetected(e.getBullet());
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (waves.isEmpty()) {
            System.out.println("No active wave");
        } else {
            bulletDetected(e.getHitBullet());
            removeShadows(e.getBullet());
        }
    }

    public void removeShadows(Bullet botBullet) {
        for (int i = 0; i < bullets.size(); i++) {
            ShadowBullet sb = bullets.get(i);
            if (Math.abs(normalRelativeAngle(sb.absBearing - botBullet.getHeadingRadians())) < 0.003 && sb.location.distance(new Point2D.Double(botBullet.getX(), botBullet.getY())) < sb.speed + 1) {
                bullets.remove(sb);
                break;
            }
        }
    }

    public void updateWaves() {
        for (int i = 0; i < this.bullets.size(); i++) {
            ShadowBullet b = (ShadowBullet) this.bullets.get(i);
            boolean remove = b.update();
            if (remove) {
                this.bullets.remove(i);
                i--;
            }
        }
        for (int i = 0; i < waves.size(); i++) {
            Wave w = waves.get(i);
            boolean hit = w.update(currentBattleInfo.location);
            for (int j = 0; j < this.bullets.size(); j++) {
                ShadowBullet b = bullets.get(j);
                w.addShadow(b.location, b.speed, b.absBearing);
            }
            if (hit && !w.visitedBot) {
                w.visitedBot = true;
                int hitBin = w.getBin(currentBattleInfo.location);
                for (int p = 0; p < PREDICTORS.size(); p++) {
                    PREDICTORS.get(p).wavePassed(w.data, hitBin, false);
                }
            }
            if (w.remove(currentBattleInfo.location)) {
                currentBattleInfo.onWavePassed(w);
                waves.remove(i);
                i--;
            }
        }
    }

    public void bulletDetected(Bullet b) {
        Point2D.Double bulletLoc = new Point2D.Double(b.getX(), b.getY());
        int waveIndex = -1;
        for (int i = 0; i < waves.size(); i++) {
            Wave w = waves.get(i);
            double bulletDistance = bulletLoc.distance(w.fireLocation);
            double interceptTime = w.fireTime + bulletDistance / w.waveVelocity;
            if (Math.abs(interceptTime - a.getTime()) < 3
                    && Math.abs(b.getVelocity() - w.waveVelocity) < 0.2) {
                waveIndex = i;
            }
        }
        if (waveIndex < 0) {
            System.out.println("Bullet didn't match with a wave");
        } else {
            Wave matchedWave = waves.get(waveIndex);
            currentBattleInfo.onHitByBullet(matchedWave);
            int bin = matchedWave.getBin(bulletLoc);
            for (int i = 0; i < PREDICTORS.size(); i++) {
                PREDICTORS.get(i).wavePassed(matchedWave.data, bin, true);
            }
            currentBattleInfo.onWavePassed(matchedWave);
            waves.remove(waveIndex);
        }
    }

    public void setWave(BattleInfo dataWhenFired, Wave wave) {
        try {
            wave.setData(dataWhenFired);
        } catch (CloneNotSupportedException ex) {
            Logger.getLogger(Lightning.class.getName()).log(Level.SEVERE, null, ex);
        }
        double[] sumBins = new double[BINS];
        for (int i = 0; i < PREDICTORS.size(); i++) {
            double[] currentBins = PREDICTORS.get(i).predict(dataWhenFired, currentBattleInfo.weightedHitRate / currentBattleInfo.weightedFireRate);
            double importance = WEIGHTS.get(i);
            double[] smoothedBins = MoveUtils.smooth(currentBins, BAND_WIDTHS.get(i));
            for (int j = 0; j < sumBins.length; j++) {
                sumBins[j] += smoothedBins[j] * importance;
            }
        }
        //sumBins = MoveUtils.smooth(sumBins, BAND_WIDTH);
        wave.setBins(MoveUtils.probabilizeBinValues(sumBins));
    }

    public class BattleInfo implements Cloneable {

        public Point2D.Double location = new Point2D.Double();
        public Point2D.Double enemyLocation = new Point2D.Double();

        public double battleFieldWidth;
        public double battleFieldHeight;

        public double velocity;
        public double heading;
        public double bearing;
        public double absBearing;
        public double distance;

        public double relativeAngle;
        public double relativeHeading;

        public double lateralVelocity;
        public double advancingVelocity;
        public double lateralAcceleration;
        public int lateralDirection = 1;

        private ArrayList<Double> lateralVelocityList = new ArrayList<>();

        public int timeSinceDeceleration;
        public int timeSinceDirectionChange;

        public double enemyEnergy = 100;
        public double oldEnemyEnergy = 100;
        public double deltaEnergy = 0;

        public double weightedHitRate = 0;
        public double weightedFireRate = 0;

        public final Rectangle2D.Double battleField = new Rectangle2D.Double();

        public int enemyFired = 0;
        public int enemyHit = 0;

        /**
         * This variable is created 2 ticks after the turn
         */
        public double firePower = 0;

        public void run() {
            timeSinceDeceleration = 0;
            lateralVelocityList = new ArrayList<>();
            battleFieldWidth = a.getBattleFieldWidth();
            battleFieldHeight = a.getBattleFieldHeight();
            battleField.width = battleFieldWidth;
            battleField.height = battleFieldHeight;
        }

        public void onScannedRobot(ScannedRobotEvent e) {
            timeSinceDeceleration++;
            timeSinceDirectionChange++;

            location.setLocation(a.getX(), a.getY());
            velocity = a.getVelocity();
            heading = a.getHeadingRadians();
            bearing = e.getBearingRadians();
            absBearing = heading + bearing;
            distance = e.getDistance();

            enemyEnergy = e.getEnergy();
            deltaEnergy = oldEnemyEnergy - enemyEnergy;
            enemyLocation = MoveUtils.project(location, absBearing, distance);
            relativeAngle = bearing;
            double newLateralVelocity = velocity * Math.sin(relativeAngle);
            lateralAcceleration = Math.abs(newLateralVelocity) - Math.abs(lateralVelocity);
            if (lateralAcceleration < 0) {
                timeSinceDeceleration = 0;
            }
            if (Math.signum(newLateralVelocity) - Math.signum(lateralVelocity) > 0.01) {
                timeSinceDirectionChange = 0;
            }
            lateralVelocity = newLateralVelocity;
            lateralDirection = lateralVelocity == 0 ? lateralDirection : (lateralVelocity > 0 ? 1 : -1);
            advancingVelocity = velocity * -Math.cos(relativeAngle);
            relativeHeading = Math.abs(Utils.normalRelativeAngle(heading - absBearing + Math.PI + (velocity > 0 ? 0 : Math.PI)));
            lateralVelocityList.add(lateralVelocity);

            oldEnemyEnergy = enemyEnergy;
        }

        public void onHitByBullet(Wave w) {
            double botWidth = 2 * Math.atan(25 / (w.distanceTraveled - 18));
            double hitChance = botWidth / w.maxEscapeAngle;
            if (w.distanceTraveled > 200) {
                weightedHitRate += 1 / hitChance;
            }
            //oldEnemyEnergy -= Rules.getBulletDamage(w.waveDamage);
            enemyHit++;
        }

        public void onWavePassed(Wave w) {
            double botWidth = 2 * Math.atan(25 / (w.distanceTraveled - 18));
            double hitChance = botWidth / w.maxEscapeAngle;
            weightedFireRate += 1 / hitChance;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public double getMEA(int direction) {
            double turnPerTick = 8 / distance;
            double maxIteration = Math.PI * 2 / turnPerTick;
            double angle = heading + bearing + Math.PI;
            double mea = 0;
            Point2D.Double predictedPosition = MoveUtils.project(enemyLocation, angle, distance);
            int iteration = 0;
            while (MoveUtils.distanceToWall(predictedPosition.x,
                    predictedPosition.y,
                    battleFieldWidth,
                    battleFieldHeight) >= 18) {
                angle += turnPerTick * lateralDirection * direction;
                mea += turnPerTick;
                predictedPosition = MoveUtils.project(enemyLocation, angle, distance);
                if ((++iteration) > maxIteration) {
                    break;
                }
            }
            return mea;
        }

        public double getLateralDistanceLastX(int x) {
            int startIndex = Math.max(lateralVelocityList.size() - x, 0);
            double lateralDistance = 0;
            for (int i = startIndex; i < lateralVelocityList.size(); i++) {
                lateralDistance += lateralVelocityList.get(i);
            }
            return Math.abs(lateralDistance) / x;
        }

        public double enemyFired() {
            boolean fired = (deltaEnergy > 0.099 && deltaEnergy < 3.001);
            if (fired) {
                enemyFired++;
                return deltaEnergy;
            }
            return -1;
        }

        public double bulletFloatTime() {
            double firePower = enemyFired();
            if (firePower != -1) {
                double bulletVelocity = 20 - 3 * firePower;
                double relativeBulletVelocity = bulletVelocity - advancingVelocity;
                return Math.min(91, distance / relativeBulletVelocity);
            }
            return 0;
        }
    }

    public class BotInfo {

        double energy;
        double oldEnergy;
        double deltaEnergy;
        ArrayList<Double> gunBearings = new ArrayList<>();
        ArrayList<Point2D.Double> locations = new ArrayList<>();

        AdvancedRobot a;

        public BotInfo(AdvancedRobot a) {
            this.a = a;
        }

        public void run() {
            energy = 100;
            oldEnergy = 100;
        }

        public void onScannedRobot(ScannedRobotEvent e) {
            gunBearings.add(a.getGunHeadingRadians());
            locations.add(new Point2D.Double(a.getX(), a.getY()));
            energy = a.getEnergy();
            deltaEnergy = oldEnergy - energy;
            oldEnergy = energy;
        }

        public boolean botFired() {
            return deltaEnergy > 0.099 && deltaEnergy < 3.001;
        }

        public double getGunHeading() {
            return gunBearings.get(gunBearings.size() - 2);
        }

        public double getFirePower() {
            return deltaEnergy;
        }

        public Point2D.Double getFireLocation() {
            return locations.get(locations.size() - 2);
        }
    }

    public class WaveSurfing {

        int lastPredictionTime = 0;

        Point2D.Double nextPosition;

        Point2D.Double[] possibleFuturePositions = new Point2D.Double[3];

        ArrayList<Point2D.Double> intersections = new ArrayList<>();

        public void surf() {
            Wave surfWave = getClosestSurfableWave();
            if (surfWave == null) {
                surfWave = new Wave(0.1, currentBattleInfo.enemyLocation, currentBattleInfo.location, 1, 0);
                surfWave.setBins(new double[]{1});
            }
            Point2D.Double forward = predictPosition(currentBattleInfo.location, surfWave, 1, true);
            int timeForward = lastPredictionTime;
            Point2D.Double reverse = predictPosition(currentBattleInfo.location, surfWave, -1, true);
            int timeBack = lastPredictionTime;
            Point2D.Double stop = predictPosition(currentBattleInfo.location, surfWave, 0, true);
            int timeStop = lastPredictionTime;
            Wave secondWave = getSecondWave();
            double dangerRight;
            double dangerLeft;
            double dangerStop;
            if (secondWave == null) {
                double distanceTraveled = surfWave.distanceTraveled;
                surfWave.distanceTraveled += timeForward * surfWave.waveVelocity;
                dangerRight = getDanger(forward);
                surfWave.distanceTraveled = distanceTraveled + timeBack * surfWave.waveVelocity;
                dangerLeft = getDanger(reverse);
                surfWave.distanceTraveled = distanceTraveled + timeStop * surfWave.waveVelocity;
                dangerStop = getDanger(stop);
                surfWave.distanceTraveled = distanceTraveled;
            } else {
                double firstDistanceTraveled = secondWave.distanceTraveled;
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeForward;
                dangerRight = getDangerMultiWave(forward,
                        predictPosition(forward, secondWave, 1, false),
                        predictPosition(forward, secondWave, 0, false),
                        predictPosition(forward, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeStop;
                dangerStop = getDangerMultiWave(stop,
                        predictPosition(stop, secondWave, 1, false),
                        predictPosition(stop, secondWave, 0, false),
                        predictPosition(stop, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeBack;
                dangerLeft = getDangerMultiWave(reverse,
                        predictPosition(reverse, secondWave, 1, false),
                        predictPosition(reverse, secondWave, 0, false),
                        predictPosition(reverse, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled;
            }
            dangerRight /= getMaxToCurrentMEA(forward, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            dangerStop /= getMaxToCurrentMEA(stop, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            dangerLeft /= getMaxToCurrentMEA(reverse, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            double moveAngle = 0;
            int moveDir = 0;
            if (dangerRight <= dangerLeft && dangerRight <= dangerStop) {
                moveDir = 1;
            } else if (dangerRight > dangerLeft && dangerLeft <= dangerStop) {
                moveDir = -1;
            }
            nextPosition = (Point2D.Double) possibleFuturePositions[moveDir + 1];
            moveAngle = getWallSmoothingAngle(surfWave, currentBattleInfo.location, moveDir);
            setBackAsFront(moveAngle, Math.abs(moveDir) * 8);
        }

        public double getDanger(Point2D.Double position) {
            double waveDanger = 0;
            if (MoveUtils.distanceToWall(position.x,
                    position.y,
                    currentBattleInfo.battleFieldWidth,
                    currentBattleInfo.battleFieldHeight) <= 18) {
                return Double.POSITIVE_INFINITY;
            }
            if (waves.isEmpty()) {
                return 1 / position.distance(currentBattleInfo.enemyLocation);
            }
            Wave surfWave = getClosestSurfableWave();
            waveDanger += getBotWidthDanger(position, surfWave) * surfWave.waveDamage / position.distance(currentBattleInfo.enemyLocation)/* * getMaxToCurrentMEA(position, currentBattleInfo.enemyLocation, surfWave.waveVelocity)*/;
            return waveDanger;
        }

        public double getMaxToCurrentMEA(Point2D.Double position, Point2D.Double enemyPosition, double bulletSpeed) {
            WallSmoothingMEACalculator wsmc = new WallSmoothingMEACalculator(currentBattleInfo.battleFieldWidth, currentBattleInfo.battleFieldHeight, 0.01);
            wsmc.calculateEscapeAngle(position, enemyPosition, bulletSpeed);
            double escapeAngleWithoutWalls = Math.asin(8 / bulletSpeed);
            double escapeAngle = Math.abs(normalRelativeAngle(wsmc.getEscapeAngle(1) - wsmc.getEscapeAngle(-1)));
            return (escapeAngle / escapeAngleWithoutWalls) * 0.5;
        }

        public double getDangerMultiWave(Point2D.Double position, Point2D.Double positionAhead, Point2D.Double positionStop, Point2D.Double positionBack) {
            //Wave firstWave = getClosestSurfableWave();
            Wave secondWave = getSecondWave();
            return (getDanger(position)
                    + Math.min(Math.min(getBotWidthDanger(positionAhead, secondWave)
                            / positionAhead.distance(currentBattleInfo.enemyLocation),
                            getBotWidthDanger(positionStop, secondWave)
                            / positionStop.distance(currentBattleInfo.enemyLocation)),
                            getBotWidthDanger(positionBack, secondWave)
                            / positionBack.distance(currentBattleInfo.enemyLocation))
                    * SECOND_WAVE_DANGER
                    * secondWave.waveDamage)/* / getMaxToCurrentMEA(position, currentBattleInfo.enemyLocation, firstWave.waveVelocity)*/;
        }

        public double getBotWidthDanger(Point2D.Double position, Wave surfWave) {
            Point2D.Double[] points = new Point2D.Double[4];
            int index = 0;
            for (int x = -18; x <= 18; x += 36) {
                for (int y = -18; y <= 18; y += 36) {
                    points[index] = new Point2D.Double(position.x + x, position.y + y);
                    index++;
                }
            }
            int startBin = BINS - 1;
            int finishBin = 0;
            double startBO = Double.POSITIVE_INFINITY;
            double finishBO = Double.NEGATIVE_INFINITY;
            for (Point2D.Double point : points) {
                int bin = surfWave.getBin(point);
                startBin = Math.min(startBin, bin);
                finishBin = Math.max(finishBin, bin);
                double bearingOffset = normalRelativeAngle(MoveUtils.absoluteBearing(surfWave.fireLocation, point) - MoveUtils.absoluteBearing(surfWave.fireLocation, position));
                startBO = Math.min(startBO, bearingOffset);
                finishBO = Math.max(finishBO, bearingOffset);

            }
            double danger = 0;
            for (int i = (int) Math.ceil(startBin); i <= (int) Math.floor(finishBin); i++) {
                danger += surfWave.bins[i] * (1 - surfWave.shadows[i]);
            }
            danger /= finishBin - startBin + 1;
            return danger * Math.abs(normalRelativeAngle(finishBO - startBO));
        }

//        public double getMEADanger(Point2D.Double position, Wave w) {
//            WSMEAC.calculateEscapeAngle(position, w.fireLocation, 0, w.waveVelocity);
//            double escapeAngle = Math.abs(normalRelativeAngle(WSMEAC.getEscapeAngle(1) - WSMEAC.getEscapeAngle(-1)));
//            return 1 / (escapeAngle + 1);
//        }
        public Wave getClosestSurfableWave() {
            if (waves.isEmpty()) {
                return null;
            }
            int surfWaveIndex = 0;
            double lowestTimeLeft = Double.POSITIVE_INFINITY;
            for (int i = 0; i < waves.size(); i++) {
                Wave w = waves.get(i);
                double timeLeft = (w.fireLocation.distance(currentBattleInfo.location) - w.distanceTraveled) / w.waveVelocity;
                if (timeLeft < lowestTimeLeft && timeLeft >= 0) {
                    surfWaveIndex = i;
                    lowestTimeLeft = timeLeft;
                }
            }
            return waves.get(surfWaveIndex);
        }

        public Wave getSecondWave() {
            Wave surfWave = getClosestSurfableWave();
            int secondWaveIndex = -1;
            double lowestTimeLeft = Double.POSITIVE_INFINITY;
            for (int i = 0; i < waves.size(); i++) {
                if (waves.get(i) != surfWave) {
                    Wave w = waves.get(i);
                    double timeLeft = (w.fireLocation.distance(currentBattleInfo.location)
                            - w.distanceTraveled) / w.waveVelocity;
                    if (timeLeft < lowestTimeLeft) {
                        lowestTimeLeft = timeLeft;
                        secondWaveIndex = i;
                    }
                }
            }
            return secondWaveIndex == -1 ? null : waves.get(secondWaveIndex);
        }

        public Point2D.Double predictPosition(Point2D.Double startPos, Wave surfWave, int direction, boolean firstWave) {
            intersections.clear();
            Point2D.Double enemyLocation = (Point2D.Double) currentBattleInfo.enemyLocation.clone();
            Point2D.Double predictedPosition = (Point2D.Double) startPos.clone();
            double predictedVelocity = currentBattleInfo.velocity;
            double predictedHeading = currentBattleInfo.heading;
            double maxTurning;
            double moveAngle;
            double moveDirection;
            int counter = 0;
            boolean intercepted = false;

            do {
                moveAngle
                        = getWallSmoothingAngle(surfWave, predictedPosition, direction)
                        - predictedHeading;
                moveDirection = 1;
                if (Math.cos(moveAngle) < 0) {
                    moveAngle += Math.PI;
                    moveDirection = -1;
                }
                moveAngle = Utils.normalRelativeAngle(moveAngle);
                maxTurning = Math.toRadians(10 - 0.75 * Math.abs(predictedVelocity));
                predictedHeading = Utils.normalRelativeAngle(predictedHeading
                        + MoveUtils.limit(-maxTurning, moveAngle, maxTurning));
                if (direction == 0) {
                    if (Math.abs(predictedVelocity) <= 2.0D) {
                        predictedVelocity = 0.0D;
                        intercepted = true;
                    } else {
                        predictedVelocity += (predictedVelocity < 0.0D ? 2 : -2);
                    }
                } else {
                    predictedVelocity += (predictedVelocity * moveDirection < 0 ? 2 * moveDirection : moveDirection);
                }
                predictedVelocity = MoveUtils.limit(-8, predictedVelocity, 8);

                predictedPosition = MoveUtils.project(predictedPosition, predictedHeading, predictedVelocity);
                counter++;
                if (counter == 1 && firstWave) {
                    possibleFuturePositions[direction + 1] = (Point2D.Double) predictedPosition.clone();
                }

                if (predictedPosition.distance(surfWave.fireLocation)
                        < surfWave.distanceTraveled + (counter * surfWave.waveVelocity) + 18
                        || (enemyLocation.distance(predictedPosition) < 36 + 8 * Math.min(counter, 20))
                        || (MoveUtils.distanceToWall(predictedPosition.x,
                                predictedPosition.y,
                                currentBattleInfo.battleFieldWidth,
                                currentBattleInfo.battleFieldHeight) <= 18)) {
                    intercepted = true;
                    if (Math.abs(predictedPosition.distance(surfWave.fireLocation) - surfWave.distanceTraveled) <= 21) {
                        intersections.add((Point2D.Double) predictedPosition.clone());
                    }
                }
            } while (!intercepted && counter <= 91);
            lastPredictionTime = counter;
            return predictedPosition;
        }

        public double backAsFrontTurn(double newHeading, double oldHeading) {
            return Math.tan(newHeading - oldHeading);
        }

        public double backAsFrontDirection(double newHeading, double oldHeading) {
            return sign(Math.cos(newHeading - oldHeading));
        }

        //CREDIT:Cb
        public double getWallSmoothingAngle(Wave surfWave, Point2D.Double currentLocation, double dir) {
            double battleFieldWidth = currentBattleInfo.battleFieldWidth;
            double battleFieldHeight = currentBattleInfo.battleFieldHeight;
            Rectangle2D.Double battleField = new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN, battleFieldWidth - WALL_MARGIN * 2, battleFieldHeight - WALL_MARGIN * 2);
            double currentAngle = MoveUtils.absoluteBearing(surfWave.fireLocation, currentLocation) + Math.PI / 2;
            if (dir != 0) {
                double extraAngle = (currentLocation.distance(currentBattleInfo.enemyLocation) - PREFERRED_DISTANCE) * AGGRESSION;
                //double wallStick = WALL_STICK + (1000 - currentLocation.distance(currentBattleInfo.enemyLocation)) / 25;//Some great potential in this
                double wallStick = WALL_STICK;
                currentAngle += (dir - 1) * Math.PI / 2 + dir * extraAngle;
                Point2D.Double p = MoveUtils.project(currentLocation, currentAngle, wallStick);
                for (int i = 0; !battleField.contains(p) && i < 4; i++) {
                    if (p.x < WALL_MARGIN) {
                        p.x = WALL_MARGIN;
                        double a = currentLocation.x - WALL_MARGIN;
                        p.y = currentLocation.y + dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.y > battleFieldHeight - WALL_MARGIN) {
                        p.y = battleFieldHeight - WALL_MARGIN;
                        double a = battleFieldHeight - WALL_MARGIN - currentLocation.y;
                        p.x = currentLocation.x + dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.x > battleFieldWidth - WALL_MARGIN) {
                        p.x = battleFieldWidth - WALL_MARGIN;
                        double a = battleFieldWidth - WALL_MARGIN - currentLocation.x;
                        p.y = currentLocation.y - dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.y < WALL_MARGIN) {
                        p.y = WALL_MARGIN;
                        double a = currentLocation.y - WALL_MARGIN;
                        p.x = currentLocation.x - dir * Math.sqrt(wallStick * wallStick - a * a);
                    }
                }
                return MoveUtils.absoluteBearing(currentLocation, p);
            }
            return currentAngle;
        }

        public double sign(double x) {
            return x >= 0 ? 1 : -1;
        }

        public void setBackAsFront(double moveAngle, double maxVel) {
            a.setMaxVelocity(maxVel);
            double moveAmount = 36;
            double turnAngle = moveAngle - currentBattleInfo.heading;
            if (Math.cos(turnAngle) < 0) {
                turnAngle += Math.PI;
                moveAmount *= -1;
            }
            a.setTurnRightRadians(normalRelativeAngle(turnAngle));
            a.setAhead(moveAmount);
        }
    }

    public class LightningRunner {

        int lastPredictionTime = 0;

        Point2D.Double nextPosition;

        Point2D.Double[] possibleFuturePositions = new Point2D.Double[3];

        public void surf() {
            Wave surfWave = getClosestSurfableWave();
            if (surfWave == null) {
                surfWave = new Wave(0.1, currentBattleInfo.enemyLocation, currentBattleInfo.location, 1, 0);
                surfWave.setBins(new double[]{1});
            }
            Point2D.Double forward = predictPosition(currentBattleInfo.location, surfWave, 1, true);
            int timeForward = lastPredictionTime;
            Point2D.Double reverse = predictPosition(currentBattleInfo.location, surfWave, -1, true);
            int timeBack = lastPredictionTime;
            Point2D.Double stop = predictPosition(currentBattleInfo.location, surfWave, 0, true);
            int timeStop = lastPredictionTime;
            Wave secondWave = getSecondWave();
            double dangerRight;
            double dangerLeft;
            double dangerStop;
            if (secondWave == null) {
                double distanceTraveled = surfWave.distanceTraveled;
                surfWave.distanceTraveled += timeForward * surfWave.waveVelocity;
                dangerRight = getDanger(forward);
                surfWave.distanceTraveled = distanceTraveled + timeBack * surfWave.waveVelocity;
                dangerLeft = getDanger(reverse);
                surfWave.distanceTraveled = distanceTraveled + timeStop * surfWave.waveVelocity;
                dangerStop = getDanger(stop);
                surfWave.distanceTraveled = distanceTraveled;
            } else {
                double firstDistanceTraveled = secondWave.distanceTraveled;
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeForward;
                dangerRight = getDangerMultiWave(forward,
                        predictPosition(forward, secondWave, 1, false),
                        predictPosition(forward, secondWave, 0, false),
                        predictPosition(forward, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeStop;
                dangerStop = getDangerMultiWave(stop,
                        predictPosition(stop, secondWave, 1, false),
                        predictPosition(stop, secondWave, 0, false),
                        predictPosition(stop, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled + secondWave.waveVelocity * timeBack;
                dangerLeft = getDangerMultiWave(reverse,
                        predictPosition(reverse, secondWave, 1, false),
                        predictPosition(reverse, secondWave, 0, false),
                        predictPosition(reverse, secondWave, -1, false));
                secondWave.distanceTraveled = firstDistanceTraveled;
            }
            dangerRight /= getMaxToCurrentMEA(forward, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            dangerStop /= getMaxToCurrentMEA(stop, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            dangerLeft /= getMaxToCurrentMEA(reverse, currentBattleInfo.enemyLocation, surfWave.waveVelocity);
            double moveAngle = 0;
            int moveDir = 0;
            if (dangerRight <= dangerLeft && dangerRight <= dangerStop) {
                moveDir = 1;
            } else if (dangerRight > dangerLeft && dangerLeft <= dangerStop) {
                moveDir = -1;
            }
            nextPosition = (Point2D.Double) possibleFuturePositions[moveDir + 1];
            moveAngle = getWallSmoothingAngle(surfWave, currentBattleInfo.location, moveDir);
            setBackAsFront(moveAngle, Math.abs(moveDir) * 8);
        }

        public double getDanger(Point2D.Double position) {
            double waveDanger = 0;
            if (MoveUtils.distanceToWall(position.x,
                    position.y,
                    currentBattleInfo.battleFieldWidth,
                    currentBattleInfo.battleFieldHeight) <= 18) {
                return Double.POSITIVE_INFINITY;
            }
            if (waves.isEmpty()) {
                return 1 / position.distance(currentBattleInfo.enemyLocation);
            }
            Wave surfWave = getClosestSurfableWave();
            waveDanger += getBotWidthDanger(position, surfWave) * surfWave.waveDamage / position.distance(currentBattleInfo.enemyLocation)/* * getMaxToCurrentMEA(position, currentBattleInfo.enemyLocation, surfWave.waveVelocity)*/;
            return waveDanger;
        }

        public double getMaxToCurrentMEA(Point2D.Double position, Point2D.Double enemyPosition, double bulletSpeed) {
            WallSmoothingMEACalculator wsmc = new WallSmoothingMEACalculator(currentBattleInfo.battleFieldWidth, currentBattleInfo.battleFieldHeight, 0.01);
            wsmc.calculateEscapeAngle(position, enemyPosition, bulletSpeed);
            double escapeAngleWithoutWalls = Math.asin(8 / bulletSpeed);
            double escapeAngle = Math.abs(normalRelativeAngle(wsmc.getEscapeAngle(1) - wsmc.getEscapeAngle(-1)));
            return (escapeAngle / escapeAngleWithoutWalls) * 0.5;
        }

        public double getDangerMultiWave(Point2D.Double position, Point2D.Double positionAhead, Point2D.Double positionStop, Point2D.Double positionBack) {
            //Wave firstWave = getClosestSurfableWave();
            Wave secondWave = getSecondWave();
            return (getDanger(position)
                    + Math.min(Math.min(getBotWidthDanger(positionAhead, secondWave)
                            / positionAhead.distance(currentBattleInfo.enemyLocation),
                            getBotWidthDanger(positionStop, secondWave)
                            / positionStop.distance(currentBattleInfo.enemyLocation)),
                            getBotWidthDanger(positionBack, secondWave)
                            / positionBack.distance(currentBattleInfo.enemyLocation))
                    * SECOND_WAVE_DANGER
                    * secondWave.waveDamage)/* / getMaxToCurrentMEA(position, currentBattleInfo.enemyLocation, firstWave.waveVelocity)*/;
        }

        public double getBotWidthDanger(Point2D.Double position, Wave surfWave) {
            Point2D.Double[] points = new Point2D.Double[4];
            int index = 0;
            for (int x = -18; x <= 18; x += 36) {
                for (int y = -18; y <= 18; y += 36) {
                    points[index] = new Point2D.Double(position.x + x, position.y + y);
                    index++;
                }
            }
            int startBin = BINS - 1;
            int finishBin = 0;
            double startBO = Double.POSITIVE_INFINITY;
            double finishBO = Double.NEGATIVE_INFINITY;
            for (Point2D.Double point : points) {
                int bin = surfWave.getBin(point);
                startBin = Math.min(startBin, bin);
                finishBin = Math.max(finishBin, bin);
                double bearingOffset = normalRelativeAngle(MoveUtils.absoluteBearing(surfWave.fireLocation, point) - MoveUtils.absoluteBearing(surfWave.fireLocation, position));
                startBO = Math.min(startBO, bearingOffset);
                finishBO = Math.max(finishBO, bearingOffset);

            }
            double danger = 0;
            for (int i = (int) Math.ceil(startBin); i <= (int) Math.floor(finishBin); i++) {
                danger += surfWave.bins[i] * (1 - surfWave.shadows[i]);
            }
            danger /= finishBin - startBin + 1;
            return danger * Math.abs(normalRelativeAngle(finishBO - startBO));
        }

//        public double getMEADanger(Point2D.Double position, Wave w) {
//            WSMEAC.calculateEscapeAngle(position, w.fireLocation, 0, w.waveVelocity);
//            double escapeAngle = Math.abs(normalRelativeAngle(WSMEAC.getEscapeAngle(1) - WSMEAC.getEscapeAngle(-1)));
//            return 1 / (escapeAngle + 1);
//        }
        public Wave getClosestSurfableWave() {
            if (waves.isEmpty()) {
                return null;
            }
            int surfWaveIndex = 0;
            double lowestTimeLeft = Double.POSITIVE_INFINITY;
            for (int i = 0; i < waves.size(); i++) {
                Wave w = waves.get(i);
                double timeLeft = (w.fireLocation.distance(currentBattleInfo.location) - w.distanceTraveled) / w.waveVelocity;
                if (timeLeft < lowestTimeLeft && timeLeft >= 0) {
                    surfWaveIndex = i;
                    lowestTimeLeft = timeLeft;
                }
            }
            return waves.get(surfWaveIndex);
        }

        public Wave getSecondWave() {
            Wave surfWave = getClosestSurfableWave();
            int secondWaveIndex = -1;
            double lowestTimeLeft = Double.POSITIVE_INFINITY;
            for (int i = 0; i < waves.size(); i++) {
                if (waves.get(i) != surfWave) {
                    Wave w = waves.get(i);
                    double timeLeft = (w.fireLocation.distance(currentBattleInfo.location)
                            - w.distanceTraveled) / w.waveVelocity;
                    if (timeLeft < lowestTimeLeft) {
                        lowestTimeLeft = timeLeft;
                        secondWaveIndex = i;
                    }
                }
            }
            return secondWaveIndex == -1 ? null : waves.get(secondWaveIndex);
        }

        public Point2D.Double predictPosition(Point2D.Double startPos, Wave surfWave, int direction, boolean firstWave) {
            Point2D.Double enemyLocation = (Point2D.Double) currentBattleInfo.enemyLocation.clone();
//            Rectangle2D.Double interception = new Rectangle2D.Double(enemyLocation.x - 36,
//                    enemyLocation.y - 36,
//                    72,
//                    72);
            Point2D.Double predictedPosition = (Point2D.Double) startPos.clone();
            double predictedVelocity = currentBattleInfo.velocity;
            double predictedHeading = currentBattleInfo.heading;
            double maxTurning;
            double moveAngle;
            double moveDirection;
            int counter = 0;
            boolean intercepted = false;

            do {
//                Rectangle2D.Double interception = new Rectangle2D.Double(enemyLocation.x - 36 + 8 * (counter),
//                        enemyLocation.y - 36 + 8 * (counter),
//                        72 + 8 * counter + 1,
//                        72 + 8 * counter + 1);
                moveAngle
                        = getWallSmoothingAngle(surfWave, predictedPosition, direction)
                        - predictedHeading;
                moveDirection = 1;
                if (Math.cos(moveAngle) < 0) {
                    moveAngle += Math.PI;
                    moveDirection = -1;
                }
                moveAngle = Utils.normalRelativeAngle(moveAngle);
                maxTurning = Math.toRadians(10 - 0.75 * Math.abs(predictedVelocity));
                predictedHeading = Utils.normalRelativeAngle(predictedHeading
                        + MoveUtils.limit(-maxTurning, moveAngle, maxTurning));
                if (direction == 0) {
                    if (Math.abs(predictedVelocity) <= 2.0D) {
                        predictedVelocity = 0.0D;
                        intercepted = true;
                    } else {
                        predictedVelocity += (predictedVelocity < 0.0D ? 2 : -2);
                    }
                } else {
                    predictedVelocity += (predictedVelocity * moveDirection < 0 ? 2 * moveDirection : moveDirection);
                }
                predictedVelocity = MoveUtils.limit(-8, predictedVelocity, 8);

                predictedPosition = MoveUtils.project(predictedPosition, predictedHeading, predictedVelocity);
                counter++;
                if (counter == 1 && firstWave) {
                    possibleFuturePositions[direction + 1] = (Point2D.Double) predictedPosition.clone();
                }

                if (predictedPosition.distance(surfWave.fireLocation)
                        < surfWave.distanceTraveled + (counter * surfWave.waveVelocity) + 18
                        || (enemyLocation.distance(predictedPosition) < 36 + 8 * Math.min(counter, 20))
                        || (MoveUtils.distanceToWall(predictedPosition.x,
                                predictedPosition.y,
                                currentBattleInfo.battleFieldWidth,
                                currentBattleInfo.battleFieldHeight) <= 18)) {
                    intercepted = true;
                }
            } while (!intercepted && counter <= 91);
            lastPredictionTime = counter;
            return predictedPosition;
        }

        public double backAsFrontTurn(double newHeading, double oldHeading) {
            return Math.tan(newHeading - oldHeading);
        }

        public double backAsFrontDirection(double newHeading, double oldHeading) {
            return sign(Math.cos(newHeading - oldHeading));
        }

        //CREDIT:Cb
        public double getWallSmoothingAngle(Wave surfWave, Point2D.Double currentLocation, double dir) {
            double battleFieldWidth = currentBattleInfo.battleFieldWidth;
            double battleFieldHeight = currentBattleInfo.battleFieldHeight;
            Rectangle2D.Double battleField = new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN, battleFieldWidth - WALL_MARGIN * 2, battleFieldHeight - WALL_MARGIN * 2);
            double currentAngle = MoveUtils.absoluteBearing(surfWave.fireLocation, currentLocation) + Math.PI / 2;
            if (dir != 0) {
                double extraAngle = (currentLocation.distance(currentBattleInfo.enemyLocation) - PREFERRED_DISTANCE) * AGGRESSION;
                //double wallStick = WALL_STICK + (1000 - currentLocation.distance(currentBattleInfo.enemyLocation)) / 25;//Some great potential in this
                double wallStick = WALL_STICK;
                currentAngle += (dir - 1) * Math.PI / 2 + dir * extraAngle;
                Point2D.Double p = MoveUtils.project(currentLocation, currentAngle, wallStick);
                for (int i = 0; !battleField.contains(p) && i < 4; i++) {
                    if (p.x < WALL_MARGIN) {
                        p.x = WALL_MARGIN;
                        double a = currentLocation.x - WALL_MARGIN;
                        p.y = currentLocation.y + dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.y > battleFieldHeight - WALL_MARGIN) {
                        p.y = battleFieldHeight - WALL_MARGIN;
                        double a = battleFieldHeight - WALL_MARGIN - currentLocation.y;
                        p.x = currentLocation.x + dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.x > battleFieldWidth - WALL_MARGIN) {
                        p.x = battleFieldWidth - WALL_MARGIN;
                        double a = battleFieldWidth - WALL_MARGIN - currentLocation.x;
                        p.y = currentLocation.y - dir * Math.sqrt(wallStick * wallStick - a * a);
                    } else if (p.y < WALL_MARGIN) {
                        p.y = WALL_MARGIN;
                        double a = currentLocation.y - WALL_MARGIN;
                        p.x = currentLocation.x - dir * Math.sqrt(wallStick * wallStick - a * a);
                    }
                }
                return MoveUtils.absoluteBearing(currentLocation, p);
            }
            return currentAngle;
        }

        public double sign(double x) {
            return x >= 0 ? 1 : -1;
        }

        public void setBackAsFront(double moveAngle, double maxVel) {
            a.setMaxVelocity(maxVel);
            double moveAmount = 36;
            double turnAngle = moveAngle - currentBattleInfo.heading;
            if (Math.cos(turnAngle) < 0) {
                turnAngle += Math.PI;
                moveAmount *= -1;
            }
            a.setTurnRightRadians(normalRelativeAngle(turnAngle));
            a.setAhead(moveAmount);
        }
    }

    public void onPaint(Graphics2D g) {
        if (!waves.isEmpty()) {
            for (int w = 0; w < waves.size(); w++) {
                g.setColor(Color.GRAY);
                Wave wave = waves.get(w);
                double mea = wave.maxEscapeAngle;
                double absoluteBearing = wave.absBearing;
                Point2D.Double fireLocation = wave.fireLocation;
                double[] normalizedBins = MoveUtils.normalizeBinValues(wave.bins);
                int predictedBin = MoveUtils.getMostVisitedBin(normalizedBins);
                double binWidth = mea / BINS;
                for (int b = 0; b < BINS; b += 1) {
                    double gfAngle = absoluteBearing + mea * ((b * 1.0 - BINS / 2) / BINS * 2) * wave.lateralDirection;
                    double normalizedVal = normalizedBins[b];
                    if (wave.shadows[b] == 1) {
                        g.setColor(Color.CYAN);
                        Point2D.Double pCurrent = MoveUtils.project(fireLocation, gfAngle - binWidth, wave.distanceTraveled + 5);
                        Point2D.Double pLast = MoveUtils.project(fireLocation, gfAngle + binWidth, wave.distanceTraveled + 5);
                        g.drawLine((int) pCurrent.x, (int) pCurrent.y, (int) pLast.x, (int) pLast.y);
                    } else {
                        g.setColor(heatPass(normalizedVal));
                    }
                    Point2D.Double pCurrent = MoveUtils.project(fireLocation, gfAngle - binWidth, wave.distanceTraveled);
                    Point2D.Double pLast = MoveUtils.project(fireLocation, gfAngle + binWidth, wave.distanceTraveled);

//                    Point2D.Double pCurrent = MoveUtils.project(fireLocation, gfAngle, wave.distanceTraveled);
//                    Point2D.Double pLast = MoveUtils.project(fireLocation, gfAngle, wave.distanceTraveled - wave.waveVelocity);
                    g.drawLine((int) pCurrent.x, (int) pCurrent.y, (int) pLast.x, (int) pLast.y);
//                    if (Math.abs(b - predictedBin) < BAND_WIDTH * 3) {
//                        g.setColor(Color.RED);
//                        Point2D.Double bCurrent = MoveUtils.project(fireLocation, gfAngle - binWidth, wave.distanceTraveled - 5);
//                        Point2D.Double bLast = MoveUtils.project(fireLocation, gfAngle + binWidth, wave.distanceTraveled - 5);
//                        g.drawLine((int) bCurrent.x, (int) bCurrent.y, (int) bLast.x, (int) bLast.y);
//                    }
                }
//                g.setColor(Color.MAGENTA);
//                for (Line2D.Double segment : wave.binSegments) {
//                    g.drawLine((int) segment.x1, (int) segment.y1, (int) segment.x2, (int) segment.y2);
//                }
//                g.setColor(Color.PINK);
//                for (Line2D.Double segment : wave.bulletSegments) {
//                    g.drawLine((int) segment.x1, (int) segment.y1, (int) segment.x2, (int) segment.y2);
//                }
            }
        }

        for (int i = 0; i < bullets.size(); i++) {
            g.setColor(Color.WHITE);
            ShadowBullet b = bullets.get(i);
            Point2D.Double pCurrent = b.location;
            Point2D.Double pLast = MoveUtils.project(b.location, b.absBearing, -b.speed);
            g.drawLine((int) pCurrent.x, (int) pCurrent.y, (int) pLast.x, (int) pLast.y);
        }
        g.setColor(new Color(255, 0, 0, 100));
        //drawDetailedWaveInformation(g, waveSurfing.getClosestSurfableWave());
    }

    public void drawDetailedWaveInformation(Graphics2D g, Wave wave) {
        int stdDif = 10;
        int x = 0;
        for (int i = 0; i < PREDICTORS.size(); i++) {
            View predictor = PREDICTORS.get(i);
            double[] bins = MoveUtils.smooth(MoveUtils.normalizeBinValues(predictor.predict(wave.data, (currentBattleInfo.weightedHitRate / currentBattleInfo.weightedFireRate))), BAND_WIDTH);
            for (int j = 0; j < bins.length; j++) {
                g.drawRect(++x, 0, 1, (int) (bins[j] * 50));
            }
            x += stdDif;
        }
    }

    static Color heatPass(double normalizedValue) {
        int blue = 0;
        int green = 0;
        int red = 0;
//        if (normalizedValue <= 0.25) {
//            blue = 255;
//            green = (int) (normalizedValue / 0.25 * 255);
//            red = 0;
//        } else if (normalizedValue <= 0.5) {
//            green = 255;
//            blue = (int) (255 - (normalizedValue - 0.25) / 0.25 * 255);
//            red = 0;
//        } else if (normalizedValue <= 0.75) {
//            green = 255;
//            blue = 0;
//            red = (int) ((normalizedValue - 0.5) / 0.25 * 255);
//        } else {
//            green = (int) (255 - (normalizedValue - 0.75) / 0.25 * 255);
//            red = 255;
//            blue = 0;
//        }
        green = (int) Math.min(255, 510 - normalizedValue * 510);
        red = (int) Math.min(normalizedValue * 510, 255);
        blue = 127;
        return new Color(red, green, blue);
    }

    public void onRoundEnded(RoundEndedEvent e) {
        for (int i = 0; i < 100; i++) {
            System.out.print("_");
        }
        System.out.println();
        System.out.print("Movement: ");
        double hitRate = currentBattleInfo.weightedHitRate / currentBattleInfo.weightedFireRate;
        System.out.println(hitRate > 0.1 ? "Flat" : "Normal");
        System.out.print("Enemy weighted hit rate:  ");
        System.out.println((int) ((currentBattleInfo.weightedHitRate / currentBattleInfo.weightedFireRate) * 1000) / 10D);
    }
}
