package trab.crusader;
import robocode.*;
//import java.awt.geom.Circle2D;
//import java.lang.Double;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.Color;
import robocode.robocodeGL.*;
import robocode.robocodeGL.system.*;
import java.util.Vector;



public class WaveGrapher {

  //LineGL glLines;
  
  robocode.robocodeGL.system.GLRenderer renderer;
  LineGL[] lines;
  //RectangleGL hitBox;
  
  final int LINES = 27*20;  
  int lineIndex;
  
  public WaveGrapher () {
    lines = new LineGL[ LINES ];
    renderer = robocode.robocodeGL.system.GLRenderer.getInstance();
    /*
    hitBox = new RectangleGL();
    
    hitBox.setSize( 36, 36 );*/
    //renderer.addRenderElement( hitBox ); 
    
    for ( int i = 0; i < LINES; i++ ) {
      lines[i] = new LineGL();
      
      lines[i].setLine( 0,0,0,0 );
      lines[i].setWidth( 0 );
      lines[i].setColor( new Color( 0.2f, 0.8f, 0.4f ) );
      renderer.addRenderElement( lines[i] ); 
    }
    
    lineIndex = 0;
  }

  public void drawWave( Point2D center, double[] bins, double radi, double startA, double angleDelta ) {
    int i = lineIndex;
    int j;
    double totPop;
    double highPop;
    double pop;
    
    radi = radi-10;
    
    for ( ; i < lineIndex+bins.length; i++ ) {
      totPop = 1; 
      highPop = 1;
      pop=1;
      
      for ( int k = 0; k < bins.length; k++ ) {
        totPop += bins[k]+1;  
        if ( bins[k]+1 > highPop ) 
          highPop = bins[k]+1;   
      }
      j = i - ( i / bins.length )* bins.length ;
      pop = bins[j]+1;
       
      //lines[ i ].setColor( getColor( (float)pop/(float)highPop ) );
      lines[ i ].setColor( getColor( (float)pop/(float)totPop ) );
      lines[ i ].setWidth( 3 );
      
      //lines[ i ].setWidth( 12d - 10d * (double)Math.abs((double)bins.length/2d-(double)j)/(double)bins.length/2d );
      lines[ i ].setLine( 
        center.getX() + Math.sin( startA + ((double)j-0.5) * angleDelta ) * radi,
        center.getY() + Math.cos( startA + ((double)j-0.5) * angleDelta ) * radi,
        center.getX() + Math.sin( startA + ((double)j+0.5) * angleDelta ) * radi,
        center.getY() + Math.cos( startA + ((double)j+ 0.5) * angleDelta ) * radi
      );
    }
    lineIndex = i;
  }
  
  public void drawPath( Vector v, double dir ) {
  
    Point2D p1;
    Point2D p2;
  
    for ( int i = 0; i < v.size()-1; i++ )
    {
      p1 = (Point2D)v.elementAt(i);
      p2 = (Point2D)v.elementAt(i+1);
      
      lines[ lineIndex ].setWidth( 2 );
      if ( dir == 1 ) 
        lines[ lineIndex ].setColor( Color.green );
      else if ( dir == -1 ) 
        lines[ lineIndex ].setColor( Color.red );
      else {
        lines[ lineIndex ].setColor( Color.yellow );
        lines[ lineIndex ].setWidth( 10 );
      }
      lines[ lineIndex ].setLine(
        p1.getX(), p1.getY(),
        p2.getX(), p2.getY()
      );
      
      lineIndex++;
    }
  }
  /*
  public void drawHitBox( Point2D loc ) {
    if ( loc != null )
      hitBox.setLocation( loc.getX()-18, loc.getY()-18 );
  }*/
  
  public void startRound() {
    //renderer.addRenderElement( hitBox ); 
    for ( int i = 0; i < LINES; i++ ) {
      renderer.addRenderElement( lines[i] ); 
    }
  }
  /*
  public void endRound() {
    for ( int i = 0; i < LINES; i++ ) {
      renderer.addRenderElement( lines[i] ); 
    }
  } 
  */
    
  public void endTick() {
    for ( int i = lineIndex; i < LINES; i++ ) {
      lines[i].setLine( 0,0,0,0 );
      lines[i].setWidth( 0 );
    }
    lineIndex = 0;
  }
  
  /*  
  for ( int i = 0; i < glLines.length; i++ ) {
    glLines[i] = new LineGL();
    glLines[i].setWidth(8);  
    renderer.addRenderElement( glLines[i] );
  }
  */
  
  Color getColor( float p ) {
    float hueStart = 0.7f;
    float colorAmp = 3.5f;
    return new Color( Color.HSBtoRGB( Math.max(0, hueStart-p*hueStart*colorAmp) ,1.0f, 1.0f ) );
    
  }
  
}