package traker;

import robocode.*;
import java.math.*;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's
import java.util.ArrayList; // for collection of waves
// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Tracker_2 - a robot by Parissou
 */
public class Eraser extends AdvancedRobot
{
	public static int BINS = 47;
    public static double _surfStats[] = new double[BINS];
    public Point2D.Double _myLocation;     // our bot's location
    public Point2D.Double _enemyLocation;  // enemy bot's location
 
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
 
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 160;

	/**
	 * run: Tracker_2's default behavior
	 */
	public void run() {
		setColors(Color.green,Color.green,Color.green); // body,gun,radar
		// Robot main loop
		_enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();
 
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
		setAhead(1);
			do{
			setTurnRadarRight(360);
			scan();
			}while(true);
	}
	class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;
 
        public EnemyWave() { }
    }
 
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, WALL_STICK))) {
            angle += orientation*0.05;
        }
        return angle;
    }
 
    public static Point2D.Double project(Point2D.Double sourceLocation,
        double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }
 
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
 
    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }
 
    public static double bulletVelocity(double power) {
        return (20.0 - (3.0*power));
    }
 
    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }
 
    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }
	double GunHeading = 0;
	double angleToGo = 0;
	public void setGunAngle(double degrees)
	{
		GunHeading = getGunHeading();
		angleToGo = degrees - GunHeading;
		if(angleToGo < -180)
		{
			angleToGo += 360;
			setTurnGunRight(angleToGo);
		}
		else if(angleToGo < 0)
			setTurnGunRight(angleToGo);
		else if(angleToGo < 180)
			setTurnGunRight(angleToGo);
		else
		{
			angleToGo-=360;
			setTurnGunLeft(angleToGo);
		}
		
	}
	double oldTicks = 0;
	double impactx = 0;
	double impacty = 0;
	public double angleToShot(double enemyVelocity,double enemyHeading,double enemyDistance,double firePower)
	{
		
		double Px = 0;
		double Py = 0;
		double Vx = 0;
		double Vy = 0;
		double V = 0;
		double delta = 0;
		double t = 0;
		double a = 0;
		double b = 0;
		double c = 0;
		double P = 0;
		impactx = 0;
		impacty = 0;
		double newTicks = 0;
		double radarHeading = getRadarHeadingRadians();
		double bulletHeading = 0;
		newTicks = getTime();
		P = enemyDistance;
		V = enemyVelocity;
		if(enemyVelocity < 0.0)
			enemyVelocity = -1 * enemyVelocity;
		Px = P * Math.sin(radarHeading);
		Py = P * Math.cos(radarHeading);
		
		Vx = V * Math.sin(enemyHeading);
		Vy = V * Math.cos(enemyHeading);
		
		out.println("P : Px = " + Px + ", Py = " + Py + ", P = " + P + ", radarHeading = " + radarHeading);
		out.println("V : Vx = " + Vx + ", Vy = " + Vy + ", V = " + V + ", enemyHeading = " + enemyHeading);
		a = Math.pow(V,2.0)-Math.pow(firePower,2.0);
		b = (Px*Vx)+(Py*Vy);
		c = Math.pow(P,2.0);
		delta = Math.pow(b,2.0)-(a*c);
		out.println("a = " + a + " b = " + b + " c = " + c);
 		t = (-b - Math.sqrt(delta))/a;
		out.println("delta = " + delta + " t = " + t);
		impactx = Px + (Vx*t);
		impacty = Py + (Vy*t);
		out.println("impactx = " + impactx + " impacty = " + impacty);
		if(impacty == 0){
			if(impactx > 0){
				bulletHeading = Math.PI/2;
			} else {
				bulletHeading = Math.PI*3/2;
			}
		}else {
			bulletHeading = Math.atan(impactx/impacty);
			if(impacty < 0)
				bulletHeading+=Math.PI;
		}
		return bulletHeading*(180/Math.PI);
	}
	int goUp = 1;
	int scannedX = Integer.MIN_VALUE;
 	int scannedY = Integer.MIN_VALUE;
	public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
 
            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
                _enemyWaves.remove(x);
                x--;
            }
        }
    }
	public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;
 
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;
 
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }
 
        return surfWave;
    }
	public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;
 
        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }
	public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);
 
        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            _surfStats[x] += 1.0 / (Math.pow(index - x, 2) + 1);
        }
    }
	public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = getVelocity();
        double predictedHeading = getHeadingRadians();
        double maxTurning, moveAngle, moveDir;
 
        int counter = 0; // number of ticks in the future
        boolean intercepted = false;
 
        do {    // the rest of these code comments are rozu's
            moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
            moveDir = 1;
 
            if(Math.cos(moveAngle) < 0) {
                moveAngle += Math.PI;
                moveDir = -1;
            }
 
            moveAngle = Utils.normalRelativeAngle(moveAngle);
 
            // maxTurning is built in like this, you can't turn more then this in one tick
            maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));
 
            // this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
            // otherwise you want to accelerate (look at the factor "2")
            predictedVelocity +=
                (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
            predictedVelocity = limit(-8, predictedVelocity, 8);
 
            // calculate the new predicted position
            predictedPosition = project(predictedPosition, predictedHeading,
                predictedVelocity);
 
            counter++;
 
            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
        } while(!intercepted && counter < 500);
 
        return predictedPosition;
    }
	public double checkDanger(EnemyWave surfWave, int direction) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));
 
        return _surfStats[index];
    }
 
    public void doSurfing() {
        EnemyWave surfWave = getClosestSurfableWave();
 
        if (surfWave == null) { return; }
 
        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);
 
        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2), -1);
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2), 1);
        }
 
        setBackAsFront(this, goAngle);
    }
	public void onScannedRobot(ScannedRobotEvent e) {
     
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		double firePower = 1;
		String enemyName = e.getName();
		enemyName = enemyName.substring(0, enemyName.length()-3);
		String myName = getName();
		myName = myName.substring(0, myName.length()-3);
		out.println(myName + "," + enemyName + ".");
		if(myName.equals(enemyName)) {
		    out.println("je ne peux pas combattre avec moi meme ");
			turnRadarRight(60);
			firePower = 0;
			}
		 _myLocation = new Point2D.Double(getX(), getY());
 
        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + getHeadingRadians();
 
        setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing
            - getRadarHeadingRadians()) * 2);
 
        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));
 
 
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09
            && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick
 
            _enemyWaves.add(ew);
        }
 
        _oppEnergy = e.getEnergy();
 
        // update after EnemyWave detection, because that needs the previous
        // enemy location as the source of the wave
        _enemyLocation = project(_myLocation, absBearing, e.getDistance());
 
        updateWaves();
        doSurfing();
		// Replace the next line with any behavior you would like		
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
		double angle = Math.toRadians((getHeading() + e.getBearing()) % 360);
		
    	 // Calculate the coordinates of the robot
    	scannedX = (int)(getX() + Math.sin(angle) * e.getDistance());
     	scannedY = (int)(getY() + Math.cos(angle) * e.getDistance());
		
       setTurnRadarRightRadians(Utils.normalRelativeAngle(radarTurn));
	   double Distance = e.getDistance();
	  double velocity = e.getVelocity();
	  double heading = e.getHeadingRadians();
       setGunAngle(angleToShot(velocity,heading , Distance, 17.0));
	   
	  
	   
       if(firePower != 0) {fire(firePower);}
       
	}
	public void onHitByBullet(HitByBulletEvent e) {
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
 
            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
 
                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.abs(bulletVelocity(e.getBullet().getPower()) 
                        - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
            }
 
            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation);
 
                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }
	 public void onPaint(Graphics2D g) {
     
	 String goUpstr = "GoUp = " + String.valueOf(goUp);
		// Set the paint color to a red half transparent color
     g.setColor(new Color(0xff, 0x00, 0x00, 0x80));
     // Draw a line from our robot to the scanned robot
     g.drawLine(scannedX, scannedY, (int)getX(), (int)getY());
	 
 
     // Draw a filled square on top of the scanned robot that covers it
     g.fillOval(scannedX, scannedY, 20, 20);
	 
	 g.setColor(new Color(0xff, 0xff, 0xff, 0x50));
	 
	 g.fillRect(10,10,100,150);
	 
	 g.setColor(new Color(0x00, 0x00, 0x00, 0xff));

	 g.drawRect(9,10,100,150);	

	 g.drawString(goUpstr,20,120);
	 
	 g.drawString("Values",40,145);
	 
	 g.setColor(new Color(0x00, 0x00, 0x00, 0x90));
	 
	 g.drawLine(10,140,110,140);
	 
	 g.setColor(new Color(0x00, 0xff, 0x00, 0x90));

 	 g.drawLine((int)getX() + (int)impactx,(int)getY() + (int)impacty,(int)getX(), (int)getY());
	 g.drawLine((int)getX() + (int)impactx,(int)getY() + (int)impacty,scannedX, scannedY);
	 g.fillOval((int)getX() + (int)impactx,(int)getY() + (int)impacty, 10, 10);
	 
	
 }

} 	 	 	 	 	 	 	 	 	 	 	 	