package axeBots;
import robocode.*;

import java.awt.Shape;
import java.awt.geom.*;
import java.io.*;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeTarget implements Cloneable {
    private Stratego stratego = null; //new Stratego();
    private String name;
    private String alvo = null;
    private double bearing;
    private double absbearing_rad;
    private int hitsOnARow = 0;
    //private double head;
    //private long ctime; //game time that the scan was produced
    //private double speed;
    private double x, y;
    private double distance;
    private double changehead;
    private double changeVel;

    private double phasis = 0;
    private double lastStop = 0;

    //private ScannedRobotEvent alvo = null; 
    private double maxX;
    private double maxY;
    private double acc;

    private double targetWidth;
    private double targetHeight;
    private double timeToHit;
    private static final int maxAmostras = 50;

    private double heads[] = new double[maxAmostras];
    private long times[] = new long[maxAmostras];
    private double vels[] = new double[maxAmostras];
    private double lifes[] = new double[maxAmostras];
    //private double dists[]= new double[maxAmostras - 1];
    private Vector pos = new Vector();
    private Vector interpolated = new Vector();
    private Vector clock = new Vector();
    private int amostras = 0;
    //private int num= 0;
    private boolean isAlive = true;
    private int hitMe = 0;
    private int damage = 0;
    private PrintStream log = null;
    private double attackAngle;
    private Point2D.Double shoudItBe = null;
    private AxeVector adjustVec;
    private int points = 0;
    //private int totPoints= 0;

    private int historyMatch = 50;
    private int maxHistMatch = 50;

    //private double mgun2step= Math.PI / 36;
    private int mgun2lim = 2;

    private int mgun2pos = 0;
    private int mgun2dir = 1;

    // private double mgun1step= Math.PI / 36;
    private int mgun1lim = 1;

    private int mgun1pos = 0;
    private int mgun1dir = 1;

    private double canHitMe = Double.NaN;
    private BulletTracker lastHit = null;

    //    public synchronized int getTargetMisses() {
    //        return stratego.getTargetMisses();
    //    }

    //    public synchronized void resetTargetMisses() {
    //        stratego.resetTargetMisses();
    //    }

    public void fired() {
        //log.println(">>>>>>>>>>>>>>>>   HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+" aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());

        //stratego.fired(bt.getBullet().getPower());

        if (Math.abs(mgun1pos) >= mgun1lim)
            mgun1dir *= -1;
        mgun1pos += mgun1dir;

        //log.println("AxeTarget fired mgun2pos:"+mgun2pos+" mgun2dir:"+mgun2dir );

        if (mgun2dir < 0) {
            if (mgun2pos <= mgun2lim * mgun2dir)
                mgun2dir *= -1;
            else
                mgun2pos += mgun2dir;
        } else if (mgun2dir > 0) {
            if (mgun2pos >= mgun2lim * mgun2dir)
                mgun2dir *= -1;
            else
                mgun2pos += mgun2dir;
        }

        //if(Math.abs( mgun2pos) >= mgun2lim) mgun2dir *= -1;
        //mgun2pos += mgun2dir;

    }

    //private AdvancedRobot pai= null;
    public void setDuel(boolean d) {
        this.setAlvo(HataMoto.getIt().getName());
        stratego.setDuel(d);
    }

    //    public void killedMe() {
    //        stratego.setTotPts(2);
    //    }

    public void hitMe(double dam) {
        HataMoto me = (HataMoto)HataMoto.getIt();
        hitMe++;
        damage += dam;
        this.setAlvo(HataMoto.getIt().getName());
        stratego.setEnemyHitedMe(me.getMoveStrat(), dam);
    }

    public int getHitMe() {
        return damage;
    }

    public void terminate() {
        if (isAlive) {
            stratego.setScore(((HataMoto)HataMoto.getIt()).getTotBots());

        }
        stratego.saveData();
    }

    public double getAttackAngle() {
        return attackAngle;
    }

    public double getDistance() {
        return distance;
    }

    public Shape getShape() {

        HataMoto me = (HataMoto)HataMoto.getIt();

        double dx = me.getWidth();
        double dy = me.getHeight();

        Rectangle2D.Double botRect =
            new Rectangle2D.Double(
                this.pos().x - (dx / 2),
                this.pos().y - (dy / 2),
                dx,
                dy);

        Shape bot = botRect;

        me.out.println(
            this.getName() + " bot rect:" + botRect + " pos:" + this.pos());

        // Create a rotation transform of 30degrees CCW around
        // the the corner of the rectangle. 
        AffineTransform atx =
            AffineTransform.getRotateInstance(
                Math.toRadians(this.getHeading()),
                pos().x,
                pos().y);
        // Take the shape object and create a rotated version 
        Shape atShape = atx.createTransformedShape(bot);

        return atShape;

    }

    /**Return the bearing (0 means our robot heading) in radians
     * Between 0-2PI.
     */
    public double getBearing() {
        return bearing;
    }

    public double getHeading() {
        return heads[0];
    }
    /**Return the absolute bearing (0 means Y axis) in radians
     * Between 0-2PI.
     */
    public double getAbsBearing() {
        return absbearing_rad;
    }

    public double getTimeToHit() {
        return timeToHit;
    }

    //    public int getAimStrat() {
    //        return stratego.getAimStrat();
    //    }

    public int newAimStrat() {
        return stratego.newAimStrat(this);
    }

    //    public  int getPoints() {
    //        return stratego.getTotPts();
    //    }

//    public String getStats() {
//        String ret = "BOT: " + getName() + "\r\n" + stratego.getStats();
//
//        return ret;
//    }

    public boolean isAlive() {
        return isAlive;
    }

    public boolean isIn(Shape s) {
        if (s.contains(this.getX(), this.getY())) {
            return true;
        } else {
            return false;
        }
    }

    public void dead(int pts) {

        stratego.setScore(pts);
        //log.println(this.getName()+"  dead "+pts); 
        isAlive = false;
    }

    public void setTimeToHit(double novo) {
        timeToHit = novo;
    }

    public void hit(BulletTracker bt) {
        this.lastHit = bt;

        this.incHitsOnARow();
        if (isAlive())
            stratego.hit(bt);
    }

    public void missed(BulletTracker bt) {
        this.decHitsOnARow();
        if (isAlive()) {
            stratego.missed(bt);
            AxeVector is = (AxeVector)interpolated.lastElement();
            shoudItBe = bt.getPoint();
            adjustVec =
                new AxeVector(
                    (shoudItBe.getX() - is.getX()),
                    (shoudItBe.getY() - is.getY()));
        }
    }

    public Point2D.Double pos() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public String getName() {
        return name;
    }

    public double getLastEnergy() {
        return lifes[0];
    }

    public double getScanTime() {
        return times[0];
    }

    public Vector getAllPos() {
        return (Vector)pos.clone();
    }

    //    public  Vector getAvgHitVector() {
    //        return stratego.getAvgHitVector();
    //    }
    //
    //    public  Vector getNamesVector() {
    //        return stratego.getNamesVector();
    //    }

    //    public ArrayList getMeleeAimStats() {
    //        return stratego.getMeleeAimStats();
    //    }
    //
    //    public ArrayList getDuelAimStats() {
    //        return stratego.getDuelAimStats();
    //    }

    public AxeTarget(String nome, PrintStream inlog) {

        log = inlog;
        for (int i = 0; i < maxAmostras; i++) {
            heads[i] = 0;
            times[i] = 0;
            vels[i] = 0;
            lifes[i] = 0;
            //pos[i] = null;
        }

        name = nome;

        stratego = new Stratego(nome, log, this);

    }

    public AxeTarget(String nome) {

        name = nome;

        stratego = new Stratego(nome, log);

    }

    public AxeTarget(
        ScannedRobotEvent e,
        AdvancedRobot ft,
        PrintStream inlog) {

        log = inlog;
        for (int i = 0; i < maxAmostras; i++) {
            heads[i] = 0;
            times[i] = 0;
            vels[i] = 0;
            lifes[i] = 0;
            //pos[i] = null;
        }

        //pai = ft;
        //nova instancia, inicializa valores acumulativos
        //head = e.getHeadingRadians();
        //ctime = ft.getTime();				//game time at which this scan was produced
        if (ft != null) {
            maxX = ft.getBattleFieldWidth();
            maxY = ft.getBattleFieldHeight();
            targetWidth = ft.getWidth();
            targetHeight = ft.getHeight();
            //seta

            if (e != null)
                setScanned(e, ft);
        }

        stratego = new Stratego(name, log, this);

    }

    public double getLastLifeDiff() {
        if (amostras < 2)
            return 0;

        double sum = 0;

        if ((lastHit != null)
            && (Double.isNaN(lastHit.getImpactTime()))
            && (lastHit.getImpactTime() == times[0])) {
            sum = RoboMath.getBulletDamage(lastHit.getBullet().getPower());
        }

        return lifes[1] - lifes[0] + sum;
    }

    public void setScanned(ScannedRobotEvent e, AdvancedRobot ft) {
        //ft.//out.print("scanned "+e.getName()+"at:"+e.getTime());
        // shifta amostras
        if (maxAmostras > amostras)
            amostras++;
        //ft.//out.print("vels0:"+vels[0]);
        for (int i = amostras - 1; i > 0; i--) {
            heads[i] = heads[i - 1];
            times[i] = times[i - 1];
            vels[i] = vels[i - 1];
            lifes[i] = lifes[i - 1];

        }
        lifes[0] = e.getEnergy();
        heads[0] = e.getHeadingRadians();
        times[0] = e.getTime(); //sera'ft.getTime??? pensar.
        vels[0] = e.getVelocity();

        if ((vels[0] == 0) && (vels[1] != 0)) {
            phasis = times[0] - lastStop;
            lastStop = times[0];
            this.historyMatch = (int)phasis;
            if (historyMatch > maxHistMatch)
                historyMatch = maxHistMatch;
        }

        //bearing = e.getBearing();

        //the next line gets the absolute bearing to the point where the bot is
        absbearing_rad =
            (ft.getHeadingRadians() + e.getBearingRadians())
                % (2 * RoboMath.PI);
        //this section sets all the information about our target
        name = e.getName();

        double h = 0;
        if (amostras > 1) {
            h = RoboMath.NormaliseBearing(heads[0] - heads[1]);
            h = h / (times[0] - times[1]);
        }
        changehead = h;

        //ft.//out.println("changeVel:"+changeVel+" changehead:"+changehead);

        x = ft.getX() + Math.sin(absbearing_rad) * e.getDistance();
        //works out the x coordinate of where the target is
        y = ft.getY() + Math.cos(absbearing_rad) * e.getDistance();
        //works out the y coordinate of where the target is

        double tbear =
            RoboMath.normalRelativeAngle(
                RoboMath.normalRelativeAngle(e.getBearing())
                    + RoboMath.normalRelativeAngle(ft.getHeading())
                    - 180);

        attackAngle =
            RoboMath.normalRelativeAngle(
                RoboMath.normalRelativeAngle(e.getHeading()) - tbear);
        //log.println(e.getTime()+"/"+ft.getTime()+"/"+times[0] +" AXETARGET head"+RoboMath.normalRelativeAngle( e.getHeading())+" bear"+RoboMath.normalRelativeAngle( e.getBearing())+ " aa:" +attackAngle+ " "+e.getName()+ " tbear:"+tbear+" Hatamoto head:"+RoboMath.normalRelativeAngle( ft.getHeading()));
        AxeVector put = new AxeVector(x, y);
        //*/ft.getX(),ft.getY(),(e.getBearing()+ft.getHeading()),e.getDistance());
        pos.addElement(put);
        clock.addElement(new Long(e.getTime()));

        int last = clock.size() - 1;
        double dT;
        //double mod;
        //double tetha;

        AxeVector lastVec;

        if (last > 0) {
            dT =
                ((Long)clock.elementAt(last)).doubleValue()
                    - ((Long)clock.elementAt(last - 1)).doubleValue();
            lastVec = (AxeVector)pos.elementAt((pos.size() - 2));
        } else {
            dT = 1;
            lastVec = (AxeVector)pos.lastElement();
        }
        //new
        double x0 = lastVec.getX();
        double y0 = lastVec.getY();
        double Dx = put.getX() - x0;
        double Dy = put.getY() - y0;
        double dx = Dx / dT;
        double dy = Dy / dT;

        //AxeVector delta = put.minus(lastVec);
        /*tetha = delta.getRelativeTheta();
        mod = delta.getRelativeModule();
        x0 = lastVec.getX();
        y0 = lastVec.getY();
        */

        //mod = mod/dT;
        AxeVector interpol = null;

        //log.println("setScanned x,y:"+put.getX()+","+put.getY()+" at:"+e.getTime()+" interpols:"+dT);
        //log.println("interpoladed sz:"+interpolated.size()+" pos sz:"+pos.size()+" lastStop:"+lastStop+" phasis:"+phasis);
        for (int i = 0; i < dT; i++) {
            x0 += dx;
            y0 += dy;
            interpol = new AxeVector(x0, y0); //, tetha, mod);
            //log.println("interpolated("+i+") "+interpol.getX()+","+interpol.getY()+" dx:"+dx+" dy:"+dy);
            interpolated.addElement(interpol);
            //x0 = x0 + interpol.getX();	
            //y0 = y0 + interpol.getY();

        }

        //AxeVector interpol = new AxeVector(ft.getX(),ft.getY(),(e.getBearing()+ft.getHeading()),e.getDistance());
        //pos.addElement(put);

        //log.println("setScanned x,y:"+put.getX()+","+put.getY()+" at:"+e.getTime()+" pos:"+pos.size());

        /*
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        //ft.execute();
        ft.//out.print("times:"+nf.format( times[0]));
        for(int i=1; i<amostras; i++)
        {
        ft.//out.print(","+nf.format(times[i]));
        if((i%20)==0)ft.//out.println();
        //ft.execute();
        }
        ft.//out.println();
        //ft.execute();
        ft.//out.print("heads:"+nf.format(heads[0]));
        for(int i=1; i<amostras; i++)
        {
        ft.//out.print(","+nf.format(heads[i]));
        if((i%20)==0)ft.//out.println();
        //ft.execute();
        }
        ft.//out.println();
        //ft.execute();
        ft.//out.print("vels:"+vels[0]);
        for(int i=1; i<amostras; i++)
        {
        ft.//out.print(","+vels[i]);
        if((i%20)==0)ft.//out.println();
        //ft.execute();
        }
        ft.//out.println();
        ft.//out.println("conta:"+num++);
        */
        //ft.//out.println("max vel:"+RoboMath.getMax(vels));
        //ft.//out.println("min vel:"+RoboMath.getMin(vels));
        //ft.execute();

        bearing = e.getBearingRadians();
        //head = e.getHeadingRadians();
        //ctime = ft.getTime();				//game time at which this scan was produced
        //speed = e.getVelocity();
        distance = e.getDistance();

        /*
        if ((e.getDistance() < target.distance)||(target.name == e.getName())) {
        //the next line gets the absolute bearing to the point where the bot is
        double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*PI);
        //this section sets all the information about our target
        target.name = e.getName();
        double h = NormaliseBearing(e.getHeadingRadians() - target.head);
        h = h/(getTime() - target.ctime);
        target.changehead = h;
        target.x = getX()+Math.sin(absbearing_rad)*e.getDistance(); //works out the x coordinate of where the target is
        target.y = getY()+Math.cos(absbearing_rad)*e.getDistance(); //works out the y coordinate of where the target is
        target.bearing = e.getBearingRadians();
        target.head = e.getHeadingRadians();
        target.ctime = getTime();				//game time at which this scan was produced
        target.speed = e.getVelocity();
        target.distance = e.getDistance();	
        }
        */
        //

        if ((this.getLastLifeDiff() <= 3.0)
            && (this.getLastLifeDiff() > 0.0)) {
            HataMoto me = (HataMoto)HataMoto.getIt();
            double bullPow = this.getLastLifeDiff();
            double bullVel = RoboMath.getBulletVelocity(bullPow);
            double dist =
                RoboMath.getrange(
                    this.getX(),
                    this.getY(),
                    me.getX(),
                    me.getY());
            double timeToHit = me.getTime() + (dist / bullVel);

            if ((Double.isNaN(canHitMe)) || (timeToHit < canHitMe)) {
                setCanHitMe(timeToHit);
            }

            stratego.setEnemyFired(me.getMoveStrat());
        }

    }

    private Point2D.Double guessPosition(long when,
    /*AdvancedRobot ft,*/
    int aimKind) {
        double diff = when - times[0];
        double newY, newX;
        /**if the change in heading is significant, use circular targeting**/

        if ((Math.abs(changehead) > 0.00001)
            && ((aimKind == Stratego.AIM_CIRCULAR)
                || (aimKind == Stratego.AIM_CIRCULAR_AVG)
                || (aimKind == Stratego.AIM_CIRCULAR_ACC))) {
            double radius = changeVel / changehead;
            double tothead = diff * changehead;
            newY =
                y
                    + (Math.sin(heads[0] + tothead) * radius)
                    - (Math.sin(heads[0]) * radius);
            newX =
                x
                    + (Math.cos(heads[0]) * radius)
                    - (Math.cos(heads[0] + tothead) * radius);
        }
        /**If the change in heading is insignificant, use linear**/
        else {
            newY = y + Math.cos(heads[0]) * changeVel * diff;
            newX = x + Math.sin(heads[0]) * changeVel * diff;
        }
        //ft.//out.println("guessPosition x,y:"+newX+","+newY);
        return new Point2D.Double(newX, newY);
    }

    private int findBestMatch(double timeToIt) {
        int lastSample = 0;
        double ac = 0;
        for (int j = clock.size() - 1; j >= 1; j--) {
            ac += ((Long)clock.elementAt(j)).doubleValue()
                - ((Long)clock.elementAt(j - 1)).doubleValue();
            if (ac >= timeToIt) {
                lastSample = j - 1;
                break;
            }
        }

        if (lastSample == 0)
            return 0;

        int posQ = pos.size();

        if (posQ < 2)
            return 0;

        AxeVector srch =
            ((AxeVector)pos.elementAt(posQ - 1)).minus(
                (AxeVector)pos.elementAt((posQ - 2)));
        AxeVector test = null;
        AxeVector dif = null;
        double difMod = Double.NaN;
        double difModTst;
        int reference = 0;
            for (int i = 1; i < lastSample /*(posQ-2)*/; i++) {
            test =
                ((AxeVector)pos.elementAt(i)).minus(
                    (AxeVector)pos.elementAt((i - 1)));
            dif = srch.minus(test);
            difModTst = dif.getModule();
            if (Double.isNaN(difMod)) {
                reference = i;
                difMod = difModTst;
            } else if (difModTst < difMod) {
                reference = i;
                difMod = difModTst;
            }

        }

        //log.println("findBestMatch:"+reference+" posQ:"+posQ+" difMod:"+difMod);
        return reference;
    }

    private Point2D.Double PatternMatch(AdvancedRobot ft, double firePower) {
        //int interpols=10;
        //Point2D.Double p;
        //p = new Point2D.Double(x, y);
        double bVel = (20 - (3 * firePower));

        double timeToIt = this.getDistance() / bVel;

        int match = findBestMatch(timeToIt);

        int clockMatch = ((Long)clock.elementAt(match)).intValue();
        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
        int c = match;
        double bulDS, targetDS;
        double bulToTargetS;

        AxeVector nowVec = (AxeVector)pos.lastElement();
        AxeVector refVec = (AxeVector)pos.elementAt((match));
        AxeVector nextVec = (AxeVector)nowVec; //.clone();
        AxeVector tmp;

        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());

        do {
            try {
                c++;
                tmp = nowVec.plus((AxeVector)pos.elementAt(c)).minus(refVec);
                nextVec = tmp;
                bulDS =
                    bVel * (((Long)clock.elementAt(c)).intValue() - clockMatch);
                targetDS = nextVec.getRelativeModule(ft.getX(), ft.getY());

                bulToTargetS = targetDS - bulDS;
            } catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        } while (bulToTargetS > 0);

        return new Point2D.Double(nextVec.getX(), nextVec.getY());

    }

    private Point2D.Double estimateMove(double firePower) {

        try {
            int measured = interpolated.size();

            if (measured < 2) {
                return new Point2D.Double(this.getX(), this.getY());
            }

            double bVel = (20 - (3 * firePower));

            double timeToIt = this.getDistance() / bVel;

            int samples = 5;
            int sampleSize = (int)timeToIt;

            if (measured < sampleSize) {
                sampleSize = measured;
                samples = 1;
            } else if (measured < (samples * sampleSize)) {
                samples = (int) (measured / sampleSize);
            }

            int last = measured - 1;
            int first = last - sampleSize + 1;

            HataMoto.getIt().out.println(
                "measured:"
                    + measured
                    + " samples:"
                    + samples
                    + " sampleSize:"
                    + sampleSize);

            double sumMoveModule = 0;

            for (int i = 0; i < samples; i++) {
                HataMoto.getIt().out.println(
                    "last:" + last + " first:" + first);
                AxeVector srch =
                    ((AxeVector)interpolated.elementAt(last)).minus(
                        (AxeVector)interpolated.elementAt((first)));
                sumMoveModule += srch.getRelativeModule();
                HataMoto.getIt().out.println("sumMoveModule:" + sumMoveModule);
                last = first;
                first = last - sampleSize + 1;
            }

            double avgMoveModule = sumMoveModule / samples;

            HataMoto.getIt().out.println(
                "avgMoveModule:"
                    + avgMoveModule
                    + " samples:"
                    + samples
                    + " sampleSize:"
                    + sampleSize);

            AxeVector agora = (AxeVector)interpolated.elementAt(measured - 1);
            AxeVector antes = (AxeVector)interpolated.elementAt(measured - 2);
            AxeVector diff = agora.minus(antes);

            HataMoto.getIt().out.println("agora:" + agora);
            HataMoto.getIt().out.println("antes:" + antes);
            HataMoto.getIt().out.println("diff:" + diff);

            double direction = diff.getRelativeTheta();

            AxeVector estimated =
                new AxeVector(
                    this.getX(),
                    this.getY(),
                    direction,
                    avgMoveModule);
            HataMoto.getIt().out.println("estimateMove:" + estimated);
            return new Point2D.Double(estimated.getX(), estimated.getY());
        } catch (Throwable e) {
            e.printStackTrace(log);
            // nao consegui pegar a excessao de estouro do vetor do first. tapando buraco.
            return new Point2D.Double(this.getX(), this.getY());
        }

    }

    //interpolated match
    private int findBestInterpolMatch(double timeToIt) {
        int posQ = interpolated.size();

        if (posQ < timeToIt)
            return 0;

        int startSample = posQ - (int)timeToIt - 1;

        AxeVector srch = ((AxeVector)interpolated.lastElement());

        AxeVector srch50 = null;
        if (posQ > 50)
            srch50 =
                ((AxeVector)interpolated.elementAt(posQ - 1)).minus(
                    (AxeVector)interpolated.elementAt((posQ - 51)));
        ;
        AxeVector test = null;
        AxeVector test50 = null;

        AxeVector dif = null;
        AxeVector dif50 = null;

        double difMod = Double.NaN;
        double difModTst;

        double difMod50 = Double.NaN;
        double difModTst50;

        int reference = posQ - 1;

            for (int i = startSample /*(posQ-2)*/; i >= 0; i--) {
            test = ((AxeVector)interpolated.elementAt(i));

            dif = srch.minus(test);
            difModTst = dif.getModule();

            try {
                test50 =
                    ((AxeVector)interpolated.elementAt(i)).minus(
                        (AxeVector)interpolated.elementAt((i - 50)));
                dif50 = srch50.minus(test50);
                difModTst50 = dif50.getModule();
            } catch (Throwable e) {
                test50 = null;
                dif50 = null;
                difModTst50 = Double.MAX_VALUE;
            }

            if (Double.isNaN(difMod)) {
                reference = i;
                difMod = difModTst;
                difMod50 = difModTst50;
            } else if (difModTst < difMod) {
                reference = i;
                difMod = difModTst;
                difMod50 = difModTst50;
            } else if (difModTst == difMod) {
                if ((srch50 != null) && (dif50 != null)) {
                    if (Double.isNaN(difMod50)) {
                        reference = i;
                        difMod = difModTst;
                        difMod50 = difModTst50;
                    } else if (difModTst50 < difMod50) {
                        reference = i;
                        difMod = difModTst;
                        difMod50 = difModTst50;
                    }
                }

            }

        }
        //log.println("findBestMatch:"+reference+" posQ:"+posQ+" difMod:"+difMod);
        return reference;
    }

    private Point2D.Double interpolatedMatch(
        AdvancedRobot ft,
        double firePower) {
        //int interpols=10;
        //Point2D.Double p;
        //p = new Point2D.Double(x, y);
        double bVel = (20 - (3 * firePower));
        double timeToIt = this.getDistance() / bVel;
        int match = findBestInterpolMatch(timeToIt);

        //int clockMatch = ((Long)clock.elementAt(match)).intValue();
        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
        int c = match;
        double bulDS, targetDS;
        double bulToTargetS;

        AxeVector nowVec = (AxeVector)interpolated.lastElement();
        AxeVector refVec = (AxeVector)interpolated.elementAt((match));
        AxeVector nextVec = (AxeVector)nowVec; //.clone();
        AxeVector tmp;

        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());

        do {
            try {
                c++;
                tmp =
                    nowVec.plus((AxeVector)interpolated.elementAt(c)).minus(
                        refVec);
                nextVec = tmp;
                bulDS = bVel * (c - match);
                ;
                targetDS = nextVec.getRelativeModule(ft.getX(), ft.getY());

                bulToTargetS = targetDS - bulDS;
            } catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        } while (bulToTargetS > 0);

        return new Point2D.Double(nextVec.getX(), nextVec.getY());

    }

    //absolute interpolated match
    private int findBestHistoryInterpolMatch(double timeToIt) {
        int posQ = interpolated.size();

        //if(posQ < 2) return 0;
        if (posQ < timeToIt)
            return 0;

        int startSample = posQ - (int)timeToIt - 1;

        int wide;
        if (startSample /*(posQ-1)*/
            < this.historyMatch)
            wide = startSample
            /*(posQ-1)*/;
        else
            wide = this.historyMatch;

        //prepara o vetor com o historico atual
        Vector history = new Vector();
        for (int i = posQ - 1; i > (posQ - 1 - wide); i--) {
            history.addElement(
                ((AxeVector)interpolated.elementAt(i)).minus(
                    (AxeVector)interpolated.elementAt((i - 1))));
        }

        ///////////

        AxeVector srch =
            ((AxeVector)interpolated.elementAt(posQ - 1)).minus(
                (AxeVector)interpolated.elementAt((posQ - 2)));
        AxeVector test = null;
        AxeVector dif = null;
        double difMod = Double.NaN;
        double difModTst;
        Integer reference = null;
        //procura o melhor match
            for (int i = 1; i < startSample /*(posQ-2)*/; i++) {
            test =
                ((AxeVector)interpolated.elementAt(i)).minus(
                    (AxeVector)interpolated.elementAt((i - 1)));
            dif = srch.minus(test);
            difModTst = dif.getModule();
            if (Double.isNaN(difMod) || (difModTst < difMod)) {
                difMod = difModTst;
                //reference = new Integer(i);
            }
        }

        if (Double.isNaN(difMod))
            return 0;

        //log.println("findBestHistoryInterpolMatch:"+reference.intValue()+" posQ:"+posQ+" difMod:"+difMod+" time:"+HataMoto.getIt().getTime());

        //if(reference != null)
        //return reference.intValue();

        Vector iguais = new Vector();
        //procura os iguais
            for (int i = 1; i < startSample /*(posQ-2)*/; i++) {
            test =
                ((AxeVector)interpolated.elementAt(i)).minus(
                    (AxeVector)interpolated.elementAt((i - 1)));
            dif = srch.minus(test);
            difModTst = dif.getModule();
            if (difModTst <= (difMod + 0.0001)) {
                iguais.addElement(new Integer(i));
            }
        }

        //procura entre os iguais o com melhor historico
        double hisDifMod = Double.NaN;
        double hisDifModTst;
        //Integer reference= null;
        int ref = 0;
        //int wideRef = 0;
        for (int j = 0; j < iguais.size(); j++) {
            ref = ((Integer)iguais.elementAt(j)).intValue();
            hisDifModTst = 0;
            if ((ref - 1) < this.historyMatch)
                continue;
            for (int i = 0; i < wide; i++) {
                test =
                    ((AxeVector)interpolated.elementAt(ref - i)).minus(
                        (AxeVector)interpolated.elementAt((ref - i - 1)));
                dif = ((AxeVector)history.elementAt(wide - i - 1)).minus(test);
                hisDifModTst += dif.getModule();
            }

            if (Double.isNaN(hisDifMod) || (hisDifModTst < hisDifMod)) {
                reference = new Integer(ref);
                hisDifMod = hisDifModTst;
            }
        }

        if (reference == null)
            reference = (Integer)iguais.firstElement();
        //log.println("findBestHistoryInterpolMatch:"+reference.intValue()+" posQ:"+posQ+" difMod:"+hisDifMod+" iguais.size:"+iguais.size());
        return reference.intValue();
        ///////////

    }

    private Point2D.Double historyInterpolatedMatch(
        AdvancedRobot ft,
        double firePower) {
        //int interpols=10;
        //Point2D.Double p;
        //p = new Point2D.Double(x, y);
        double bVel = (20 - (3 * firePower));

        double timeToIt = this.getDistance() / bVel;

        int match = findBestHistoryInterpolMatch(timeToIt);

        //int clockMatch = ((Long)clock.elementAt(match)).intValue();
        //log.println("PatternMatch:now"+ft.getTime()+" clockMatch:"+clockMatch);
        //int ticDif = (int)Math.round((RoboMath.getrange(ft.getX(),ft.getY(),p.x,p.y)/bVel));
        int c = match;
        double bulDS, targetDS;
        double bulToTargetS;

        AxeVector nowVec = (AxeVector)interpolated.lastElement();
        AxeVector refVec = (AxeVector)interpolated.elementAt((match));
        AxeVector nextVec = (AxeVector)nowVec; //.clone();
        AxeVector tmp;

        //if(match == 0) return new Point2D.Double(nowVec.getX(), nowVec.getY());

        do {
            try {
                c++;
                tmp =
                    nowVec.plus((AxeVector)interpolated.elementAt(c)).minus(
                        refVec);
                nextVec = tmp;
                bulDS = bVel * (c - match);
                targetDS = nextVec.getRelativeModule(ft.getX(), ft.getY());

                bulToTargetS = targetDS - bulDS;
            } catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        } while (bulToTargetS > 0);

        return new Point2D.Double(nextVec.getX(), nextVec.getY());

    }

    public double getFirePwr(AdvancedRobot ft, int inFront) {
        //        if (aimKind == Stratego.AIM_TOMMYGUN2) {
        //            int qt= ((mgun2lim * 2));
        //            int ref= mgun2pos + mgun2lim;
        //
        //            //if(mgun2step == -1)
        //            //	ref = Math.abs(ref - qt);
        //            if (mgun2dir > 0)
        //                ref= Math.abs(qt - ref);
        //
        //            double pwrstep= (2.9) / (double) (qt);
        //
        //            return (pwrstep * (double)ref) + 0.1;
        //
        //        }

        //double targetDiam= Math.max(ft.getHeight(), ft.getWidth());
        //double pwr = (800+targetDiam)/getDistance();//calibra a distancia
        double pwr = (Math.pow(400, 1.5) * 3) / Math.pow(getDistance(), 1.5);
        //calibra a distancia

        //if(HataMoto.getIt().getOthers()>2)
        //	pwr += 1;

        pwr = pwr * inFront;

        //og.println(" projetil calibrado a distancia:"+pwr+" getDistance():"+getDistance()); 		
        //pwr = pwr*Math.pow(ft.getEnergy()/100,0.25);//calibra pela vida
        ////out.println(" projetil calibrado a energia:"+pwr+" getEnergy:"+getEnergy()); 		
//        if (inFront < 2) {
//            double aat = Math.abs(getAttackAngle());
//            if (aat > 90)
//                aat -= 180;
//
//            aat = Math.abs(aat);
//
//            double modif = 1 / Math.pow((aat / 120) + Math.pow(0.5, 0.5), 2);
//            //log.println(" projetil calibrado pelo angulo de ataque:"+aat+" antes:"+pwr+" depois:"+(pwr*modif)); 		
//
//            pwr *= modif;
//            //if(aat < 15) 
//            //	pwr *= 2;
//            //else
//            //	if(aat > 75) 
//            //	pwr /= 2;
//        }

        //double lim = 15;

        //double pwr = 0.1;
        if (ft.getEnergy() > 15) {
            //double desvio = 3*(this.getEnergy()/100);
            //desvio = Math.random()*6 - 3;
            //pwr = pwr + desvio;//(pwr+((desvioVida*Math.random())-(desvioVida/2)));
            ////out.println(" projetil calibrado pelo acaso:"+pwr+" desvio:"+desvio);   

            //if(this.getEnergy() > 20)
            //calibra pelo angulo de ataque
            /*double aa = Math.abs(aat);
            
            
            if(aa<=lim)
            {
            	pwr = pwr + ((lim - aa)/lim)*3;
            	//out.println(jaera.getName()+" projetil calibrado pelo angulo de ataque:"+aa+" incremento:"+(((lim - aa)/lim)*3));
            }*/

            double ajuste = 3 * stratego.getAvgDistHit(this);

            if (!Double.isNaN(ajuste))
                pwr = pwr + ajuste;

            //log.println(" projetil calibrado pelos acertos:"+pwr);   

            //pwr = pwr+(acertados);//calibra pelos acertados
        }

        /*if(HataMoto.getIt().getOthers() == 1){
        			pwr = pwr / 2;
        		}*/

        if (ft.getEnergy() <= 15) {

            pwr = stratego.getAvgDistHit(this);

            //log.println(" projetil calibrado avgHit:" + pwr);
            if (ft.getEnergy() <= 10) {
                pwr *= ft.getEnergy() / 10;
                //log.println(" projetil calibrado energy < 10:" + pwr);
            }

        }

        if (Double.isNaN(pwr)) {
            pwr = 0.1;
        }

        double prizeEdge = 2;

        pwr += (this.getHitsOnARow() >= prizeEdge)
            ? 1
            : ((this.getHitsOnARow() >= (prizeEdge - 1)) ? 0.5 : 0);

        ////out.println(" projetil calibrado pelos acertos:"+pwr+" acertados:"+acertados);   

        //double desvioVida = 3*(this.getEnergy()/100);
        //pwr = (pwr+((desvioVida*Math.random())-(desvioVida/2)));
        ////out.println(" projetil calibrado pelo acaso:"+pwr+" desvioVida:"+desvioVida);   
        double damage = getLastEnergy();
        double max;

        if (damage <= 4) {
            max = damage / 4;
        } else {
            max = (damage + 2) / 6;
        }

        if (max > 3) {
            max = 3;
        } else if (max < 0.1) {
            max = 0.1;
        }

        if (pwr > max) {
            pwr = max;
        } else if (pwr < 0.1) {
            pwr = 0.1;
        }

        if (ft.getEnergy() - pwr <= 0.1) {
            ////out.println("voltando! getEnergy:"+getEnergy()+" pwr:"+pwr);
            pwr = 0;

        }

        //log.println("*** POTENCIA DE TIRO FINAL pwr:" + pwr);
        return pwr;
    }

    //    public  double getBestAvgHit() {
    //        return stratego.getBestAvgHit();
    //    }

    //    public int getBestMoving() {
    //        return stratego.getBestMoving();
    //    }

    //    public  double getBestAvgDistHit() {
    //        return stratego.getBestAvgDistHit(this.getDistance());
    //    }

    public double getGun(AdvancedRobot ft, double firePower, int aimKind) {
        long time = 0;
        long nextTime;
        int interpols = 10;
        Point2D.Double p;
        p = new Point2D.Double(x, y);
        //ft.//out.println("p: x,y:"+p.x+","+p.y+" vars:"+x+","+y);AIM_INTERPOLATED_MATCH
        if (aimKind == Stratego.AIM_STATIC) {
            p = new Point2D.Double(x, y);
        } else
            /*if(aimKind == Stratego.AIM_ADJUSTED)
            {
            	if(adjustVec!= null)
            		p = new Point2D.Double(p.x+adjustVec.getX(), p.y+adjustVec.getY());
            	
            }
            else*/
            if (aimKind == Stratego.AIM_HISTORY_MATCH) {
                //p = PatternMatch(ft,firePower);
                //log.println("PatternMatch:"+p);
                p = historyInterpolatedMatch(ft, firePower);
                //log.println("historyInterpolatedMatch:"+p);
            } else if (aimKind == Stratego.AIM_INTERPOLATED_MATCH) {
                p = interpolatedMatch(ft, firePower);
            } else if (aimKind == Stratego.AIM_PATTERN_MATCH) {
                p = PatternMatch(ft, firePower);
            } else if (aimKind == Stratego.AIM_MOVEMENT_ESTIMATED) {
                p = estimateMove(firePower);
            } else {
                //if(aimKind == Stratego.AIM_STATIC) interpols = 1; else interpols = 10;

                double v = vels[0];

                if ((aimKind == Stratego.AIM_LINEAR_AVG)
                    || (aimKind == Stratego.AIM_CIRCULAR_AVG)) {
                    v = 0;
                    for (int j = 0; j < amostras; j++) {
                        v += vels[j];
                    }
                    v = v / amostras;
                }

                changeVel = v;

                int timeToAccZero = 0;

                if ((aimKind == Stratego.AIM_CIRCULAR_ACC)
                    || (aimKind == Stratego.AIM_LINEAR_ACC)) {
                    if (amostras > 1) {
                        acc = (vels[0] - vels[1]) / (times[0] - times[1]);
                    }

                    if (acc != 0) {
                        if (((vels[0] >= 0) && (acc > 0))
                            || ((vels[0] <= 0) && (acc < 0)))
                            timeToAccZero = (int)Math.abs((8 - vels[0]) / acc);
                        else
                            timeToAccZero = (int)Math.abs((-vels[0]) / acc);

                    }
                    double timeToTarget =
                        (int)Math.round(
                            (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
                                / (20 - (3 * firePower))));

                    for (int i = 0;
                        ((i < timeToAccZero) && (i < timeToTarget));
                        i++) {
                        changeVel += acc;
                        time = ft.getTime() + i;
                        p = guessPosition(time, aimKind);
                    }
                }

                for (int i = 0; i < interpols; i++) {
                    nextTime =
                        (int)Math.round(
                            (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
                                / (20 - (3 * firePower))));
                    time = ft.getTime() + nextTime;

                    //if(aimKind != Stratego.AIM_STATIC)
                    p = guessPosition(time, aimKind);
                }
                //ft.//out.println("getGun time:"+time+" x,y:"+p.x+","+p.y);
            }
        double targetSlack = Math.max(targetHeight, targetWidth) * (7 / 8);
        //estima o centro, melhorar!!
        if ((p.x) < targetSlack)
            p.x = targetSlack;
        if ((p.y) < targetSlack)
            p.y = targetSlack;
        if ((p.x) > maxX - targetSlack)
            p.x = maxX - targetSlack;
        if ((p.y) > maxY - targetSlack)
            p.y = maxY - targetSlack;

        //offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
        double gunOffset =
            ft.getGunHeadingRadians()
                - (Math.PI / 2 - Math.atan2(p.y - ft.getY(), p.x - ft.getX()));

        //		setTurnGunLeftRadians(NormaliseBearing(gunOffset));
        setTimeToHit(
            Math.round(
                (RoboMath.getrange(ft.getX(), ft.getY(), p.x, p.y)
                    / RoboMath.getBulletVelocity(firePower))));
        return gunOffset;
    }

    //    public Object clone() {
    //        AxeTarget ret= null;
    //        try {
    //            ret= (AxeTarget)super.clone();
    //            for (int i= 0; i < maxAmostras; i++) {
    //                ret.heads[i]= heads[i];
    //                ret.times[i]= times[i];
    //                ret.vels[i]= vels[i];
    //            }
    //
    //        } catch (Throwable e) {
    //            ret= null;
    //            ////out.println("************** nao cloneou!");
    //        }
    //        return ret;
    //    }

    /**
     * @return
     */
    public String getAlvo() {
        return alvo;
    }

    /** Calcula o angulo referente ao heading do alvo em relao ao meu 
     * (0 graus  o vetor ligando o alvo  mim). 
     * @return o angulo (180 - (-180)).
     */
    public double getAngle() {
        HataMoto me = (HataMoto)HataMoto.getIt();
        AxeVector av = new AxeVector(this.pos(), me.pos());
        return RoboMath.normalRelativeAngle(
            av.getRelativeTheta() - this.getHeading());
    }

    /**
     * @param string
     */
    public void setAlvo(String string) {
        alvo = string;
        //        HataMoto.getIt().out.println(
        //            "@@@@@@@@ " + this.getName() + " ALVO:" + string);
    }

    /**
     * @return
     */
    public double getCanHitMe() {
        return canHitMe;
    }

    /**
     * @param d
     */
    public void setCanHitMe(double d) {
        canHitMe = d;
    }

    //    public boolean goodFire() {
    //        return stratego.goodFire(this.getDistance());
    //    }
    //
    //    public AxeScoreReg getScore() {
    //        return stratego.getScore();
    //    }
    //
    //    public ArrayList getAllScores() {
    //        return stratego.getAllScores();
    //    }
    //
    //    public ArrayList getMovings() {
    //        return stratego.getMovings();
    //    }

    public Stratego getStratego() {
        return stratego;
    }

    /**
     * @return
     */
    public int getHitsOnARow() {
        return hitsOnARow;
    }

    /**
     * @param i
     */
    public void resetHitsOnARow() {
        hitsOnARow = 0;
    }

    public void incHitsOnARow() {
        hitsOnARow++;
    }
    
	public void decHitsOnARow() {
			hitsOnARow--;
		}

}
