package tzu.util;

/**
 * Describes a point in the robocode game as an x,y coordinate.
 */

public class Point {

    public double x;
    public double y;

    /** Create a new point. */
    public Point(double x, double y) {

        this.x = x;
        this.y = y;
    }

    /** Get the x coordinate. */
    public double getX() { return x; }
    /** Get the y coordinate. */
    public double getY() { return y; }
    /** Set the x coordinate. */
    public void   setX(double value) { x = value; }
    /** Set the y coordinate. */
    public void   setY(double value) { y = value; }

    /** Add the x,y values this Point's x,y coodinates. */
    public void add(double newX, double newY) {

        x += newX;
        y += newY;
    }

    /** Add the given point to this point. */
    public void add(Point p) {

        x += p.x;
        y += p.y;
    }

    /** Return a string representation of this class. */
    public String toString() {
        return "x=" + BotMath.round2(x) + " y=" + BotMath.round2(y);
    }
}
