package davidalves.net.util;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;

import java.util.*;
import java.awt.Color;
import java.io.*;


//A point
public class Point implements Constants{ 
	double x,y;
	
	static Point origin = new Point(0,0);
	
	public Point(double pX, double pY) {
		x = pX;
		y = pY;
	}
	
	public Point(){
		this(0,0);	
	}
	
	//For debugging
	public String toString(){
		return "(" + Math.round(x) + ", " + Math.round(y) + ")";
	}
	
	//Accessors and mutators
	public double getX(){return x;}
	public double getY(){return y;}
	public void setX(double newX){x = newX;}
	public void setY(double newY){y = newY;}
	
	
	public Point plus(Point p){
		return new Point(x + p.getX(), y + p.getY());
	}
	
	public void add(Point p){
		x += p.getX();
		y += p.getY();
	}
	
	public void subtract(Point p){
		x -= p.getX();
		y -= p.getY();
	}
	
	public Point minus(Point p){
		return new Point(x - p.getX(), y - p.getY());
	}
	
	public boolean equals(Point p){
		if(this.distanceTo(p) < POINT_EQUALITY_THRESHOLD)
			return true;
		return false;
	}
	
	public double distanceTo(Point p){
		return Math.sqrt(Math.pow(p.getX() - x, 2) + Math.pow(p.getY() - y, 2));
	}
	
	public double distanceToOrigin(){
		return Math.sqrt(x * x + y * y);
	}
	
	public Point nearestPossibleRobotLocation(Point arenaSize){
		return new Point(Math.max(Math.min(arenaSize.getX() - 30,x), 30), Math.max(Math.min(arenaSize.getY() - 30,y), 30));
	};
	
	public Point nearestBoundedRobotLocation(Point arenaSize, double borderSize){
		return new Point(Math.max(Math.min(arenaSize.getX() - borderSize,x), borderSize), Math.max(Math.min(arenaSize.getY() - borderSize,y), borderSize));
	};
	
	public double absoluteAngleTo(Point p){
		return DaveMath.absoluteAngle(this, p);
	}
	
	public double getVectorAngle(){
		return origin.absoluteAngleTo(this);
	}
	
	public double getVectorMagnitude(){
		return origin.distanceTo(this);
	}
	
	public Point flipHorizontal(){
		return new Point(-x, y);
	}
	
	public Point flipVertical(){
		return new Point(x, -y);
	}
	
}