/*
 * Created on 20/12/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.pilot;

import java.awt.geom.*;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import axeBots.musashi.*;
import axeBots.util.*;
import axeBots.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FlatPilot extends AxePilot {

    private long lastWallHit= 0;
    public static final double TURNING_RATE= 0.45;
    public static final int FACTOR_QTD= 1;
    private static int[][] countFHits= new int[5][FACTOR_QTD];
    private static int[][] countFShoots= new int[5][FACTOR_QTD];
    
    private boolean upwards= true;

    public static final double[] DIST_SEG_FLAT_FACTORS=
        { 0.72, 0.42, 0.47, 0.75, 0.85 };
//	{ 0.70, 0.45, 0.50, 0.75, 0.85 };
    //{5,1.5,1,1,1};//{30,15,10,15,10};//10
    public static final double[] DIST_SEG_CHANGEDATA_DECAY=
        { 0.0, 0.00, 0.00, 0.0, 0.0 };
    //{1.0,0.50,0.50,0.50,0.50};//{1.0,1.2,0.9,0.7,1.0};//{3.00,4.00,3.15,3.20,3.15};//3.15
    public static final double[] DIST_SEG_BULL_SYNC_RATE= { 0, 0.25, 0.25, 0.25, 0.25 };
    //0.70
    public static final double[] FLAT_FACTORS=
        //{ 0.2, 0.45, 0.60, 0.85, 1.0 };
        //{ 0.15, 0.55, 0.85, 0.95};//{ 0.2, 0.55,  0.80, 1.00};//{ 0.2, 0.45, 0.65, 0.85, 1.2};//, 1.70 };
        //{ 0.15, 0.45, 0.60, 0.70, 0.9};
    { 0.47 }; //{ 0.2, 0.30, 0.45, 0.60, 0.85, 1.0 };<==best
    //{ 0.2, 0.35, 0.5, 0.65, 0.9};//0.85, 1.5};
    public static final double[] DIST_SEGMENTS= { 200, 400, 600, 800, 2000 };
    private int flatIndex= 0; //4;
    private static double[][] factorHits= new double[5][FACTOR_QTD];
    //dist,flatfactor

    private double flatFactor= 10; //40;//47;

    protected static boolean flat= false;
    private int inARow= 0;

    public static final double MIN_DIST= 450;
    public static final double RUN_DIST= 200;

    private int distanceManager= HOLD_OFF;

    private AxeTarget him= null;
    

    private boolean runner= false;

    private int greatDir= 0;

    private boolean invertNext= false;

    /**
     * 
     */
    public FlatPilot() {

        super();
        randomizeFlatFactor();

    }

    private int getDistanceIndex() {

        if (super.getMe().getMyTarget() == null) {
            return 0;
        }

        int ret= 0;

        while (DIST_SEGMENTS[ret]
            < super.getMe().getMyTarget().getDistance()) {
            ret++;
        }
        return ret;
    }

    protected void randomizeFlatFactor() {
        //        //        flatFactor= 0.35 + ((Math.random() * 0.4));
        //        //        getMe().out.println("flatFactor:" + flatFactor);
        //        int d= this.getDistanceIndex();
        //
        //        double avg= RoboMath.getSum(factorHits[d]) / factorHits[d].length;
        //        int ind= 0;
        //        do {
        //            ind= (int)Math.floor(Math.random() * FACTOR_QTD);
        //
        //        } while (Math.abs(ind - flatIndex) <= 1); //(factorHits[d][ind] > avg);
        //
        //        flatIndex= ind;
        //
        //        flatFactor= FLAT_FACTORS[flatIndex];
    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#move()
     */
    public void move() {

        him= getMe().getMyTarget();
        if (him == null) {
            return;
        }

        //runner = (him.getDistance()<MIN_DIST  )?true:false;

        //        if (!runner) {
        double wallsSmooth= noFearFromWalls(30);
//		getMe().out.println(">  noFearFromWalls: "+wallsSmooth);
		
        super.setWallsFear(Double.isNaN(wallsSmooth) || (him.getDistance()<300) || (!flat) );

        this.doTheFlatThing();
        //        }
        //double dToWall= this.distToWall();
        //double timeToWall= expectedTime(dToWall);

        //        getMe().out.println(
        //            "travelTime:"
        //                + travelTime
        //                + " dToWall:"
        //                + dToWall
        //                + " timeToWall:"
        //                + timeToWall
        //                + " re:"
        //                + getMe().isRe()
        //                + " pos:"
        //                + getMe().pos());

        //travelTime= (Math.min(travelTime, timeToWall));

        //changeFactor = 0.35+Math.pow((him.getDistance()/1400.00),1.75); 

        //		if(Math.random()>0.8){
        //					super.getMe().doRe();
        //				}

        if (getMe().getWallAlert().test()) {
            this.distanceManager= GET_CLOSER;
        } else if (him.getDistance() < RUN_DIST) {
            this.distanceManager= RUN_AWAY;
        } else if (him.getDistance() < MIN_DIST) {
            this.distanceManager= GET_AWAY;
        } else {
            this.distanceManager= HOLD_OFF;
        }
        if (super.isWallsFear()) {
            this.doPerpendicularGigle(0,distanceManager,him.pos() );
        } else {
            getMe().setTurnRight(wallsSmooth);
        }

        this.walk(50);

    }

    protected void doTheFlatThing() {
        int d= this.getDistanceIndex();
        double min= (3.0 / 3.0) * DIST_SEG_FLAT_FACTORS[d];
        double max= (3.0 / 3.0) * DIST_SEG_FLAT_FACTORS[d];
        double changeFactor=
            (upwards)
                ? ((super.getMe().isRe()) ? min : max)
                : ((super.getMe().isRe()) ? max : min);
        double travelTime= this.estimateTravelTime();

        double deltaReversed= super.getMe().getTime() - super.getLastReversed();

        for (int i= 0; i < deltaReversed; i++) {
            changeFactor *= 1.0
                - ((1.0 / ((double)travelTime)) * DIST_SEG_CHANGEDATA_DECAY[d]);
        }

        if ((flat) && ((Math.random() * travelTime * changeFactor) < 1)) {
            //getMe().out.println("REVERTENDO.");
            //            double sorte = Math.random()*6.0;
            //            if(flatIndex==(FACTOR_QTD-1) ){
            //				super.getMe().setMaxVelocity( (sorte<2.0)?7:8);
            //            }else{
            //				super.getMe().setMaxVelocity( 8);
            //            }
            //			if(Math.random()<0.1 ){
            //				upwards = !upwards; 
            //			}
            if (Math.random() < DIST_SEG_BULL_SYNC_RATE[d]) {

                invertNext= true; //invert();
            } else {
                invert();
            }

        }
    }

    protected void invert() {
        super.invert();
        invertNext= false;
//        AxeBot.getIt().out.println(">>> invertendo." + lastReversed);
    }

    public void hitByBullet(double pw) {
        if (him == null)
            return;
        if ((inARow >= 2)||(!flat)) {
            int d= getDistanceIndex();
            countFHits[d][flatIndex]++;
            RoboMath.rollAvgs(
                factorHits[d],
                flatIndex,
                RoboMath.getSum(countFHits[d]));
            long lastRevDelta= super.getMe().getTime() - super.getLastReversed();
            long hitAtMaxSpeed=
                (long) ((him.getDistance() + 100)
                    / RoboMath.getBulletVelocity(pw));
            if ((him != null)
                && (him.getDistance() > 200)
                && (hitAtMaxSpeed < lastRevDelta)
                && (!flat)) {
                AxeBot.getIt().out.println(
                    "===========>                ATIVANDO FLAT!!! getDistance:"+him.getDistance()+" lastRevDelta:"+lastRevDelta+" lastReversed:"+super.getLastReversed());
                flat= true;
                invert();
            } else if (flat) {
                //invert();
                this.randomizeFlatFactor();
            }
            inARow= 0;
        }
        //if (Math.random() < (1.0 / 2.0)) {

        //invert();
        //}

    }

    //    public void walk(double dist) {
    //        //			double wallBk= 40;
    //        //			Musashi me = super.getMe(); 
    //        //			
    //        //			double folga = (dist<0)?dist-wallBk:dist+wallBk;
    //        //
    //        //			//newSmoother();
    //        //			AxeVector moving=
    //        //				new AxeVector(me.getX(), me.getY(), me.getHeading(), folga);
    //        //				
    //        //			
    //        //			Line2D.Double trajeto = new Line2D.Double (moving.getStartPoint(),moving.getEndPoint()  ); 
    //        //			
    //        //			double ma= getDistToWall(moving);
    //        //
    //        //			if (this.pathIntersectsWalls( trajeto)) {
    //        //				  me.out.println(
    //        //					  "RRRRRRRREEEEEEEEEEE!!!!! ma:" + ma + " wallBk:" + wallBk);
    //        //				dist *= -1;
    //        //				getMe().doRe(); 
    //        //
    //        //			}
    ////        if (dist < 0) {
    ////            getMe().doRe(true);
    ////        } else {
    ////            getMe().doRe(false);
    ////        }
    ////        //			getMe().out.println(
    //        //							"walk dist:" + dist );
    //        dist *= (super.getMe().isRe()  )?-1:1;
    //
    //        getMe().setAhead(dist);
    //    }

    //		private boolean pathIntersectsWalls(Line2D.Double trajeto){
    //			Rectangle2D.Double field = super.getMe().getField();
    //			return field.intersectsLine( trajeto);
    //			
    //		}

    public void enemyFired() {
        if (inARow >= 2) {

            int d= this.getDistanceIndex();
            countFShoots[d][flatIndex]++;
            if (Math.random() < ((TURNING_RATE) * getAvgCountHits())) {
                randomizeFlatFactor();
                //invert();
            }
        }

        if (invertNext) {
            invertNext= false;
            invert();
        }

        inARow++;

    }

    private double getAvgCountHits(int dIndex, int fIndex) {
        double ret=
            (double)countFHits[dIndex][fIndex]
                / (double)countFShoots[dIndex][fIndex];
        return (Double.isInfinite(ret) | Double.isNaN(ret)) ? 0 : ret;
    }

    private double getAvgCountHits() {
        int dIndex= this.getDistanceIndex();
        int fIndex= flatIndex;
        return getAvgCountHits(dIndex, fIndex);

    }

    protected double estimateTravelTime() {
        double pow= him.getLastBulletPow();
        //pow = (pow<1.5)?1.5:pow;
        double lastBVel= RoboMath.getBulletVelocity(pow);
        double dist= him.getDistance();
        double timeToMe= dist / lastBVel;

        timeToMe= (timeToMe < 10) ? 10 : timeToMe;

        return timeToMe;
    }
    
	

    //    private double expectedTime(double dist) {
    //        double maxVel= super.getMaxVelocity();
    //        double vel= super.getMe().getVelocity();
    //
    //        double finalVel= (super.getMe().isRe()) ? -maxVel : maxVel;
    //        double deAcc= (super.getMe().isRe()) ? 2 : -2;
    //        double acc= (super.getMe().isRe()) ? -1 : 1;
    //        double time= 0;
    //        //        //desacelera
    //        //        while (((vel * finalVel) < 0) && (dist > 0)) {
    //        //            vel += deAcc;
    //        //            time++;
    //        //            dist += Math.abs(vel);
    //        //        }
    //        //
    //        //        while ((Math.abs(vel) < Math.abs(finalVel)) && (dist > 0)) {
    //        //            vel += acc;
    //        //            time++;
    //        //            dist -= Math.abs(vel);
    //        //        }
    //
    //        vel= maxVel;
    //
    //        time += dist / vel;
    //
    //        return time;
    //    }

    //    private double distToWall() {
    //
    //        Rectangle2D.Double field= super.getMe().getField();
    //
    //        double bh= field.getMaxX();
    //        double bw= field.getMaxY();
    //        double diagonal= Math.sqrt((bh * bh) + (bw * bw));
    //
    //        diagonal *= (super.getMe().isRe()) ? -1 : 1;
    //
    //        AxeVector ahead=
    //            new AxeVector(
    //                getMe().getX(),
    //                getMe().getY(),
    //                getMe().getHeading(),
    //                diagonal);
    //
    //        double folga= 50;
    //        double posx= ahead.getX();
    //        double posy= ahead.getY();
    //
    //        double minx= field.getMinX() + folga;
    //        double maxx= field.getMaxX() - folga;
    //        double miny= field.getMinY() + folga;
    //        double maxy= field.getMaxY() - folga;
    //
    //        posx= (posx < minx) ? minx : (posx > maxx) ? maxx : posx;
    //        posy= (posy < miny) ? miny : (posy > maxy) ? maxy : posy;
    //
    //        ahead.setEnd(posx, posy);
    //
    //        return ahead.getModule();
    //
    //        //AxeVector restricted = new AxeVector (vec.getStartPoint(), new Point2D.Double(posx,posy) );
    //
    //        //return restricted.getModule();
    //    }

    public void botHitWall() {
        //double changeFactor= (upwards)?((super.getMe().isRe()  )?min:max):((super.getMe().isRe()  )?max:min);
        //bateu de re. quero que mova mais de frente
        if (super.getMe().isRe()) {
            upwards= true;
        } else {
            upwards= false;
        }
        lastWallHit= super.getMe().getTime();
        //    	super.getMe().out .println("!!!!!!!!!!!!!! vvvaaaiii bbbaaattteeerrr   !!!!!!!!!!!!!!!"+super.getMe().getTime()  ); 

        invert();
        //upwards=!upwards;

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#start()
     */
    public void start() {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#stop()
     */
    public void stop() {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#botHitBot()
     */
    public void botHitBot() {
        invert();

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#botHitWall()
     */

    protected void doPerpendicularGigle(double gigle,int distManagementMode,Point2D .Double  center) {
    	
    	super.setAwayAmt(15);
		super.setCloserAmt(((him.getDistance()<300) || (!flat))?-15:0);
		super.setHoldOffAmt(0);
		super.setRunAwayAmt(30);
        super.doPerpendicularGigle( gigle, distManagementMode, center);
    }

    /**
     * @return
     */
    public double getFlatFactor() {
        return flatFactor;
    }

    /**
     * @param d
     */
    public void setFlatFactor(double d) {
        flatFactor= d;
    }

    /**
     * @return
     */
    public static boolean isFlat() {
        return flat;
    }

    /**
     * @param b
     */
    public static void setFlat(boolean b) {
        flat= b;
    }

    

    public void save(String name) {
        DecimalFormat forma= new DecimalFormat("##0.00");
        DecimalFormat forma2= new DecimalFormat("##0");

        try {
            GZIPOutputStream zipout= null;

            DataOutputStream w= null;
            while (true) {

                try {

                    zipout=
                        AxeFiles.getGZipOutputStream(
                            name + AxeFiles.FLAT_FILE_EXTENSION);
                    //zipout.setLevel(9);
                    break;
                } catch (Throwable th) {
                    AxeBot.getIt().out.println(
                        " XXXXXXXXXXXXXXXXXX saving failed:" + th.getMessage());
                }
            }
            //					log.println(" XXXXXXXXXXXXXXXXXX saving OK:");

            //zipout.putNextEntry(new ZipEntry(dataFileName));
            w= new DataOutputStream(zipout);

            for (int i= 0; i < DIST_SEGMENTS.length; i++) {
                for (int j= 0; j < FLAT_FACTORS.length; j++) {
                    w.writeShort((short)countFHits[i][j]);
                    w.writeShort((short)countFShoots[i][j]);
                    AxeBot.getIt().out.print(
                        forma.format(this.getAvgCountHits(i, j))
                            + "("
                            + countFHits[i][j]
                            + "/"
                            + countFShoots[i][j]
                            + ")"
                            + "  ");
                }
                AxeBot.getIt().out.println();
            }

            // PrintStreams don't throw IOExceptions during prints,
            // they simply set a flag.... so check it here.
            w.flush();
            zipout.finish();
            //zipout.closeEntry();
            w.close();
        } catch (IOException e) {
            AxeBot.getIt().out.println("IOException trying to write: " + e);
        }
    }

    public void load(String name) {
        DataInputStream r= null;
        DecimalFormat forma= new DecimalFormat("##0.00");

        //String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
        GZIPInputStream zipin= null;
        try {
            File f= AxeFiles.findFile(name + AxeFiles.FLAT_FILE_EXTENSION);
            zipin= new GZIPInputStream(new FileInputStream(f));
            //zipin.getNextEntry();

            r= new DataInputStream(zipin); //new FileInputStream(f));

            for (int i= 0; i < DIST_SEGMENTS.length; i++) {
                for (int j= 0; j < FLAT_FACTORS.length; j++) {
                    countFHits[i][j]= r.readShort();
                    countFShoots[i][j]= r.readShort();
                    AxeBot.getIt().out.print(
                        forma.format(this.getAvgCountHits(i, j))
                            + "("
                            + countFHits[i][j]
                            + "/"
                            + countFShoots[i][j]
                            + ")"
                            + "  ");
                }
                AxeBot.getIt().out.println();
            }

        } catch (Throwable e) {
            AxeBot.getIt().out.println("IOException trying to read: " + e);
            // Something went wrong reading the file, Start from scratch
            //			initialise();
        } finally {
            try {
                r.close();
                zipin.close();
            } catch (Throwable e2) {};
        }
    }

}
