package tobe.util;

/**
 * CircularArray - By Torbjorn Gannholm
 * Copyright (C) 2002 Torbjorn Gannholm
 * 
 * A CircularArray of size N stores (logs) the latest N objects added to it.
 * The reason for this implementation is processing speed.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
public class CircularArray implements java.io.Serializable {

    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    /** The array of objects */
    private Object[] elements;
    /** If all elements of the array are occupied */
    boolean full = false;
    /** Useful for iterating */
    int next = 0;
    
    /** Unsupported constructor */
    private CircularArray() {}
    
    /**
     * Construct the CircularArray
     *
     * @param size - How many elements to make it
     */
    public CircularArray(int size) {
	elements = new Object[size];
	clear();
    }
    
    /**
     * Add an element to the array
     *
     * @param o - The object to add
     */
    public void add(Object o) {
	elements[next++] = o;
	if(next >= elements.length) {
	    full = true;
	    next = 0;
	}
    }
    
    /**
     * Clear the array
     */
    public void clear() {
	next = 0;
	full = false;
    }
    
    /**
     * Get an element of the array.
	 * A negative value gets elements from the end (-1 is the latest inserted, while 0 is the oldest value).
     *
     * @param i - Position to get.
     * @return The Object
     */
    public Object get(int i) {
	if( full || i < 0 ) {
	    i += next;
	}
	if( i >= size() ) i = i % size();
	while( i < 0 ) i += size();
	return elements[i];
    }
    
    public int size() {
	if( full ) return elements.length;
	return next;
    }
    
	/** returns an iterator from the oldest to the latest value */
    public java.util.Iterator iterator() {
	return new java.util.Iterator() {//cool! An anonymous inner class to implement the Iterator interface.
		int index = 0;
		public boolean hasNext() {
		    return (index < size());
		}
		public Object next() {
		    return get(index++);
		}
		public void remove() {  // (DJC) Perhaps this should be supported...
		    throw new UnsupportedOperationException();
		}
	    };
    }
    
	/** returns an iterator from the latest value to the oldest*/
    public java.util.Iterator reverseIterator() {
	return new java.util.Iterator() {
		int index = -1;
		public boolean hasNext() {
		    return (index >= -size());
		}
		public Object next() {
		    return get(index--);
		}
		public void remove() {  // (DJC) Perhaps this should be supported...
		    throw new UnsupportedOperationException();
		}
	    };
    }
   
}
