package franzor;

/**
 * MyClass - a class by (your name here)
 */
public class MathVector {
	private double x, y;
	
	public MathVector(double mag, double dir) {
		x = mag*Math.sin(dir);
		y = mag*Math.cos(dir);
	}
	
	public void add(MathVector mv) {
		x += mv.x;
		y += mv.y;
	}
	
	//given mag and dir; avoids creating
	//a new MathVector
	public void add(double mag, double dir) {
		x += mag*Math.sin(dir);
		y += mag*Math.cos(dir);
	}

	public double getDirection() {
		return Math.atan2(x, y); //Arc Cotangent
	}
	
	public double getMagnitude() {
		return Math.sqrt(x*x+y*y);
	}
	
	public double getXComp() {
		return x;
	}
	
	public double getYComp() {
		return y;
	}		
}
