package stelo;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;

// random movement
// GuessFactor targeting
// wavesurfing
public class Randomness extends AdvancedRobot {
    static final double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

	double lastEnemyAbsoluteBearing;
	double lastEnemyHeading;
	double maxPower = 3.0;
	
	String targetName = null;
	double targetDistance = Double.POSITIVE_INFINITY;
	double awayFactor = 1.0;
	GFTargeting gft;

    public void run() {
        setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		awayFactor = getOthers() > 1 ? 1.5 : 1.0;
		
		gft = new GFTargeting();

        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
		boolean isTarget = false;
	
		if (targetName == null || targetName != e.getName() && (e.getDistance() < targetDistance - 200 || e.getDistance() < 100 || e.getEnergy() <= 12.0)) {
			// change target
			targetName = e.getName();
			out.println(targetName);
		}
		
		if (e.getName() == targetName) {
			targetName = e.getName();
			targetDistance = e.getDistance();
			isTarget = true;
		} else
			return;
			
        robotLocation = new Point2D.Double(getX(), getY());
        enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
		
		attack(e);
		lastEnemyAbsoluteBearing = enemyAbsoluteBearing;
		move(e);
		
		if (getOthers() <= 1 || Math.random() < 0.95) {
        	setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2.0);
		} else
			out.println("spin");
    }

	private void attack(ScannedRobotEvent e) {
		double bulletPower = maxPower;
		
		if (e.getDistance() < 200) bulletPower = 3.0;
				
		double w = deg2rad(e.getHeading() ) - lastEnemyHeading;
		
		// 3 -> 12 + 4 = 16 dmg
		// 2 -> 8 + 2 = 10 dmg
		// 1 -> 4 dmg
		bulletPower = Math.min(bulletPower, e.getEnergy() > 4.0 ? (e.getEnergy() + 2.0) / 6.0 : e.getEnergy() / 4.0);
		bulletPower = Math.min(bulletPower, getEnergy() - 2.0);
		
		lastEnemyHeading = deg2rad(e.getHeading() );
				
		if (bulletPower <= getEnergy()) {
			//fire(bulletPower); // to use FiringAssistance, fire before move!

			/*			
			if (w == 0)
				linearTarget(bulletPower, e);
			else {
				circularTarget(bulletPower, e, w);
			}
			if (Math.random() < 0.3)
				headOnTarget(e);
			*/
			gft.attack(this, e, bulletPower);
			//setFire(bulletPower);
		}
		
	}
	
	private double deg2rad(double d) {
		return d * Math.PI / 180;
	}
	
	private double rad2deg(double r) {
		return r * 180 / Math.PI;
	}		

    // Always try to move a bit further away from the enemy.
    // Only when the walls forces us we will close in on the enemy. We never bounce of walls.
    void move(ScannedRobotEvent e) {
		considerChangingDirection();
		Point2D robotDestination = null;
		double tries = 0;
		//double awayFactor = getOthers() > 1 ? 1.5 : 1.0;
		
		do {
			//robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
			//	    enemyDistance * (1.1 - tries / 100.0), enemyLocation);
			robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
				    enemyDistance * awayFactor * (1.1 - tries / 200.0), enemyLocation);	
				
			tries++;
		} while (tries < 200 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));
		
		// } while (tries < 100 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));
				
		goTo(robotDestination);
    }

    void considerChangingDirection() {
		// Change lateral direction at random
		// Tweak this to go for flat movement
		double flattenerFactor = 0.05 * awayFactor;
		
		if (Math.random() < flattenerFactor) {
		    movementLateralAngle *= -1;
		}
    }
	
	/*
    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
	    	getBattleFieldWidth() - margin * 2, getBattleFieldHeight() - margin * 2, 75, 75); // 75
    }
	*/

 	Rectangle2D fieldRectangle(double margin) {
		return new Rectangle2D.Double(margin, margin,
	    	getBattleFieldWidth() - margin * 2, getBattleFieldHeight() - margin * 2); 
	}
	
    void goTo(Point2D destination) {
		destination.setLocation(limit(35, destination.getX(), getBattleFieldWidth() - 35), limit(35, destination.getY(), getBattleFieldHeight() - 35));
	
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		setMaxVelocity(Math.abs(getTurnRemaining()) > 30 ? 0 : MAX_VELOCITY);
		
		
		// vibrate
		if (Math.abs(getTurnRemaining()) < 1) {
			setTurnRight(Math.random() < 0.5 ? 10 : -10);
		}
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

	public void onHitByBullet(HitByBulletEvent e) {
		if (getOthers() > 1) {
			targetName = e.getName();
		}
		//movementLateralAngle *= -1;
		//awayFactor = limit(0.9, awayFactor + 0.1, 1.3);
	}
	
    public void onBulletHit(BulletHitEvent e) {
		maxPower = limit(1.0, maxPower + 0.2, 3.0);
		//awayFactor = limit(0.9, awayFactor + 0.1, 1.3);
		out.println(awayFactor);
    }

	public void onBulletMissed(BulletMissedEvent e) {
		maxPower = limit(0.1, maxPower - 0.1, 3.0);
		//awayFactor = limit(0.9, awayFactor - 0.1, 1.3);
		out.println(awayFactor);
	}
	
    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName() == targetName)
			targetName = null;
	}
}

class GFTargeting
{
	double lateralDirection = 1.0;
	double lastEnemyVelocity = 0.0;
	
	public void attack(AdvancedRobot r, ScannedRobotEvent e, double bullet_power) {
		double enemyAbsoluteBearing = r.getHeadingRadians() + e.getBearingRadians();
		double enemyDistance = e.getDistance();
		double enemyVelocity = e.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave wave = new GFTWave(r);
		wave.gunLocation = new Point2D.Double(r.getX(), r.getY());
		GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = bullet_power;
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		r.setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - r.getGunHeadingRadians() + wave.mostVisitedBearingOffset()));
		r.setFire(wave.bulletPower);
		if (r.getEnergy() >= bullet_power) {
			r.addCustomEvent(wave);
		}
		// movement.onScannedRobot(e);
		r.setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - r.getRadarHeadingRadians()) * 2);
	}
}
	
class GFTWave extends Condition {
	static Point2D targetLocation;

	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;

	private static double MAX_DISTANCE = 2000;
	private static final int DISTANCE_INDEXES = 5;
	private static final int VELOCITY_INDEXES = 5;
	private static final int BINS = 25;
	private static final int MIDDLE_BIN = (BINS - 1) / 2;
	private static final double MAX_ESCAPE_ANGLE = 0.7;
	private static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
	
	private static int[][][][] statBuffers = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][VELOCITY_INDEXES][BINS];

	private int[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled;
	
	GFTWave(AdvancedRobot _robot) {
		this.robot = _robot;
		MAX_DISTANCE = Math.sqrt(_robot.getBattleFieldWidth() * _robot.getBattleFieldWidth() + _robot.getBattleFieldHeight() * _robot.getBattleFieldHeight());
	}
	
	public boolean test() {
		advance();
		if (hasArrived()) {
			buffer[currentBin()]++;
			robot.removeCustomEvent(this);
		}
		return false;
	}

	double mostVisitedBearingOffset() {
		return (lateralDirection * BIN_WIDTH) * (mostVisitedBin() - MIDDLE_BIN);
	}
	
	void setSegmentations(double distance, double velocity, double lastVelocity) {
		int distanceIndex = (int)(distance / (MAX_DISTANCE / DISTANCE_INDEXES));
		int velocityIndex = (int)Math.abs(velocity / 2);
		int lastVelocityIndex = (int)Math.abs(lastVelocity / 2);
		buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
	}

	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}

	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation) - 18;
	}
	
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * BIN_WIDTH)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
	
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
}

class GFTUtils {
	static double bulletVelocity(double power) {
		return 20 - 3 * power;
	}
	
	static Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}

	static int sign(double v) {
		return v < 0 ? -1 : 1;
	}
	
	static int minMax(int v, int min, int max) {
		return Math.max(min, Math.min(max, v));
	}
}								