package ph.targeting;
import ph.*;
import robocode.*;
import ph.intelligence.*;
import synnalagma.test.neuralib.*;
import apv.*;
import java.util.*;

public class TargetingModule_NN_new extends RobotModule {
    
    private ModularRobot robot;
    private static NeuralNetwork nn;
    //private static Vector learningVectors;
    //private static Vector nrLearningVectors; //nr means "non-removable"
    //private Random rnd=new Random();
    
    private static final int patternSize=30;
    //private static final int learningSetSize=300;
    
    /** Creates a new instance of TargetingModule_NN_new */
    public TargetingModule_NN_new(ModularRobot robot) {
        this.robot=robot;
        int[] nnLayers = {
            patternSize*2,       // input layer
            patternSize,         // hidden layer #1
            (int)patternSize/3,  // hidden layer #2
            2                    // output layer
        };
        nn=new NeuralNetwork(nnLayers);
        //learningVectors=new Vector();
        //nrLearningVectors=new Vector();
    }
    
    private double[] nnInputFromMovementHistory(Vector mHistory) {
        double[] input = new double[2*patternSize];
        int counter = 0;
        for(int i=1; i<patternSize+1; i++) {
            robotInfo ri=(robotInfo)mHistory.elementAt(i);
            input[counter]=ri.calculatedHeadingChange();
            input[counter+1]=ri.calculatedDistance();
            counter += 2;
        }
        return input;
    }
    
    private double[] nnInputFromMinimalRobotInfo(Vector vmri) {
        double[] input = new double[2*patternSize];
        int counter = 0;
        for(int i=0; i<patternSize; i++) {
            minimalRobotInfo mri=(minimalRobotInfo)vmri.elementAt(i);
            input[counter]=mri.headingChange();
            input[counter+1]=mri.distance();
            counter += 2;
        }
        return input;
    }
    
    private minimalRobotInfo minimalRobotInfoFromRobotInfo(robotInfo ri) {
        return new minimalRobotInfo(ri.calculatedHeadingChange(),
        ri.calculatedDistance(), (long)ri.time());
    }
    
    private minimalRobotInfo minimalRobotInfoFromNNOutput(double[] nnOutput,
    long time) {
        return new minimalRobotInfo(nnOutput[0],nnOutput[1],time);
    }
    
    private void learn(robotInfo target) {
        if(target.movementHistory().size()<patternSize+1) return;
        Vector mHistory=target.movementHistory();
        double[] input = nnInputFromMovementHistory(mHistory);
        double[] output = new double[2];
        robotInfo ri=(robotInfo)mHistory.elementAt(0);
        output[0]=ri.calculatedHeadingChange();
        output[1]=ri.calculatedDistance();
        nn.train(input, output);
        /*LearningVector lv=new LearningVector(input,output);
        learningVectors.addElement(lv);
        if(Math.random()<0.01) {
            nrLearningVectors.add(lv);
        }
        while(learningVectors.size()>learningSetSize) {
            learningVectors.removeElementAt(rnd.nextInt(learningVectors.size()));
        }*/
    }
    
   /* private void train() {
        for(int i=0; i<learningVectors.size(); i++) {
            if(Math.random()<=0.3) {
                LearningVector lv=(LearningVector)learningVectors.elementAt(i);
                nn.train(lv.input(),lv.output());
            }
        }
        for(int i=0; i<nrLearningVectors.size(); i++) {
            LearningVector lv=(LearningVector)nrLearningVectors.elementAt(i);
            nn.train(lv.input(),lv.output());
        }
    }*/
    
    private Vector predBufferFromMovementHistory(Vector mHistory) {
        Vector b=new Vector();
        for(int i=0; i<patternSize; i++) {
            b.addElement(minimalRobotInfoFromRobotInfo(
            (robotInfo)mHistory.elementAt(i)));
        }
        return b;
    }
    
    public void execute() {
        //train();
        if(robot.otherRobotsInfo.size()==0) return;
        robotInfo target=(robotInfo)robot.otherRobotsInfo.elementAt(0);
        if(target.movementHistory().size()<patternSize) return;
        learn(target);
        if(robot.getGunHeat()/robot.getGunCoolingRate()>1) return;
        if(robot.getGunTurnRemaining()>0.01) return;
        double robotX=robot.getX();
        double robotY=robot.getY();
        double robotGunHeading=robot.getGunHeading();
        Vector predBuffer=predBufferFromMovementHistory(target.movementHistory());
        double targetX=((robotInfo)target.movementHistory().elementAt(0)).x();
        double targetY=((robotInfo)target.movementHistory().elementAt(0)).y();
        double targetHeading=((robotInfo)target.movementHistory().elementAt(0)).calculatedHeading();
        long targetTime=(long)((robotInfo)target.movementHistory().elementAt(0)).time();
        double firePower = 2;
        long robotTime = robot.getTime();
        while((targetTime-robotTime-gunTurnTime(Math.abs(utils.normalRelativeAngle(robotGunHeading-utils.getBearing(robotX,robotY,targetX,targetY)))))*(20-3*firePower)<utils.dist(robotX,robotY,
        targetX,targetY)) {
            double[] nnInput=nnInputFromMinimalRobotInfo(predBuffer);
            double[] nnOutput=nn.forwardPass(nnInput);
            targetTime++;
            minimalRobotInfo mri=minimalRobotInfoFromNNOutput(nnOutput,targetTime);
            predBuffer.insertElementAt(mri,0);
            targetHeading += mri.headingChange();
            targetX += mri.distance() * Math.sin(Math.toRadians(targetHeading));
            targetY += mri.distance() * Math.cos(Math.toRadians(targetHeading));
        }
        double aimingGunHeading=utils.getBearing(robotX,robotY,targetX,targetY);
        robot.turnGunRight(utils.normalRelativeAngle(aimingGunHeading-robot.getGunHeading()));
        robot.fire(firePower);
    }
    
    private long gunTurnTime(double gunTurnAngle) {
        if(gunTurnAngle<=20)
            return 0;
        else if(gunTurnAngle<=40)
            return 1;
        else if(gunTurnAngle<=60)
            return 2;
        else if(gunTurnAngle<=80)
            return 3;
        else if(gunTurnAngle<=100)
            return 4;
        else if(gunTurnAngle<=120)
            return 5;
        else if(gunTurnAngle<=140)
            return 6;
        else if(gunTurnAngle<=160)
            return 7;
        else
            return 8;
    }
    
    private class LearningVector {
        private double[] input;
        private double[] output;
        
        public LearningVector(double[] input, double[] output) {
            this.input=input;
            this.output=output;
        }
        
        public double[] input() {
            return input;
        }
        
        public double[] output() {
            return output;
        }
        
    }
    
}
