package fire219.cymba;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.Graphics2D;
//import java.awt.Color;

/**
 * Cymba - a robot by fire219
 * version 1.8 
 * 2-1-15
 * Proving simple is better since 2014
 */
public class Cymba extends AdvancedRobot
{
	int moveDirection = 1; //-1 = left, 1 = right  
	int turnmodifier = 0; //angle rotation in/out from target
	double nprand = 0; //random generator for Linear Gun
	double lastenergy = 0; // last target energy
    int fliptimer = 0; //timer for scheduled direction change
	int antiwalltimer = 0; //"ignore wall-avoidance" timer
	int guntype = 0; //0 = Linear, 1 = HOT
	int guntypetimer = 0; //timer for gunmode swap
	int scannedX = Integer.MIN_VALUE;
	int scannedY = Integer.MIN_VALUE;	
	
	public void run() {
		setColors(Color.GRAY, Color.WHITE, Color.GRAY);
		out.println("Cymba is initializing."); 
		setAdjustRadarForRobotTurn(true);
  
		do {

	
			if ( getRadarTurnRemaining() == 0.0 )
				setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
			execute();
			setAhead(150 * moveDirection);
			if (Math.random() > .95) {
			out.println("Changing direction");
			moveDirection = moveDirection * -1;	
			}
			if (antiwalltimer < 30) {		
				if (getX() < 100 || getY() < 100 || getX() > getBattleFieldWidth()-100 || getY() > getBattleFieldHeight()-100) {
					setTurnRight(90);
					antiwalltimer = 0;
				}	
			}
			antiwalltimer = antiwalltimer + 1;		
			scan();
   	 }while(true); }
 
	public void onScannedRobot(ScannedRobotEvent e) {
 
 	   // Absolute angle towards target
		double angleToEnemy = getHeadingRadians() + e.getBearingRadians();
 
  	  // Subtract current radar heading to get the turn required to face the enemy, be sure it is normalized
		double radarTurn = Utils.normalRelativeAngle( angleToEnemy - getRadarHeadingRadians() );
 
	    // Distance we want to scan from middle of enemy to either side
 	   // The 36.0 is how many units from the center of the enemy robot it scans.
		double extraTurn = Math.min( Math.atan( 72.0 / e.getDistance() ), Rules.RADAR_TURN_RATE_RADIANS );
 
  	  // Adjust the radar turn so it goes that much further in the direction it is going to turn
 	   // Basically if we were going to turn it left, turn it even more left, if right, turn more right.
 	   // This allows us to overshoot our enemy so that we get a good sweep that will not slip.
		radarTurn += (radarTurn < 0 ? -extraTurn : extraTurn);
 
  	  //Turn the radar
  	  setTurnRadarRightRadians(radarTurn);
	  
 
	  //Linear velocity gun
	  if (guntype == 0){
 	 	 if (Math.random() > 0.5) {
    	    nprand = -1*Math.random();
			} 
		  else {
			nprand = Math.random();
			}
 	  	  double bulletPower = 3;
		  double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		  double linearBearing = headOnBearing + Math.asin(e.getVelocity()/2 / Rules.getBulletSpeed(bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
    	  setTurnGunRightRadians(Utils.normalRelativeAngle(linearBearing - getGunHeadingRadians()) + .05*nprand);
		  if (getGunTurnRemaining() < 10) {
			setFire(600/e.getDistance());
		  }	
	  }
	  
	  //HOT gun
	  if (guntype == 1){
	  	double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(
		robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		setFire(600/e.getDistance());
	  }		

		//Modifies trajectory based on proximity to target.
		if (e.getDistance() < 100) {
			out.println("too close!" + e.getDistance());
			if (moveDirection == 1) {
				turnmodifier = -20;
			}
			if (moveDirection == -1) {
				turnmodifier = 20;
			}			
		}
		if (e.getDistance() > 100) {
			turnmodifier = 0;
		}
		
		setTurnRight(e.getBearing() + 100 + turnmodifier);
			
	
		if (lastenergy != e.getEnergy()){
			if (fliptimer > 30){
				moveDirection = moveDirection * -1;
				fliptimer = 0;	
			}
		}	
 		lastenergy = e.getEnergy();
		fliptimer = fliptimer + 1;
		
		// The coordinates of the last scanned robot

 
     // Calculate the angle to the scanned robot
     double angle = Math.toRadians((getHeading() + e.getBearing()) % 360);
 
     // Calculate the coordinates of the robot
     scannedX = (int)(getX() + Math.sin(angle) * e.getDistance());
     scannedY = (int)(getY() + Math.cos(angle) * e.getDistance());
 		
}


	public void onHitByBullet(HitByBulletEvent e) {

		execute();
	}
	

	public void onHitWall(HitWallEvent e) {
		setTurnRight(e.getBearing() + 90);
		moveDirection = moveDirection * -1;	
		setAhead(150 * moveDirection);
		execute();
	
	}	
	public void onBulletHit (BulletHitEvent e) {
		guntypetimer = 0;
		out.println("Hit! :D");
	}
	public void onBulletMissed (BulletMissedEvent e) {
		guntypetimer = guntypetimer + 1;
		out.println("timer is" + guntypetimer);
		if (guntypetimer == 10){
			if (guntype == 0);
				guntype = 1;
				out.println("Switching to HOT gun.");
				guntypetimer = 0;
			}
		if (guntypetimer == 10){		
				if (guntype == 1){
				guntype = 0;
				out.println("Switching to LV gun.");
				guntypetimer = 0;
			}				
	  		
	}
		
}
 // Paint a transparent square on top of the last scanned robot
 public void onPaint(Graphics2D g) {
     // Set the paint color to a red half transparent color
     g.setColor(new Color(0xff, 0x00, 0x00, 0x80));
 
     // Draw a line from our robot to the scanned robot
     g.drawLine(scannedX, scannedY, (int)getX(), (int)getY());
 
     // Draw a filled square on top of the scanned robot that covers it
     g.fillRect(scannedX - 20, scannedY - 20, 40, 40);
	 
	 g.setColor(new Color(0x00, 0x00, 0xff, 0x80));
     g.drawLine(scannedX, scannedY, (int)getX(), (int)getY());	 
	 }
 }