package romz.model.wave;

import static romz.math.RobotMath.direction;
import static romz.math.RobotMath.distance;
import static romz.math.RobotMath.heading;
import static romz.math.RobotMath.headingAlignment;
import static romz.math.RobotMath.maxEscapeAngle;
import robocode.Bullet;
import robocode.util.Utils;
import romz.model.Situation;
import romz.model.robot.Enemy;
import romz.model.robot.Robot;

public class Wave {

	public double startX;
	public double startY;
	public long startTime;
	public double startEnemyX;
	public double startEnemyY;
	public double startEnemyBearing;
	public double startEnemyDistance;
	public double startEnemyHeading;
	public double startEnemyVelocity;
	public double startEnemyDirection;
	public double startEnemyHeadingAlignment;
	public double startEnemyAngularSpeed;
	public double velocity;
	public double maxEscapeAngle;
	public double hitOffsetAngle;
	
	public Wave(Situation situation, Bullet bullet) {
		startX = situation.hero.x;
		startY = situation.hero.y;
		startEnemyX = situation.enemy.x;
		startEnemyY = situation.enemy.y;
		startTime = situation.time;
		startEnemyBearing = situation.enemy.absoluteBearing;
		startEnemyDistance = situation.enemy.distance;
		startEnemyHeading = situation.enemy.heading;
		startEnemyVelocity = situation.enemy.velocity;
		startEnemyDirection = direction(situation.enemy.heading, situation.enemy.absoluteBearing);
		startEnemyHeadingAlignment = headingAlignment(situation.enemy.heading, situation.enemy.absoluteBearing);
		startEnemyAngularSpeed = situation.enemy.angularSpeed;
		startEnemyDirection = situation.enemy.direction;
		velocity = bullet.getVelocity();
		maxEscapeAngle = maxEscapeAngle(bullet.getPower());
	}
	
	public double getTravelledDistance(long time) {
		return (time - startTime) * velocity;
	}
	
	public boolean overEnemy(long time, Enemy enemy) {
		return getTravelledDistance(time) >= (distance(startX, startY, enemy.x, enemy.y) - Robot.HALF_ROBOT_SIZE);
	}
	
	public void hit(Enemy enemy) {
		double hitAngle = heading(startX, startY, enemy.x, enemy.y);
		hitOffsetAngle = startEnemyDirection * Utils.normalRelativeAngleDegrees(hitAngle - startEnemyBearing);
	}
	
	@Override
	public String toString() {
		return "startX : " + startX + "\n"
			+ "startY : " + startY + "\n"
			+ "startTime : " + startTime + "\n"
			+ "startEnemyX : " + startEnemyX + "\n"
			+ "startEnemyY : " + startEnemyY + "\n"
			+ "startEnemyDirection : " + startEnemyDirection + "\n"
			+ "startEnemyBearing : " + startEnemyBearing + "\n"
			+ "startEnemyHeading : " + startEnemyHeading + "\n"
			+ "startEnemyDistance : " + startEnemyDistance + "\n"
			+ "startEnemyHeadingAlignment : " + startEnemyHeadingAlignment + "\n"
			+ "startEnemyDirection : " + startEnemyDirection + "\n"
			+ "velocity : " + velocity + "\n"
			+ "maxEscapeAngle : " + maxEscapeAngle + "\n"
			+ "hitOffsetAngle : " + hitOffsetAngle;
	}

}
