package mskwik;
import java.util.Vector;

public class Map
{
	private Vector b;
	
	public Map(){
		b=new Vector();
	}
	
	public void insert(MapElement e){
		if(e.getType()==1){b.addElement(e);}else{
			int i=exists(e.getName());
			if(i>-1){b.set(i,e);}else{b.addElement(e);}
		}
	}

	public double update(MapElement e){
		if(e.getType()!=2){insert(e);}else{
			int i=exists(e.getName());
			if(i>-1){
				MapElement o=(MapElement)b.elementAt(i);
				b.set(i,e);
				return (o.getLife()-e.getLife());
			}else{
				b.addElement(e);
			}
		}
		return 0;
	}

	public void remove(String name){
		int i=exists(name);
		if(i>-1){
			b.removeElementAt(i);
			remove(name);	//Check for others
		}
	}

	private int exists(String name){
		MapElement e;
		int ret=-1;
		for(int x=0;x<b.size();x++){
			e=(MapElement)b.elementAt(x);
			if(name.equals(e.getName())){ret=x;}
		}
		return ret;
	}

	public MapElement bestTarget(double bx,double by){
		MapElement x,best=null;
		double bestdist=10000;
		for(int i=b.size()-1;i>=0;i--){
			x=(MapElement)b.elementAt(i);
			if(x.getType()==2 && Math.sqrt(Math.pow(bx-x.getX(),2)+Math.pow(by-x.getY(),2))<bestdist){best=x;bestdist=Math.sqrt(Math.pow(bx-x.getX(),2)+Math.pow(by-x.getY(),2));}
		}
		return best;
	}

	public Point getMove(double x,double y,double width,double height,double heading){
		double cx,cy;
		if(checkSpot(x,y,width,height,295)==1){
			double c=heading+456;
			double movd=70;
			double md=38;
			while(c>heading){
				movd+=11;
				md+=10;
				cx=x+movd*Math.sin(Math.toRadians(c));
				cy=y+movd*Math.cos(Math.toRadians(c));
				if(checkSpot(cx,cy,width,height,md)==0){return new Point(cx,cy);}
				cx=x+movd*Math.sin(Math.toRadians(c+180));
				cy=y+movd*Math.cos(Math.toRadians(c+180));
				if(checkSpot(cx,cy,width,height,md)==0){return new Point(cx,cy);}
				c-=26;
			}
		}
		return null;
	}	

	private int checkSpot(double x,double y,double width,double height,double d){
		MapElement m;
		double dist;
		int move=0;
		for(int i=b.size()-1;i>=0;i--){
			m=(MapElement)b.elementAt(i);
			dist=Math.sqrt(Math.pow(x-m.getX(),2)+Math.pow(y-m.getY(),2));
			if(dist<d){move=1;}
		}
		if(x<30 || y<30 || x>width-30 || y>height-30){return 1;}
		return move;
	}

	public void updateBullets(double width,double height){
		MapElement x;
		for(int i=b.size()-1;i>=0;i--){
			x=(MapElement)b.elementAt(i);
			if(x.getType()==1){
				x.updateBullet();
				if(x.getX()>width || x.getY()>height || x.getX()<0 || x.getY()<0){b.removeElementAt(i);}else{b.set(i,x);}
			}
		}
	}
	
	public int size(){return b.size();}
	
}
