package hirataatsushi;

import robocode.*;
import java.util.*;

/**
 * class RadarSystem - a class by A.Hirata
 *  [_[̓쐧ǂB
 */
class RadarSystem
{
	private static RadarSystem singleton = new RadarSystem();
	
	
	private int radarDirection=1;
	//Helper help = new Helper();
	AdvancedRobot myBot = new AdvancedRobot();
	
	
	
	
	//RXgN^B
	private RadarSystem(){
		System.out.println("RadarSystem : Singleton instance created...");
	}
	
	//^[Qbg}l[W[̃CX^XԂB
	public static RadarSystem getInstance(){
		return singleton;
	}
	
	public void setMyBot(AdvancedRobot bot){
		myBot = bot;
	}	

	public void sweep(Iterator targets){
		double	maxBearingAbs = 0,
				maxBearing = 0;
		int 	scannedBots = 0;
		
		while(targets.hasNext()){
			Enemy tmp = (Enemy)targets.next();
			if ( tmp != null ){
				double bearing = Helper.normalizeBearingRadians( myBot.getHeadingRadians() + tmp.getBearing() - myBot.getRadarHeadingRadians() );
				if (Math.abs(bearing) > maxBearingAbs){
					maxBearingAbs = Math.abs(bearing);
					maxBearing=bearing;
				}
				scannedBots++;
			}
		}
		double radarTurn = Math.PI * radarDirection;
		if (scannedBots == myBot.getOthers())
			radarTurn = maxBearing + Helper.sign(maxBearing) * Math.PI/8;
		
		myBot.setTurnRadarRightRadians(radarTurn);
		radarDirection = (int)Helper.sign(radarTurn);
	}
	
	public void FullTurnScan()
	{
		myBot.setTurnRadarRight(360);//Ƃ肠AS̓XL
	}
}
