/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.IRobot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.Average;
import rdt.Wraith.Stats.Counter;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Stats.RollingAverage;

public abstract class Gun {
    public final RollingAverage RecentHitRate;
    public final Average AllTimeHitRate;
    public final Counter TotalHits;
    public final Counter TotalMisses;
    public final RollingAverage RecentDeltaAngle;
    public final Average AllTimeDeltaAngle;
    protected IRobot _robot;
    protected RobotSnapshots _targetSnapshots;
    private String _name;

    protected Gun(String name, IRobot robot, RobotSnapshots targetSnapshots, IStats stats) {
        this._name = name;
        this._robot = robot;
        this._targetSnapshots = targetSnapshots;
        this.RecentHitRate = new RollingAverage("Guns : " + name + " : Recent Hit Rate", 10, 1.0);
        this.AllTimeHitRate = new Average("Guns : " + name + " : All Time Hit Rate");
        this.TotalHits = new Counter("Guns : " + name + " : Total Hits");
        this.TotalMisses = new Counter("Guns : " + name + " : Total Misses");
        this.RecentDeltaAngle = new RollingAverage("Guns : " + name + " : Recent Delta Angle", 10, 1.0);
        this.AllTimeDeltaAngle = new Average("Guns : " + name + " : All Time Delta Angle");
        stats.RegisterStat(this.RecentHitRate);
        stats.RegisterStat(this.AllTimeHitRate);
        stats.RegisterStat(this.TotalHits);
        stats.RegisterStat(this.TotalMisses);
        stats.RegisterStat(this.RecentDeltaAngle);
        stats.RegisterStat(this.AllTimeDeltaAngle);
    }

    public abstract void GetFiringSolutions(FiringData var1, FiringSolutions var2);

    public void RegisterHit(double deltaAngle) {
        this.RecentHitRate.Record(1.0);
        this.AllTimeHitRate.Record(1.0);
        this.RecentDeltaAngle.Record(deltaAngle);
        this.AllTimeDeltaAngle.Record(deltaAngle);
        this.TotalHits.Increment();
    }

    public void RegisterMiss(double deltaAngle) {
        this.RecentHitRate.Record(0.0);
        this.AllTimeHitRate.Record(0.0);
        this.RecentDeltaAngle.Record(deltaAngle);
        this.AllTimeDeltaAngle.Record(deltaAngle);
        this.TotalMisses.Increment();
    }

    public String toString() {
        return String.format("%s : %d / %d (%.2f, %.2f) (%.2f, %.2f)", this._name, this.TotalHits.Value(), this.TotalHits.Value() + this.TotalMisses.Value(), this.AllTimeHitRate.GetAverage(), this.RecentHitRate.GetAverage(), this.AllTimeDeltaAngle.GetAverage(), this.RecentDeltaAngle.GetAverage());
    }
}

