/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.Bezier;
import DM.mega.BezierCalc;
import DM.mega.BullegonWheels;
import DM.mega.InPlight;
import DM.mega.Polygon2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Wheels {
    static final int PIXELATION = 2;
    static final int LEFT = 0;
    static final int TOP = 1;
    static final int RIGHT = 2;
    static final int BOTTOM = 3;
    static final double HALF_SHADOW = 1.5;
    static final Color[] paints = new Color[]{Color.RED.darker().darker().darker(), Color.BLUE.brighter().brighter(), Color.YELLOW.brighter(), Color.RED.brighter(), Color.MAGENTA, Color.BLUE.brighter(), Color.PINK, Color.CYAN};
    static final BezierCalc myCalculator = new BezierCalc();
    static final int MAX_MAP_SIZE = 160;
    static final int SHRINK_TARGET = 159;
    static final int NUM_NEIGHBORS = 13;
    static final int NUM_SECOND_NEIGHBORS = 11;
    static final int DIST_SEGS = 7;
    static final int VEL_SEGS = 7;
    static final int ACCEL_SEGS = 7;
    static final int NEAR_WALL_SEGS = 7;
    static final int HEAD_SEGS = 7;
    static final int B_POWER_SEGS = 7;
    static final double WALL_DIST_SEG_SIZE = Bezier.MAX_DIST / 7.0;
    static final double B_POWER_SEG_SIZE = 0.42857142857142855;
    static final double POINT_MASS = 1.0;
    static final double BOT_MASS = 1.0;
    static final double ENEMY_BOT_MASS = 26000.0;
    private final AdvancedRobot self;
    private final HashMap<float[], Double> offsetMap;
    private final List<BullegonWheels> shadows;
    private final List<InPlight> waves;
    private final List<Point2D.Double> trackPoints;
    private final List<Point2D.Double> driveOptions;
    private final List<Point2D.Double> futureDrives;
    private final List<float[]> neighbors;
    private final List<float[]> secondNeighbors;
    private final Line2D[] frameLines = new Line2D[4];
    private final Point2D.Double myCenter;
    private final Point2D.Double enemyPos;
    private final Point2D.Double targetPos;
    private final Point2D.Double oldPos;
    private final Point2D.Double myShotCenter;
    private final Path2D.Double raceTrack;
    private InPlight surfWave;
    private InPlight secondWave;
    private double absBearingTo;
    private double eDist;
    private double eOldVelocity;
    private double eOldHealth;
    private double myHeading;
    private double myVelocity;
    private double eDelta;
    private double oldVelocity;
    private double expectedDamage;
    private double freshAbsBearingTo;
    private double freshEDist;
    private double freshMyHeading;
    private double freshMyVelocity;
    private double freshOldVelocity;
    private float distSeg;
    private float velSeg;
    private float accelSeg;
    private float wallSpaceSeg;
    private float revWallSpaceSeg;
    private float headSeg;
    private float bPowerSeg;
    private long timeOfHit;
    private int eSide;
    private int dir;
    private int latDir;
    private int activeID;
    private int secondActiveID;
    private int sneakBullets;
    private int baseIndex;
    private int eHits;
    private int eShots;
    private int eRangeHits;
    private int eRangeShots;
    private int freshESide;
    private boolean isRoundOver;

    public Wheels(AdvancedRobot advancedRobot) {
        this.self = advancedRobot;
        this.raceTrack = Bezier.getEnclosure();
        this.frameLines[0] = new Line2D.Double(0.0, 0.0, 0.0, 36.0);
        this.frameLines[1] = new Line2D.Double(0.0, 36.0, 36.0, 36.0);
        this.frameLines[2] = new Line2D.Double(36.0, 36.0, 36.0, 0.0);
        this.frameLines[3] = new Line2D.Double(36.0, 0.0, 0.0, 0.0);
        this.offsetMap = new HashMap();
        this.shadows = new ArrayList<BullegonWheels>();
        this.waves = new ArrayList<InPlight>();
        this.trackPoints = new ArrayList<Point2D.Double>();
        this.driveOptions = new ArrayList<Point2D.Double>();
        this.futureDrives = new ArrayList<Point2D.Double>();
        this.neighbors = new ArrayList<float[]>();
        this.secondNeighbors = new ArrayList<float[]>();
        this.myCenter = new Point2D.Double(0.0, 0.0);
        this.enemyPos = new Point2D.Double(0.0, 0.0);
        this.targetPos = new Point2D.Double(0.0, 0.0);
        this.oldPos = new Point2D.Double(0.0, 0.0);
        this.myShotCenter = new Point2D.Double(0.0, 0.0);
        this.eOldHealth = 100.0;
        this.dir = 1;
        this.fillTrackSegments();
    }

    public void update(ScannedRobotEvent scannedRobotEvent, List<Bullet> list, double d) {
        if (this.isRoundOver) {
            this.reset();
        }
        this.frameLines[0].setLine(this.myCenter.x - 18.0, this.myCenter.y - 18.0, this.myCenter.x - 18.0, this.myCenter.y + 18.0);
        this.frameLines[1].setLine(this.myCenter.x - 18.0, this.myCenter.y + 18.0, this.myCenter.x + 18.0, this.myCenter.y + 18.0);
        this.frameLines[2].setLine(this.myCenter.x + 18.0, this.myCenter.y + 18.0, this.myCenter.x + 18.0, this.myCenter.y - 18.0);
        this.frameLines[3].setLine(this.myCenter.x + 18.0, this.myCenter.y - 18.0, this.myCenter.x - 18.0, this.myCenter.y - 18.0);
        double d2 = this.eOldHealth - scannedRobotEvent.getEnergy() + this.expectedDamage;
        if (d2 <= 3.0 && d2 > 0.0 && Math.abs(Math.abs(scannedRobotEvent.getVelocity()) - Math.abs(this.eOldVelocity)) <= 2.1) {
            ++this.sneakBullets;
            if (this.expectedDamage <= 0.0) {
                --this.sneakBullets;
            }
            this.eDelta = d2;
            this.bPowerSeg = (float)(this.eDelta / 0.42857142857142855);
            this.waves.add(new InPlight(this.enemyPos.x, this.enemyPos.y, Math.atan2(this.myShotCenter.x - this.enemyPos.x, this.myShotCenter.y - this.enemyPos.y), Rules.getBulletSpeed((double)this.eDelta), this.self.getTime() - 1L, this.latDir, new float[]{this.distSeg, this.velSeg, this.accelSeg, this.wallSpaceSeg, this.revWallSpaceSeg, this.headSeg, this.bPowerSeg}, true, this.enemyPos.distance(this.myCenter) > 375.0));
        }
        this.expectedDamage = 0.0;
        this.myShotCenter.x = this.oldPos.x;
        this.myShotCenter.y = this.oldPos.y;
        this.myCenter.x = this.self.getX();
        this.myCenter.y = this.self.getY();
        this.enemyPos.x = Math.sin(this.absBearingTo) * scannedRobotEvent.getDistance() + this.myCenter.x;
        this.enemyPos.y = Math.cos(this.absBearingTo) * scannedRobotEvent.getDistance() + this.myCenter.y;
        this.absBearingTo = this.freshAbsBearingTo;
        this.myVelocity = this.freshMyVelocity;
        this.eDist = this.freshEDist;
        this.eSide = this.freshESide;
        this.dir = this.myVelocity == 0.0 ? this.dir : this.sign(this.myVelocity);
        this.latDir = this.dir * this.eSide;
        this.myHeading = this.freshMyHeading;
        this.determineSegmentation(scannedRobotEvent.getBearingRadians());
        this.oldPos.x = this.self.getX();
        this.oldPos.y = this.self.getY();
        this.freshAbsBearingTo = d;
        this.freshMyVelocity = this.self.getVelocity();
        this.freshEDist = scannedRobotEvent.getDistance();
        this.freshESide = this.sign(scannedRobotEvent.getBearingRadians());
        this.freshMyHeading = this.self.getHeadingRadians();
        this.getSurfWave();
        this.findHallowedGround(list);
        this.cullBullies();
        this.decideLocation();
        this.driveTo();
        this.eOldHealth = scannedRobotEvent.getEnergy();
        this.oldVelocity = this.freshOldVelocity;
        this.eOldVelocity = scannedRobotEvent.getVelocity();
        this.freshOldVelocity = this.self.getVelocity();
    }

    private void getSurfWave() {
        int n;
        long l = this.self.getTime();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        Iterator<InPlight> iterator = this.waves.iterator();
        this.surfWave = null;
        this.secondWave = null;
        this.secondActiveID = 0;
        double d3 = 0.0;
        while (iterator.hasNext()) {
            InPlight inPlight = iterator.next();
            d3 = inPlight.sourceDist(new Point2D.Double(this.self.getX(), this.self.getY())) / inPlight.velocity - (double)(l - inPlight.fireTime);
            if (d3 < d && d3 > 1.0 && inPlight.isActive() && inPlight.isReal) {
                d = d3;
                this.surfWave = inPlight;
                this.timeOfHit = (long)d3 + l;
            }
            if (d3 < d2 && d3 > d && inPlight.isActive() && inPlight.isReal) {
                d2 = d3;
                this.secondWave = inPlight;
                this.secondActiveID = inPlight.hashCode();
            }
            if (d3 <= 0.9 && inPlight.isActive()) {
                ++this.eShots;
                if (inPlight.isRange) {
                    ++this.eRangeShots;
                }
                inPlight.setInactive();
            }
            if (!(d3 <= -2.0)) continue;
            iterator.remove();
        }
        if (this.surfWave != null && (n = this.surfWave.hashCode()) != this.activeID) {
            this.activeID = n;
            this.establishNeighbors();
        }
    }

    private void establishNeighbors() {
        this.neighbors.clear();
        this.neighbors.addAll(this.offsetMap.keySet().stream().sorted((fArray, fArray2) -> Double.compare(this.myEucishDistBetween((float[])fArray, this.surfWave.key), this.myEucishDistBetween((float[])fArray2, this.surfWave.key))).limit(13L).collect(Collectors.toList()));
        this.secondNeighbors.clear();
        if (this.secondWave != null) {
            this.secondNeighbors.addAll(this.offsetMap.keySet().stream().sorted((fArray, fArray2) -> Double.compare(this.myEucishDistBetween((float[])fArray, this.secondWave.key), this.myEucishDistBetween((float[])fArray2, this.secondWave.key))).limit(11L).collect(Collectors.toList()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decideLocation() {
        var1_1 = this.establishXYBase();
        this.baseIndex = this.trackPoints.indexOf(var1_1);
        this.expand(var1_1, this.myCenter, this.surfWave, this.self.getTime(), this.driveOptions);
        var2_2 = this.getLeastDangerous(var1_1);
        var3_3 = Math.atan2(var2_2.x - this.myCenter.x, var2_2.y - this.myCenter.y);
        var5_4 = this.dist(var2_2.x, var2_2.y, this.myCenter.x, this.myCenter.y);
        var7_5 = Math.abs(Utils.normalRelativeAngle((double)(var3_3 - this.myHeading))) <= 1.5707963267948966 ? 1 : -1;
        var8_6 = (int)(Math.sqrt(4.0 * var5_4 + 1.0) - 1.0);
        var10_7 = this.calcDecelDist(Math.abs(this.myVelocity));
        if ((double)var7_5 * this.myVelocity >= 0.0) ** GOTO lbl-1000
        v0 = (double)var7_5 * this.myVelocity < 0.0 ? 2 * var7_5 : var7_5;
        if (this.limit(0.0, Math.abs(this.myVelocity + (double)v0), 8.0) > var8_6 || var5_4 > var10_7) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        var12_8 = v1;
        var13_9 = Math.min(Math.abs(var12_8 == false ? this.limit(-8.0, this.myVelocity + (double)(2 * var7_5), 8.0) : var5_4), var5_4);
        this.self.setMaxVelocity(Math.min(8.0, var5_4 / Math.max(1.0, (double)(this.timeOfHit - this.self.getTime() - 1L))));
        this.targetPos.x = this.myCenter.x + var13_9 * Math.sin(var3_3);
        this.targetPos.y = this.myCenter.y + var13_9 * Math.cos(var3_3);
    }

    private double calcDecelDist(double d) {
        return 1.5 * d;
    }

    private double calcAccelDist(double d, double d2) {
        return Math.min((8.0 - d2) * (8.0 + d2) / 2.0, Math.max(d - 1.5 * d2, 0.0));
    }

    private double calcAccelMax(double d, double d2) {
        return Math.min(8.0, (d - d2 - 1.0) / (d2 + 1.0) + d2);
    }

    private void driveTo() {
        double d = this.targetPos.distance(this.myCenter);
        double d2 = Utils.normalAbsoluteAngle((double)Math.atan2(this.targetPos.x - this.myCenter.x, this.targetPos.y - this.myCenter.y));
        double d3 = Utils.normalRelativeAngle((double)(d2 - this.self.getHeadingRadians()));
        double d4 = 1.0;
        if (Math.abs(d3) > 1.5707963267948966) {
            d3 = Utils.normalRelativeAngle((double)(Math.PI - d3));
            d4 = -1.0;
        }
        if (d3 < 0.3141592653589793) {
            this.self.setAhead(d * d4);
        }
        double d5 = this.surfWave == null ? this.absBearingTo : Math.atan2(this.surfWave.sourceX() - this.myCenter.x, this.surfWave.sourceY() - this.myCenter.y);
        Point2D.Double double_ = this.trackPoints.get((this.baseIndex + 2) % this.trackPoints.size());
        Point2D.Double double_2 = this.trackPoints.get(this.baseIndex);
        if (Double.compare(d, 1.0) > 0) {
            this.self.setTurnRightRadians(d3 * d4);
        } else {
            this.self.setTurnRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(double_.x - double_2.x, double_.y - double_2.y) + (this.eSide < 0 ? Math.PI : 0.0) - this.myHeading)));
        }
    }

    private void expand(Point2D.Double double_, Point2D.Double double_2, InPlight inPlight, long l, List<Point2D.Double> list) {
        list.clear();
        list.add(double_);
        int n = this.trackPoints.indexOf(double_);
        if (inPlight != null) {
            for (int i = -1; i < 2; i += 2) {
                Point2D.Double double_3;
                double d = l == this.self.getTime() ? Math.abs(this.self.getVelocity()) * (double)i * (double)this.latDir : 0.0;
                int n2 = n + i;
                if (n2 < 0) {
                    n2 += this.trackPoints.size();
                }
                n2 %= this.trackPoints.size();
                Point2D.Double double_4 = new Point2D.Double(double_.x, double_.y);
                long l2 = 0L;
                double d2 = 0.0;
                do {
                    double_3 = this.trackPoints.get(n2);
                    list.add(double_3);
                    double d3 = double_3.distance(double_2);
                    double d4 = Math.max(0.0, d);
                    double d5 = d2 = d3 <= 16.0 ? d3 / ((8.0 + d4) / 2.0) : (d3 - (8.0 + d4) / 2.0 * ((8.0 - d4) / 2.0)) / 8.0;
                    if ((n2 += i) < 0) {
                        n2 += this.trackPoints.size();
                    }
                    n2 %= this.trackPoints.size();
                    d += d < 0.0 ? 2.0 : 1.0;
                    d = Math.min(8.0, d);
                    double_4.x = double_3.x;
                    double_4.y = double_3.y;
                } while (!inPlight.breaks(double_3, l + (long)((int)Math.ceil(d2)) + l2) || !inPlight.checkHit(double_3, l + (long)((int)Math.ceil(d2))));
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private Point2D.Double getLeastDangerous(Point2D.Double double_) {
        long l = this.self.getTime();
        double d = Double.MAX_VALUE;
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        double d2 = 1.0;
        if (this.secondWave != null) {
            d2 = (this.secondWave.velocity - 20.0) / -3.0 / ((this.surfWave.velocity - 20.0) / -3.0);
        }
        if (this.surfWave != null) {
            for (Point2D.Double double_3 : this.driveOptions) {
                Object object;
                double d3 = this.dist(double_3.x, double_3.y, this.surfWave.sourceX(), this.surfWave.sourceY());
                double d4 = 36.0 / d3 / this.surfWave.mEA;
                double d5 = this.surfWave.getOffsetFactor(double_3);
                double d6 = 0.0;
                boolean bl = false;
                for (Object object2 : this.shadows) {
                    if (((BullegonWheels)object2).parent != this.activeID || !((Polygon2D)object2).contains(new Rectangle2D.Double(double_3.x - 1.5, double_3.y - 1.5, 3.0, 3.0))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    object = this.neighbors.iterator();
                    while (object.hasNext()) {
                        Object object2;
                        object2 = (float[])object.next();
                        double d7 = this.offsetMap.get(object2);
                        double d8 = (d5 - d7) / d4;
                        d6 += Math.exp(-0.5 * d8 * d8) / Math.max(1.0E-6, (double)this.myManDistBetween((float[])object2, this.surfWave.key));
                    }
                }
                if (d6 >= d) continue;
                object = new ArrayList();
                double d9 = 0.0;
                double d10 = Double.MAX_VALUE;
                double d11 = 0.0;
                double d12 = 0.0;
                if (this.secondWave != null) {
                    d10 = Double.MAX_VALUE;
                    this.expand(double_3, double_3, this.secondWave, (long)Math.ceil(double_3.distance(this.myCenter) / 8.0) + l, (List<Point2D.Double>)object);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Point2D.Double double_4 = (Point2D.Double)iterator.next();
                        d9 = 0.0;
                        d3 = this.dist(double_4.x, double_4.y, this.secondWave.sourceX(), this.secondWave.sourceY());
                        d4 = 36.0 / d3 / this.secondWave.mEA;
                        d5 = this.secondWave.getOffsetFactor(double_4);
                        for (float[] fArray : this.secondNeighbors) {
                            double d13 = this.offsetMap.get(fArray);
                            double d14 = Utils.normalRelativeAngle((double)(d5 - d13)) / d4;
                            d9 += Math.exp(-0.5 * d14 * d14) / Math.max(1.0E-6, (double)this.myManDistBetween(fArray, this.secondWave.key));
                        }
                        d11 += d9;
                        d10 = Math.min(d10, d9);
                        d12 = Math.max(d12, d9);
                    }
                    d6 += (d11 / (double)(2 * object.size()) + d10 / 2.0) * d2;
                }
                if (!(d6 < d)) continue;
                d = d6;
                double_2.x = double_3.x;
                double_2.y = double_3.y;
                this.futureDrives.clear();
                this.futureDrives.addAll((Collection<Point2D.Double>)object);
            }
        }
        return double_2;
    }

    private Point2D.Double establishXYBase() {
        double d = this.absBearingTo + Math.PI;
        return this.trackPoints.stream().sorted((double_, double_2) -> Double.compare(26000.0 * double_2.distance(this.enemyPos) / Math.max(double_2.distance(this.myCenter), 5.0) + Math.cos(Math.atan2(double_2.x - this.myCenter.x, double_2.y - this.myCenter.y) - d) / this.eDist, 26000.0 * double_.distance(this.enemyPos) / Math.max(double_.distance(this.myCenter), 5.0) + Math.cos(Math.atan2(double_.x - this.myCenter.x, double_2.y - this.myCenter.y) - d) / this.eDist)).findFirst().orElse(this.myCenter);
    }

    private double[] establishXYBaseLegacy() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        if (Bezier.surfTains(this.myCenter)) {
            Line2D.Double double_ = new Line2D.Double(this.myCenter.x, this.myCenter.y, this.myCenter.x - 2.0, this.myCenter.y);
            while (Bezier.isInTrack(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x - (double)(2 * ++n), this.myCenter.y);
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x + 2.0, this.myCenter.y);
            while (Bezier.isInTrack(double_.getBounds()) && n2 < n) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x + (double)(2 * ++n2), this.myCenter.y);
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y + 2.0);
            while (Bezier.isInTrack(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y + (double)(2 * ++n3));
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y - 2.0);
            while (Bezier.isInTrack(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y - (double)(2 * ++n4));
            }
            bl5 = Math.min(n3, n4) < Math.min(n, n2);
            bl4 = n3 <= n4;
            bl3 = !bl4;
            bl2 = n <= n2;
            bl = !bl2;
        } else {
            Line2D.Double double_ = new Line2D.Double(this.myCenter.x, this.myCenter.y, this.myCenter.x - 2.0, this.myCenter.y);
            while (!(bl2 = Bezier.meetsTrack(double_.getBounds())) && !Bezier.isExterior(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x - (double)(2 * ++n), this.myCenter.y);
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x + 2.0, this.myCenter.y);
            while (!(bl = Bezier.meetsTrack(double_.getBounds())) && !Bezier.isExterior(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x + (double)(2 * ++n2), this.myCenter.y);
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y + 2.0);
            while (!(bl4 = Bezier.meetsTrack(double_.getBounds())) && !Bezier.isExterior(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y + (double)(2 * ++n3));
            }
            double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y - 2.0);
            while (!(bl3 = Bezier.meetsTrack(double_.getBounds())) && !Bezier.isExterior(double_.getBounds())) {
                double_.setLine(this.myCenter.x, this.myCenter.y, this.myCenter.x, this.myCenter.y - (double)(2 * ++n4));
            }
            boolean bl6 = bl5 = bl4 || bl3;
        }
        if (bl5) {
            return new double[]{this.myCenter.x, bl4 ? this.myCenter.y + (double)(2 * n3) : (bl3 ? this.myCenter.y - (double)(2 * n4) : this.myCenter.y)};
        }
        return new double[]{bl2 ? this.myCenter.x - (double)(2 * n) : (bl ? this.myCenter.x + (double)(2 * n2) : this.myCenter.x), this.myCenter.y};
    }

    private void findHallowedGround(List<Bullet> list) {
        long l = this.self.getTime();
        for (InPlight inPlight : this.waves) {
            if (!inPlight.isReal) continue;
            double d = inPlight.velocity * (double)(l - inPlight.fireTime);
            Ellipse2D[] ellipse2DArray = new Ellipse2D[]{new Ellipse2D.Double(inPlight.sourceX() - d + 0.0 * inPlight.velocity, inPlight.sourceY() - d + 0.0 * inPlight.velocity, 2.0 * (d - 0.0 * inPlight.velocity), 2.0 * (d - 0.0 * inPlight.velocity)), new Ellipse2D.Double(inPlight.sourceX() - d - 1.049 * inPlight.velocity, inPlight.sourceY() - d - 1.049 * inPlight.velocity, 2.0 * (d + 1.049 * inPlight.velocity), 2.0 * (d + 1.049 * inPlight.velocity))};
            double d2 = inPlight.sourceDist(new Point2D.Double(this.self.getX(), this.self.getY()));
            for (Bullet bullet : list) {
                double[] dArray = new double[4];
                double[] dArray2 = new double[4];
                double[] dArray3 = this.project(bullet.getX(), bullet.getY(), -0.0 * bullet.getVelocity(), bullet.getHeadingRadians());
                dArray[0] = dArray3[0];
                dArray2[0] = dArray3[1];
                double[] dArray4 = this.project(bullet.getX(), bullet.getY(), 1.0 * bullet.getVelocity(), bullet.getHeadingRadians());
                dArray[1] = dArray4[0];
                dArray2[1] = dArray4[1];
                Rectangle2D rectangle2D = new Line2D.Double(dArray[0], dArray2[0], dArray[1], dArray2[1]).getBounds2D();
                if (ellipse2DArray[0].intersects(rectangle2D) || !ellipse2DArray[1].intersects(rectangle2D)) continue;
                double[] dArray5 = this.project(inPlight.sourceX(), inPlight.sourceY(), 1.85 * d2, Math.atan2(dArray[1] - inPlight.sourceX(), dArray2[1] - inPlight.sourceY()));
                dArray[2] = dArray5[0];
                dArray2[2] = dArray5[1];
                double[] dArray6 = this.project(inPlight.sourceX(), inPlight.sourceY(), 1.85 * d2, Math.atan2(dArray[0] - inPlight.sourceX(), dArray2[0] - inPlight.sourceY()));
                dArray[3] = dArray6[0];
                dArray2[3] = dArray6[1];
                this.shadows.add(new BullegonWheels(inPlight.hashCode(), dArray, dArray2));
            }
        }
    }

    private void cullBullies() {
        Iterator<BullegonWheels> iterator = this.shadows.iterator();
        while (iterator.hasNext()) {
            BullegonWheels bullegonWheels = iterator.next();
            if (this.waves.stream().filter(inPlight -> inPlight.hashCode() == bullegonWheels.parent).findAny().isPresent()) continue;
            iterator.remove();
        }
    }

    public void storeBullet(Bullet bullet, boolean bl) {
        ++this.eHits;
        if (!bl) {
            --this.eHits;
        }
        double d = bullet.getHeadingRadians();
        InPlight inPlight = this.getWave(bullet);
        if (inPlight != null) {
            this.storeWave(inPlight, d);
            ++this.eRangeHits;
            if (!bl || !inPlight.isRange) {
                --this.eRangeHits;
            }
            if (bl) {
                System.out.println("hit at: " + inPlight.getOffsetFactor(d));
            }
            inPlight.setInactive();
        } else {
            System.out.println("Lost that curvacious bullet");
        }
    }

    private InPlight getWave(Bullet bullet) {
        long l = this.self.getTime();
        InPlight inPlight = null;
        for (InPlight inPlight2 : this.waves) {
            if (!inPlight2.isReal || !(Math.abs(inPlight2.velocity - bullet.getVelocity()) < 0.1) || !(Math.abs(this.dist(bullet.getX(), bullet.getY(), inPlight2.sourceX(), inPlight2.sourceY()) - inPlight2.velocity * (double)(l - 1L - inPlight2.fireTime)) <= 1.5 * bullet.getVelocity())) continue;
            inPlight = inPlight2;
            break;
        }
        return inPlight;
    }

    private void storeWave(InPlight inPlight, double d) {
        this.offsetMap.put(inPlight.key, inPlight.getOffsetFactor(d));
    }

    public float manDistBetween(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            f += Math.abs(fArray[i + 2] - fArray2[i]);
        }
        return f;
    }

    public float myManDistBetween(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            f += Math.abs(fArray[i] - fArray2[i]);
        }
        return f;
    }

    public float eucishDistBetween(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            f += (fArray[i + 2] - fArray2[i]) * (fArray[i + 2] - fArray2[i]);
        }
        return f;
    }

    public float myEucishDistBetween(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray2.length; ++i) {
            f += (fArray[i] - fArray2[i]) * (fArray[i] - fArray2[i]);
        }
        return f;
    }

    private double[] project(double d, double d2, double d3, double d4) {
        return new double[]{d + d3 * Math.sin(d4), d2 + d3 * Math.cos(d4)};
    }

    private int sign(double d) {
        return d < 0.0 ? -1 : 1;
    }

    private double limit(double d, double d2, double d3) {
        return Math.max(Math.min(d, d3), Math.min(d2, Math.max(d, d3)));
    }

    private double dist(double d, double d2, double d3, double d4) {
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    private double toDeg(double d) {
        return 180.0 * d / Math.PI;
    }

    private void determineSegmentation(double d) {
        this.distSeg = (float)(this.eDist / WALL_DIST_SEG_SIZE);
        this.velSeg = (float)(Math.abs(this.myVelocity) / 1.157142857142857);
        this.accelSeg = Double.compare(Math.abs(this.myVelocity), Math.abs(this.oldVelocity));
        this.headSeg = (float)(Math.abs(1.5707963267948966 - Math.abs(d)) / 1.5707963267948966 * 7.0);
        double d2 = this.self.getVelocity() < 0.0 ? Math.PI + this.self.getHeadingRadians() : this.self.getHeadingRadians();
        double d3 = Utils.normalAbsoluteAngle((double)d2) < Math.PI ? (this.self.getBattleFieldWidth() - this.myCenter.x) / Math.cos(1.5707963267948966 - d2) : this.self.getX() / Math.cos(4.71238898038469 - d2);
        double d4 = Math.abs(Utils.normalRelativeAngle((double)d2)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.self.getY()) / Math.cos(d2) : this.self.getY() / Math.cos(Math.PI - d2);
        this.wallSpaceSeg = (float)Math.min(7.0, Math.max(0.0, Math.min(d3, d4) / WALL_DIST_SEG_SIZE));
        d2 = Utils.normalRelativeAngle((double)(d2 + Math.PI));
        d3 = Utils.normalAbsoluteAngle((double)d2) < Math.PI ? (this.self.getBattleFieldWidth() - this.self.getX()) / Math.cos(1.5707963267948966 - d2) : this.self.getX() / Math.cos(4.71238898038469 - d2);
        d4 = Math.abs(Utils.normalRelativeAngle((double)d2)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.self.getY()) / Math.cos(d2) : this.self.getY() / Math.cos(Math.PI - Utils.normalAbsoluteAngle((double)d2));
        this.revWallSpaceSeg = (float)Math.min(7.0, Math.max(0.0, Math.min(d3, d4) / WALL_DIST_SEG_SIZE));
    }

    public void fillTrackSegments() {
        double[] dArray = new double[6];
        PathIterator pathIterator = this.raceTrack.getPathIterator(new AffineTransform(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0}));
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (!pathIterator.isDone()) {
            double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
            int n3 = pathIterator.currentSegment(dArray);
            switch (n3) {
                case 4: {
                    break;
                }
                case 3: {
                    double d;
                    for (d = 0.0; d < 1.0; d += 0.007399999815000001) {
                        myCalculator.setPath(dArray2[0], dArray2[1], dArray);
                        double[] dArray3 = myCalculator.calc(d);
                        this.trackPoints.add(new Point2D.Double(dArray3[0], dArray3[1]));
                    }
                    ++n2;
                    bl = false;
                    break;
                }
                case 1: {
                    double d;
                    if (bl || !((d = this.dist(dArray[0], dArray[1], dArray2[4], dArray2[5])) > 1.0)) break;
                    double d2 = Math.atan2(dArray[0] - dArray2[4], dArray[1] - dArray2[5]);
                    for (double d3 = 0.0; d3 < 1.0; d3 += 3.0 / d) {
                        this.trackPoints.add(new Point2D.Double(dArray2[4] + Math.sin(d2) * d3 * d, dArray2[5] + Math.cos(d2) * d3 * d));
                    }
                    break;
                }
                case 0: {
                    bl = true;
                    break;
                }
            }
            ++n;
            pathIterator.next();
        }
    }

    public void endRound() {
        this.isRoundOver = true;
    }

    public void expectDamage(double d) {
        this.expectedDamage += d;
    }

    private void reset() {
        this.waves.clear();
        this.driveOptions.clear();
        this.shadows.clear();
        this.futureDrives.clear();
        if (this.offsetMap.size() > 160) {
            List list = this.offsetMap.keySet().stream().limit(this.offsetMap.size() - 159).collect(Collectors.toList());
            System.out.println("Clearing " + list.size() + " surf datums");
            for (float[] fArray : list) {
                this.offsetMap.remove(fArray);
            }
        }
        System.out.println("Real enemy acc (idgafwyt): %" + (double)Math.round((double)this.eHits / Math.max(1.0, (double)this.eShots) * 10000.0) / 100.0);
        System.out.println("Real enemy range accuracy: %" + (double)Math.round((double)this.eRangeHits / Math.max(1.0, (double)this.eRangeShots) * 10000.0) / 100.0);
        System.out.println("Enemy has tried to sneak " + this.sneakBullets + " bullets past");
        this.isRoundOver = false;
    }

    public void onPaint(Graphics2D graphics2D) {
        int n = 0;
        for (Point2D.Double double_ : this.trackPoints) {
            if (this.driveOptions.contains(double_)) {
                graphics2D.setColor(Color.GREEN.brighter().brighter());
            } else if (this.futureDrives.contains(double_)) {
                graphics2D.setColor(Color.CYAN.brighter());
            } else {
                graphics2D.setColor(paints[n % paints.length]);
            }
            if (double_.equals(this.targetPos)) {
                graphics2D.draw(new Ellipse2D.Double(double_.x - 4.0, double_.y - 4.0, 8.0, 8.0));
            } else {
                graphics2D.fill(new Ellipse2D.Double(double_.x - 1.25, double_.y - 1.25, 2.5, 2.5));
            }
            ++n;
        }
        long l = this.self.getTime();
        for (InPlight object : this.waves) {
            if (object.hashCode() == this.activeID) {
                graphics2D.setColor(Color.CYAN.darker().darker().darker());
            } else if (object.hashCode() == this.secondActiveID) {
                graphics2D.setColor(Color.ORANGE);
            } else {
                graphics2D.setColor(Color.PINK.darker().darker().darker().darker().darker().darker());
            }
            graphics2D.draw(object.setRefTime(l));
            double[] dArray = object.project(object.groundHeading, l);
            graphics2D.draw(new Line2D.Double(object.sourceX(), object.sourceY(), dArray[0], dArray[1]));
        }
        for (BullegonWheels bullegonWheels : this.shadows) {
            if (bullegonWheels.parent == this.activeID) {
                graphics2D.setColor(Color.MAGENTA);
            } else {
                graphics2D.setColor(Color.GREEN.darker());
            }
            graphics2D.draw(bullegonWheels);
        }
    }
}

