/*
 * Decompiled with CFR 0.152.
 */
package ultra.strategies.guns;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import ultra.core.BotDump;
import ultra.core.LogEntry;
import ultra.core.UltraLogManager;
import ultra.core.Utils;
import ultra.strategies.guns.AbstractGun;

public class KiTIGun
extends AbstractGun {
    private static KiTIGun instance = new KiTIGun();

    public static KiTIGun getInstance() {
        return instance;
    }

    @Override
    protected Point2D.Double doPrediction(BotDump r, UltraLogManager log, double firePower) {
        int ticks = 0;
        double bulletDist = 0.0;
        LogEntry lastLocation = log.getLatest();
        double targetDist = Utils.getDistanceTo(r, lastLocation);
        Rectangle2D.Double arena = r.getArena();
        double battleFieldHeight = arena.height;
        double battleFieldWidth = arena.width;
        Point2D.Double prediction = null;
        while (bulletDist <= targetDist) {
            prediction = (Point2D.Double)lastLocation.clone();
            double heading = log.getLatest().heading;
            double velocity = log.getLatest().velocity;
            int i = 0;
            while (i < Math.min(ticks, log.size() - 1)) {
                LogEntry ti = log.reverseGet(i);
                LogEntry ti1 = log.reverseGet(i + 1);
                velocity = ti1.velocity;
                prediction = Utils.getPosition(prediction, heading += ti.heading - ti1.heading, Utils.fixVelocity(velocity));
                ++i;
            }
            if (!arena.contains(prediction)) {
                prediction.setLocation(Math.min(Math.max(18.0, prediction.x), battleFieldWidth - 18.0), Math.min(Math.max(18.0, prediction.y), battleFieldHeight - 18.0));
                break;
            }
            targetDist = Utils.getDistanceTo(r, prediction);
            bulletDist = (double)ticks * (20.0 - 3.0 * firePower);
            ++ticks;
        }
        return prediction;
    }

    @Override
    public String getName() {
        return "KiTI Gun";
    }
}

