/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.StatisticBullet;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.strategy.analysis.HitAngleStatistic;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.LapUtils;
import alk.lap.utils.RollingHistory;
import java.awt.Color;
import java.util.Iterator;
import java.util.TreeSet;

public class StatBearingTargeting
implements TargetStrategy {
    private static final double BEAM_ANGLE = 5.0;
    public static final String NAME = "StatBearingT";
    private double fireEnergy = 3.0;
    private static final double ANGLE_INTERVAL_FOR_MAXCOUNT_DEFAULT = 1.0;
    public static final double THRESHOLD_TO_AVOID = 0.8;
    private StatisticBullet.BulletType type = StatisticBullet.BulletType.WAVE;
    private static final int MAX_RESP_ANGLES = 2;
    private double angleInterval = 1.0;
    LoudAndProud proud;
    private String name = "StatBearingT";
    private MaxSearchDir maxSearchDir = MaxSearchDir.IGNORE;

    public StatBearingTargeting() {
    }

    public StatBearingTargeting(StatisticBullet.BulletType type) {
        this.type = type;
        this.name = type == StatisticBullet.BulletType.WAVE ? NAME : "StatB-ConT";
    }

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.Heuristic;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        double angle = 0.0;
        TacticalLead tLead = this.proud.getTacticLead();
        AnalystsDatabase db = this.proud.getStrategicLead().getAnalystsDB();
        if (target == 1) {
            int startIndexOf;
            if (!tLead.isEnemySpotted()) {
                return new double[0];
            }
            TreeSet<AnalystsDatabase.StatMax> anglesToAvoid = new TreeSet<AnalystsDatabase.StatMax>();
            RollingHistory<HitAngleStatistic> stat = this.type == StatisticBullet.BulletType.WAVE ? db.proudHitAngleStat : db.proudContinousHitAngleStat;
            AnalystsDatabase.StatMax max = db.getBestAngleto(stat, 0.0);
            if (max.score < 3.0) {
                return new double[0];
            }
            int threshold = max.score == 0.0 ? 1 : (int)(max.score * 0.8);
            double respectedAngle = 60.0;
            int i = startIndexOf = (int)(180.0 - respectedAngle) / 3;
            while (i < 120 - startIndexOf) {
                double angleScore = db.getAngleScore(HitAngleStatistic.angleOf(i), stat, 0.0);
                if (angleScore >= (double)threshold) {
                    anglesToAvoid.add(new AnalystsDatabase.StatMax(HitAngleStatistic.angleOf(i), angleScore));
                }
                ++i;
            }
            int maxCount = Math.min(2, anglesToAvoid.size());
            double[] angleArr = new double[maxCount];
            Iterator iter = anglesToAvoid.iterator();
            int j = 0;
            while (j < angleArr.length) {
                angleArr[j] = ((AnalystsDatabase.StatMax)iter.next()).value + tLead.getEnemyBearing() + 180.0;
                ++j;
            }
            return angleArr;
        }
        if (!tLead.isEnemySpotted()) {
            return LapUtils.toDArray(this.proud.getRadarHeading());
        }
        double enemyHeading = 0.0;
        if (this.maxSearchDir != MaxSearchDir.IGNORE) {
            double absoluteHeading = LoudAndProud.normalRelativeAngle(tLead.getEnemyHeading() + (double)(this.proud.getStrategicLead().getAnalystsDB().getScanBase().getCurrentEnemyMove().signV > 0.0 ? 0 : 180));
            enemyHeading = LoudAndProud.normalRelativeAngle(absoluteHeading - tLead.getEnemyBearing());
            this.proud.getVc().drawDirection(this.proud.getPosition(), enemyHeading, "e-Heading=" + this.proud.printDouble(enemyHeading));
            if (this.maxSearchDir == MaxSearchDir.INV_HEAD) {
                enemyHeading = -enemyHeading;
            }
        }
        double distance = tLead.getEnemyDistance();
        angle = tLead.getEnemyBearing() + (this.type == StatisticBullet.BulletType.WAVE ? db.getBestAngleOnSide(db.getEnemyHitAngleStat((double)distance), (double)enemyHeading, (double)this.angleInterval).value : db.getBestAngleOnSide(db.getEnemyContHitAngleStat((double)distance), (double)enemyHeading, (double)this.angleInterval).value);
        return LapUtils.toDArray(angle);
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 5.0;
    }

    public StatBearingTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public StatBearingTargeting setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        return this;
    }

    public Color getColorCode() {
        return Color.lightGray;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }

    public StatBearingTargeting setAngleInterval(double angleInterval) {
        this.angleInterval = angleInterval;
        this.setName(String.valueOf(this.describe()) + "-a" + LoudAndProud.printStaticDouble(angleInterval));
        return this;
    }

    public StatBearingTargeting setType(StatisticBullet.BulletType type) {
        this.type = type;
        this.setName(String.valueOf(this.describe()) + "-" + (Object)((Object)type));
        return this;
    }

    public StatBearingTargeting setSearchHead() {
        this.maxSearchDir = MaxSearchDir.HEAD;
        this.setName(String.valueOf(this.describe()) + "-dir" + (Object)((Object)this.maxSearchDir));
        return this;
    }

    public StatBearingTargeting setSearchInvHead() {
        this.maxSearchDir = MaxSearchDir.INV_HEAD;
        this.setName(String.valueOf(this.describe()) + "-dir" + (Object)((Object)this.maxSearchDir));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MaxSearchDir {
        HEAD,
        IGNORE,
        INV_HEAD;

    }
}

