/*
 * Decompiled with CFR 0.152.
 */
package cf.OPs;

import cf.Guns.PMGun;
import cf.util.Calc;
import cf.util.Gun;
import cf.util.Operator;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class DisponserS_OP
implements Operator {
    static double e_head;
    static double e_absBear;
    static double e_speed;
    static double e_energy;
    static double e_dist;
    static double e_x;
    static double e_y;
    static double scanDir;
    static double scanAngle;
    String e_name;
    AdvancedRobot bot;
    boolean moving;
    boolean firing;
    boolean dodging;
    Gun gun;

    public DisponserS_OP(AdvancedRobot bot, boolean dodging, boolean firing, boolean moving) {
        this.bot = bot;
        this.moving = moving;
        this.firing = firing;
        this.dodging = dodging;
        if (bot.getOthers() > 1) {
            throw new NullPointerException("Just 1v1 mode");
        }
        bot.setAdjustRadarForGunTurn(true);
        bot.setAdjustRadarForRobotTurn(true);
        bot.setAdjustGunForRobotTurn(true);
        bot.setColors(new Color(60, 60, 60), Color.yellow, Color.green);
        bot.setTurnRadarRight(360.0);
        this.gun = new PMGun(bot);
    }

    public void work() {
        if (this.bot.getRadarTurnRemaining() < 0.1) {
            this.doScan();
        }
        if (this.bot.getGunHeat() / this.bot.getGunCoolingRate() <= 3.0 && this.bot.getGunTurnRemaining() <= 1.0) {
            this.doFireGun();
        }
        scanAngle += 10.0;
        this.bot.execute();
    }

    public boolean out(double angle, double c) {
        double gy;
        double gx;
        double x = this.bot.getX();
        double y = this.bot.getY();
        Rectangle2D.Double r = new Rectangle2D.Double(20.0, 20.0, this.bot.getBattleFieldWidth() - 40.0, this.bot.getBattleFieldHeight() - 40.0);
        return !r.contains(gx = x + c * Math.sin(Math.toRadians(angle)), gy = y + c * Math.cos(Math.toRadians(angle)));
    }

    public void doScan() {
        if (e_absBear == -360.0) {
            this.bot.setTurnRadarRight(90.0);
        }
        this.bot.setTurnRadarRight(this.normalRelativeAngle(e_absBear + scanDir * scanAngle - this.bot.getRadarHeading()));
        scanDir *= -1.0;
    }

    public void doDodge(double bulletPower) {
        if (!this.dodging) {
            return;
        }
        if (!(bulletPower > 2.8) && !(this.bot.getDistanceRemaining() < 1.0)) {
            return;
        }
        this.bot.setMaxVelocity(Math.random() * 20.0 + 4.0);
        double dodgeAngle = Math.random() * 90.0 - 45.0;
        double dist = Math.random() * 300.0 + 40.0;
        if (Math.random() < 0.5) {
            dist *= -1.0;
        }
        if (this.out(dodgeAngle + this.bot.getHeading(), dist)) {
            this.doDodge(bulletPower);
            return;
        }
        this.bot.setTurnRight(dodgeAngle);
        this.bot.setAhead(dist);
    }

    public void doFireGun() {
        this.gun.shoot();
    }

    public void doFire() {
        if (!this.firing) {
            return;
        }
        double maxBearDiff = e_dist / 20.0;
        double zufallAngle = Math.random() * (maxBearDiff * 2.0) - maxBearDiff;
        this.bot.setTurnGunRight(this.normalRelativeAngle(e_absBear - this.bot.getGunHeading() + zufallAngle));
        double power = 650.0 / e_dist;
        double killPower = Calc.getKillPower(e_energy);
        if (killPower < power) {
            power = killPower;
        }
        if (this.bot.getEnergy() - power >= 0.1) {
            this.bot.setFire(power);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.gun.onScannedRobot(e);
        scanAngle = 10.0;
        this.e_name = e.getName();
        e_absBear = e.getBearing() + this.bot.getHeading();
        e_dist = e.getDistance();
        e_x = this.bot.getX() + e_dist * Math.sin(Math.toRadians(e_absBear));
        e_y = this.bot.getY() + e_dist * Math.cos(Math.toRadians(e_absBear));
        e_speed = e.getVelocity();
        e_head = e.getHeading();
        double energyDiff = e_energy - e.getEnergy();
        if (energyDiff > 0.0 && energyDiff <= 3.0) {
            this.doDodge(energyDiff);
        }
        e_energy = e.getEnergy();
        if (this.bot.getTurnRemaining() == 0.0) {
            this.bot.setTurnRight(this.normalRelativeAngle(e_absBear - this.bot.getHeading() + 90.0));
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        e_energy = e.getEnergy();
    }

    public void onWin(WinEvent e) {
        this.firing = false;
        this.gun.end();
    }

    public double normalRelativeAngle(double angle) {
        return Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(angle)));
    }

    public void end() {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onDeath(DeathEvent e) {
        this.gun.end();
    }

    public void onHitWall(HitWallEvent e) {
    }

    static {
        e_absBear = -360.0;
        e_energy = 100.0;
        scanDir = 1.0;
        scanAngle = 10.0;
    }
}

