/*
 * Decompiled with CFR 0.152.
 */
package dk.fire;

import dk.Base;
import dk.Enemy;
import dk.Point;
import dk.Util;
import dk.fire.Fire;

public class Direct
extends Fire {
    protected static final int AIM_NONE = 0;
    protected static final int AIM_MOVE = 1;
    protected int aimMode = 0;

    public void setAim(Base robot) {
        double power;
        if (this.target_ == null) {
            this.aimMode = 0;
        }
        boolean fire = false;
        switch (this.aimMode) {
            case 0: {
                break;
            }
            case 1: {
                power = this.getGunPower(robot, this.target_);
                double angle = this.getGunTurnAngleToEnemy(robot, this.target_, power);
                if (angle < 0.0) {
                    robot.setTurnGunLeftRadians(-angle);
                } else {
                    robot.setTurnGunRightRadians(angle);
                }
                double range = Util.range(robot.getPosition(), this.target_.getEstimatedPosition(robot.getTime()));
                double missDistance = Math.sin(Math.abs(angle)) * range;
                if (!(missDistance <= 18.0)) break;
                fire = true;
            }
        }
        if (fire && robot.getGunHeat() == 0.0 && (power = this.getGunPower(robot, this.target_)) > 0.0) {
            this.setFire(robot, power);
        }
    }

    public void setTarget(Enemy target) {
        super.setTarget(target);
        if (target != null && this.aimMode == 0) {
            this.aimMode = 1;
        }
    }

    public double getGunPower(Base robot, Enemy target) {
        if (robot.getTime() - target.getLastSeen() > (long)robot.config.FIRE_MAX_SCAN_AGE) {
            return 0.0;
        }
        Point enemyEstimatedPosition = target.getEstimatedPosition(robot.getTime());
        if (enemyEstimatedPosition == null) {
            return 0.0;
        }
        double estimatedDistance = Util.range(robot.getPosition(), enemyEstimatedPosition);
        if (estimatedDistance > robot.config.FIRE_RANGE_MAX) {
            return 0.0;
        }
        if (this.predictorBucket != null && target == this.target_) {
            double chance = Math.max(0.0, this.predictorBucket.getSuccessRate() - this.predictorBucket.getConfidence());
            if (chance < 0.2) {
                return 1.0;
            }
            if (chance > 0.8) {
                return 3.0;
            }
            if (chance > 0.5) {
                return 2.0;
            }
        }
        if (estimatedDistance < robot.config.FIRE_RANGE_SHORT) {
            return 3.0;
        }
        if (robot.getEnergy() < 1.0) {
            return 0.0;
        }
        if (robot.getEnergy() < robot.config.FIRE_ENERGY_LOW) {
            return 1.0;
        }
        if (estimatedDistance > robot.config.FIRE_RANGE_LONG) {
            return 1.0;
        }
        return 2.0;
    }
}

