/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.EFDUtils;
import EFD.GunWave;
import EFD.Statistics;
import EFD.TurnAngle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GFGun {
    private AdvancedEFD r;
    static final double MISSED_BULLET_WEIGHT = -0.05;
    static final double MISSED_BULLET_VARIANCE = 0.6;
    static final double HIT_BULLET_WEIGHT = 1.0;
    static final double HIT_BULLET_VARIANCE = 0.3;
    static final double ENEMY_POSITION_WEIGHT = 1.0;
    static final double ENEMY_POSITION_VARIANCE = 1.0;
    static final int BINS = 51;
    private long fireTime = 0L;

    public GFGun(AdvancedEFD r) {
        this.r = r;
    }

    public void aim(ScannedRobotEvent e, double power) {
        double turnAngle = this.getAimingAngle(e, power);
        double gunAdjust = Utils.normalRelativeAngle((double)(turnAngle - this.r.getGunHeadingRadians()));
        this.r.setTurnGunRightRadians(gunAdjust);
    }

    public void tryToFire(ScannedRobotEvent e, double power) {
        Bullet bullet;
        if (this.fireTime == this.r.getTime() && this.r.getGunTurnRemaining() <= 10.0 && (bullet = this.r.setFireBullet(power)) != null) {
            double[] dataPoint = this.r.statistics.createTargetingDatapoint(power);
            this.r.statistics.gunWaves.add(new GunWave(bullet, this.r.getTime(), this.r.absBearing, dataPoint));
            ++Statistics.bulletsShot;
        }
        this.fireTime = this.r.getTime() + 1L;
    }

    public double getAimingAngle(ScannedRobotEvent e, double bulletPower) {
        int index;
        if (Statistics.gunLog.isEmpty()) {
            return this.r.absBearing;
        }
        double bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
        double[] currentData = this.r.statistics.createTargetingDatapoint(bulletPower);
        double[] hitEstimates = new double[51];
        int numNeighbors = (int)EFDUtils.limit(0.0, Math.sqrt(Statistics.gunLog.size()), 15.0);
        double[][] nearestNeighbors = this.r.statistics.nearestNeighbors(Statistics.gunLog, currentData, numNeighbors, 10, Statistics.targetingWeights);
        int i = 0;
        while (i < nearestNeighbors.length) {
            GunWave gunWave = Statistics.gunLogToWave.get(nearestNeighbors[i]);
            index = EFDUtils.getFactorIndex(gunWave.getAngleOffset(), bulletSpeed, 51);
            int x = 0;
            while (x < 51) {
                int n = x;
                hitEstimates[n] = hitEstimates[n] + 0.1 / (Math.pow(index - x, 2.0) + 1.0);
                ++x;
            }
            ++i;
        }
        Graphics2D g = this.r.getGraphics();
        Point2D.Double[] leftEscapePath = this.predictPositions(bulletPower, 1, e.getVelocity(), e.getHeadingRadians(), this.r.statistics.log.get((int)0).enemyPosition);
        Point2D.Double[] rightEscapePath = this.predictPositions(bulletPower, -1, e.getVelocity(), e.getHeadingRadians(), this.r.statistics.log.get((int)0).enemyPosition);
        double bestAngle = EFDUtils.absoluteAngle(this.r.position, leftEscapePath[0]);
        Point2D.Double bestPoint = leftEscapePath[0];
        double maxHitValue = hitEstimates[25];
        Point2D.Double enemyPosition = null;
        int i2 = 0;
        while (i2 < leftEscapePath.length) {
            enemyPosition = leftEscapePath[i2];
            if (enemyPosition != null) {
                index = EFDUtils.getFactorIndex(this.r.absBearing, EFDUtils.absoluteAngle(this.r.position, enemyPosition), bulletSpeed, 51);
                if (hitEstimates[index] > maxHitValue) {
                    maxHitValue = hitEstimates[index];
                    bestAngle = EFDUtils.absoluteAngle(this.r.position, enemyPosition);
                    bestPoint = enemyPosition;
                }
                EFDUtils.drawDot(g, enemyPosition, Color.getHSBColor((float)hitEstimates[index], 1.0f, 1.0f));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < rightEscapePath.length) {
            enemyPosition = rightEscapePath[i2];
            if (enemyPosition != null) {
                index = EFDUtils.getFactorIndex(this.r.absBearing, EFDUtils.absoluteAngle(this.r.position, enemyPosition), bulletSpeed, 51);
                if (hitEstimates[index] > maxHitValue) {
                    maxHitValue = hitEstimates[index];
                    bestAngle = EFDUtils.absoluteAngle(this.r.position, enemyPosition);
                    bestPoint = enemyPosition;
                }
                EFDUtils.drawDot(g, enemyPosition, Color.getHSBColor((float)hitEstimates[index], 1.0f, 1.0f));
            }
            ++i2;
        }
        g.setColor(Color.magenta);
        Point2D.Double aim = EFDUtils.projectPoint(this.r.position, bestAngle, 1000.0);
        g.fillOval((int)bestPoint.x - 3, (int)bestPoint.y - 3, 7, 7);
        g.drawLine((int)this.r.position.x, (int)this.r.position.y, (int)aim.x, (int)aim.y);
        return bestAngle;
    }

    public Point2D.Double[] predictPositions(double power, int direction, double eVelocity, double eHeading, Point2D.Double ePosition) {
        double predictedVelocity = eVelocity;
        double predictedHeading = eHeading;
        double surfingRadius = ePosition.distance(this.r.position);
        double bulletSpeed = Rules.getBulletSpeed((double)power);
        int steps = (int)Math.ceil(surfingRadius / bulletSpeed);
        Point2D.Double[] enemyPath = new Point2D.Double[steps + 1];
        if (steps < 1) {
            return enemyPath;
        }
        enemyPath[0] = (Point2D.Double)ePosition.clone();
        int counter = 0;
        boolean intercepted = false;
        while (!intercepted && counter < steps) {
            double angle = this.r.mov.getOrbitAngle(enemyPath[counter], this.r.position, surfingRadius, direction);
            TurnAngle turnAngle = EFDUtils.turnToAngle(angle, predictedHeading);
            predictedHeading = turnAngle.direction > 0 ? (predictedHeading -= turnAngle.turnAngle) : (predictedHeading += turnAngle.turnAngle);
            if (predictedHeading > Math.PI * 2) {
                predictedHeading -= Math.PI * 2;
            }
            predictedVelocity = predictedVelocity > 0.0 ? (turnAngle.reverse ? (predictedVelocity -= 2.0) : (predictedVelocity += 1.0)) : (turnAngle.reverse ? (predictedVelocity -= 1.0) : (predictedVelocity += 2.0));
            predictedVelocity = EFDUtils.limit(-8.0, predictedVelocity, 8.0);
            enemyPath[counter + 1] = turnAngle.reverse ? EFDUtils.projectPoint(enemyPath[counter], predictedHeading + Math.PI, Math.abs(predictedVelocity)) : EFDUtils.projectPoint(enemyPath[counter], predictedHeading, Math.abs(predictedVelocity));
            if (enemyPath[counter + 1].distance(this.r.position) < (double)counter * bulletSpeed) {
                intercepted = true;
            }
            ++counter;
        }
        int i = counter + 1;
        while (i < enemyPath.length) {
            enemyPath[i] = null;
            ++i;
        }
        return enemyPath;
    }

    public double evalBulletPower(double distance) {
        double bulletPower = 3.0 - 1.1 / (1.0 + Math.exp(-(distance - 220.0) / 40.0));
        if (this.r.statistics.log.get((int)0).energy < 25.0 && distance > 150.0) {
            bulletPower = Math.min(bulletPower, bulletPower - Math.sqrt((25.0 - this.r.statistics.log.get((int)0).energy) / 5.0));
        }
        bulletPower = Math.min(bulletPower, this.r.statistics.log.get((int)0).enemyEnergy / 4.0);
        bulletPower = Math.min(bulletPower, this.r.statistics.log.get((int)0).energy);
        bulletPower = Math.max(bulletPower, 0.1);
        return bulletPower;
    }
}

