/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.EFDUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class MovementWave {
    public Point2D.Double origin;
    public double fireTime;
    public double bulletPower;
    public double distanceTraveled;
    public int direction;
    public double bearingOnFired;
    public double[] data;
    public double bearingOnHit;
    public double offsetAngle;
    public boolean hasPassed = false;
    public boolean onTarget;

    public MovementWave(ScannedRobotEvent e, double bulletPower, AdvancedEFD r, double[] data) {
        this.data = data;
        this.fireTime = r.getTime() - 1L;
        this.bulletPower = bulletPower;
        this.distanceTraveled = Rules.getBulletSpeed((double)bulletPower);
        this.direction = (int)r.statistics.log.get(2).getDirection();
        this.bearingOnFired = r.statistics.log.get(2).getAbsBearing() + Math.PI;
        this.origin = r.statistics.log.get((int)1).enemyPosition;
    }

    public void update(long currentTime) {
        this.distanceTraveled = ((double)currentTime - this.fireTime) * this.getBulletSpeed();
    }

    public boolean hasPassed(Point2D.Double position) {
        if (this.origin.distance(position) + 30.0 <= this.distanceTraveled) {
            this.hasPassed = true;
            return true;
        }
        return false;
    }

    public double getBulletSpeed() {
        return Rules.getBulletSpeed((double)this.bulletPower);
    }

    public double distance(Point2D.Double p) {
        return Math.abs(p.distance(this.origin) - this.distanceTraveled);
    }

    public void paint(Graphics g, Color c, long currentTime) {
        Color oldColor = g.getColor();
        g.setColor(c);
        g.drawOval((int)(this.origin.x - this.distanceTraveled), (int)(this.origin.y - this.distanceTraveled), (int)this.distanceTraveled * 2, (int)this.distanceTraveled * 2);
        g.setColor(oldColor);
    }

    public void miss(Point2D.Double position) {
        this.bearingOnHit = EFDUtils.absoluteAngle(this.origin, position);
        this.offsetAngle = EFDUtils.normaliseAngle(this.bearingOnHit - this.bearingOnFired);
        this.hasPassed = true;
        this.onTarget = false;
    }

    public void hit(Point2D.Double position) {
        this.bearingOnHit = EFDUtils.absoluteAngle(this.origin, position);
        this.offsetAngle = EFDUtils.normaliseAngle(this.bearingOnHit - this.bearingOnFired);
        this.hasPassed = true;
        this.onTarget = true;
    }
}

