/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public abstract class MovementMethodFieldBase
extends MovementMethodBase {
    protected final double alwaysOnRange;
    protected final double alwaysOnPower;
    protected final double fieldMagnitude;

    public MovementMethodFieldBase(int newPersistenceId, double newFieldMagnitude, double newAlwaysOnRange, double newAlwaysOnPower) {
        super(newPersistenceId);
        this.alwaysOnRange = newAlwaysOnRange;
        this.alwaysOnPower = newAlwaysOnPower;
        this.fieldMagnitude = newFieldMagnitude;
    }

    protected StaticVector getFieldVector(StaticPosition subject, StaticPosition fieldPosition) {
        double bearingToCombatant = fieldPosition.getBearing(subject);
        double distanceFromCombatant = fieldPosition.getDistance(subject);
        return new StaticVectorImpl(bearingToCombatant, this.calculateMagnitude(this.fieldMagnitude, distanceFromCombatant));
    }

    protected StaticVector getFieldVector(double direction, double distance) {
        StaticVectorImpl vector = null;
        vector = distance < this.alwaysOnRange ? new StaticVectorImpl(direction, this.alwaysOnPower) : new StaticVectorImpl(direction, this.calculateMagnitude(this.fieldMagnitude, distance));
        return vector;
    }

    public void debug() {
        super.debug();
    }
}

