/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.gun;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.gun.Aim;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;

public class BSProtectedGun
implements Gun {
    private static final Log log = Logger.getLog(BSProtectedGun.class);
    private Gun gun;
    private RobotProxy robotProxy;
    private GunStats gunStats;
    private boolean moxie;

    public BSProtectedGun(Gun gun) {
        this.gun = gun;
        this.robotProxy = Resources.getRobotProxy();
        this.gunStats = Resources.getGunStats();
    }

    @Override
    public String getName() {
        return this.gun.getName();
    }

    @Override
    public void onRoundBegin() {
        if (Resources.getRobotProxy().getRoundNum() > 1 && this.gunStats.getAverageOpponentBulletPower() < 1.0 && (this.gunStats.getOverallInterferenceRatio() > 0.2 || this.gunStats.getOverallInterferenceRatio() > 0.1 && this.gunStats.getOverallInterferenceRatio() > this.gunStats.getOverallHitRatio())) {
            this.moxie = true;
            log.info("Bullet Shielding protection activated!");
        }
    }

    @Override
    public boolean fireAt(Snapshot target, Snapshot myself, GunController gunController) {
        return this.gun.fireAt(target, myself, gunController);
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        return this.gun.getAim(target, myself);
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        if (this.moxie && target.getEnergy() < this.robotProxy.getEnergy()) {
            long timeSinceLastFire = this.robotProxy.getTime() - this.gunStats.getLastOpponentFireTime();
            return timeSinceLastFire < 4L;
        }
        return this.gun.canFireAt(target);
    }
}

