/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.components.history.BulletRecord;
import bh.components.history.Frame;
import bh.components.history.RobotRecord;
import bh.components.history.analysis.interfaces.BotListener;
import bh.components.history.analysis.interfaces.BulletListener;
import bh.components.history.analysis.interfaces.HistoryListener;
import bh.units.Duration;
import bh.units.Time;
import bh.units.Units;
import java.util.ArrayList;
import java.util.List;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class History {
    private Time latestRecordedEvent = Time.ZERO.minus(Duration.A_TURN);
    private final List<Frame> frames = new ArrayList<Frame>(1000);
    private final List<BotListener> botListeners = new ArrayList<BotListener>();
    private final List<BulletListener> bulletListeners = new ArrayList<BulletListener>();

    public void registerListener(BotListener botListener) {
        this.botListeners.add(botListener);
    }

    public void registerListener(BulletListener bulletListener) {
        this.bulletListeners.add(bulletListener);
    }

    public void registerListener(HistoryListener historyListener) {
        this.botListeners.add((BotListener)historyListener);
        this.bulletListeners.add((BulletListener)historyListener);
    }

    Frame getFrameForce(Time time) {
        int t = this.frames.size();
        while (t <= time.toInt()) {
            this.frames.add(new Frame(new Time(t)));
            ++t;
        }
        return this.frames.get(time.toInt());
    }

    public Frame getFrame(Time time) {
        if (this.frames.size() <= time.toInt()) {
            return null;
        }
        return this.frames.get(time.toInt());
    }

    public Time getLatestRecordedEvent() {
        return this.latestRecordedEvent;
    }

    public void record(BattleEndedEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).battleEndedEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(BulletHitEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).bulletHitEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(BulletHitBulletEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).bulletHitBulletEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(BulletMissedEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).bulletMissedEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(CustomEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).customEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(DeathEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).deathEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(HitByBulletEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).hitByBulletEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(HitRobotEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).hitRobotEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(HitWallEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).hitWallEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(RobotDeathEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).robotDeathEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(ScannedRobotEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).scannedRobotEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(SkippedTurnEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).skippedTurnEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(StatusEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).statusEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public void record(WinEvent event) {
        Time eventTime = new Time(event.getTime());
        this.getFrameForce((Time)eventTime).winEvents.add(event);
        this.latestRecordedEvent = Units.max(this.latestRecordedEvent, eventTime);
    }

    public RobotRecord record(RobotRecord robotRecord) {
        Frame f = this.getFrameForce(robotRecord.time());
        RobotRecord prevRobotRecord = f.robots.get(robotRecord.name());
        RobotRecord mergedRobotRecord = null;
        mergedRobotRecord = prevRobotRecord == null ? robotRecord : prevRobotRecord.merge(robotRecord);
        f.robots.put(robotRecord.name(), mergedRobotRecord);
        for (BotListener bl : this.botListeners) {
            bl.record(mergedRobotRecord);
        }
        if (prevRobotRecord == null) {
            return null;
        }
        RobotRecord conflicts = prevRobotRecord.conflicts(robotRecord);
        return conflicts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("History\n");
        int i = 0;
        while (i < this.frames.size()) {
            sb.append(new Time(i) + ":\n");
            sb.append(this.frames.get(i));
            ++i;
        }
        return sb.toString();
    }

    public void record(Time time, BulletRecord bulletRecord) {
        this.getFrameForce((Time)time).bullets.add(bulletRecord);
        for (BulletListener bl : this.bulletListeners) {
            bl.record(bulletRecord);
        }
    }
}

