/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Duration;
import bh.units.Speed;
import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distance
implements Continuum<Distance>,
AbsoluteToRelative<Distance, Distance> {
    public static final Distance ZERO = new Distance(0.0);
    private final double pixels;

    public Distance(double pixels) {
        assert (!Double.isNaN(pixels));
        this.pixels = (double)Math.round(pixels * 1000000.0) / 1000000.0;
    }

    @Override
    public Distance negate() {
        return new Distance(-this.pixels);
    }

    @Override
    public Distance abs() {
        return new Distance(Math.abs(this.pixels));
    }

    @Override
    public Distance plus(Distance distance) {
        return new Distance(this.pixels + distance.pixels);
    }

    @Override
    public Distance minus(Distance distance) {
        return new Distance(this.pixels - distance.pixels);
    }

    @Override
    public Distance times(double scalar) {
        return new Distance(this.pixels * scalar);
    }

    @Override
    public Distance divide(double scalar) {
        return new Distance(this.pixels / scalar);
    }

    @Override
    public double divide(Distance distance) {
        return this.pixels / distance.pixels;
    }

    public Speed divide(Duration duration) {
        return new Speed(this.pixels / duration.toDouble());
    }

    public Duration divide(Speed speed) {
        return new Duration(this.pixels / speed.toDouble());
    }

    @Override
    public double toDouble() {
        return this.pixels;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.pixels)) + "p";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Distance)) {
            return false;
        }
        Distance distance = (Distance)o;
        return distance.pixels == this.pixels;
    }

    public int hashCode() {
        return new Double(this.pixels).hashCode();
    }
}

