/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicMinimumRiscMovement;
import Krabb.sliNk.Bot;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Movement;
import Krabb.sliNk.MyWave;
import Krabb.sliNk.VoidiousWallSmoother;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WS1on1Movement
extends BasicMinimumRiscMovement {
    WS1on1Movement() {
        this.way_n = 2;
    }

    @Override
    public void newRound(Movement robot) {
        this.smoother = new VoidiousWallSmoother(robot);
    }

    @Override
    protected double getRisc(MyWave wave, Point2D.Double location, long time, double[][] gf_hit, boolean debug) {
        double risc = 0.0;
        return risc += Garm.getEnemy(wave.source_stats_segmentation.name).getRisc(wave, location, time, gf_hit, debug);
    }

    @Override
    protected double getDistancePoints(Point2D.Double location) {
        double distance_new = 0.0;
        int en = 1;
        while (en < Data.getLivingEnemiesWithStats().size() + 1) {
            distance_new += location.distance(Data.getLivingEnemiesWithStats().get((int)(en - 1)).getNewestStats().location);
            ++en;
        }
        return distance_new / (double)en;
    }

    @Override
    protected double[][] setNextDirection(long time, boolean[] direction_difference, Point2D.Double location, double velocity_current, double heading_current, ArrayList<MyWave> waves, int w, Graphics2D g) {
        double[][] directions = new double[this.way_n][3];
        double heading_max = Math.toRadians(10.0 - 0.75 * Math.abs(velocity_current));
        double distance_desired = 400.0;
        double distance = Data.getFirstLivingEnemy() != null && Data.getFirstLivingEnemy().getNewestStats() != null ? location.distance(Data.getFirstLivingEnemy().getNewestStats().location) : distance_desired;
        if (waves != null && w < waves.size()) {
            double gf0_angle = DataHandling.absoluteAngle(waves.get((int)w).victim_stats_start[0].location, waves.get((int)w).source_stats_start.location);
            if (waves.size() > w + 1 && w + 1 < waves.size()) {
                double gf0_angle_new = DataHandling.absoluteAngle(waves.get((int)(w + 1)).victim_stats_start[0].location, waves.get((int)(w + 1)).source_stats_start.location);
                gf0_angle_new = 0.5 * Utils.normalRelativeAngle((double)(gf0_angle_new - gf0_angle));
                gf0_angle += gf0_angle_new;
            }
            int i = 0;
            while (i < this.way_n) {
                double heading_desired;
                double distance_delta_factored = distance - distance_desired;
                distance_delta_factored = distance_delta_factored < 0.0 ? (distance_delta_factored /= 200.0) : (distance_delta_factored /= 70.0);
                double angle_distancing = distance_delta_factored / Math.sqrt(1.0 + distance_delta_factored * distance_delta_factored);
                angle_distancing = distance_delta_factored < 0.0 ? (angle_distancing *= 0.4487989505128276) : (angle_distancing *= 0.3141592653589793);
                angle_distancing = 0.0;
                if (i == 0) {
                    heading_desired = gf0_angle - 1.5707963267948966 + angle_distancing;
                    directions[i][2] = 1.0;
                } else if (i == 1) {
                    heading_desired = gf0_angle + 1.5707963267948966 - angle_distancing;
                    directions[i][2] = -1.0;
                } else {
                    heading_desired = gf0_angle;
                }
                double[] directions_new = this.goToAngle(velocity_current, heading_current, heading_desired);
                directions[i][1] = directions_new[1];
                directions[i][0] = directions_new[0];
                ++i;
            }
        } else {
            Bot enemy = Data.getFirstLivingEnemy();
            if (enemy != null && enemy.getNewestStats() != null) {
                int i = 0;
                while (i < this.way_n) {
                    double heading_desired;
                    double gf0_angle = DataHandling.absoluteAngle(enemy.getNewestStats().location, location);
                    double distance_delta_factored = (distance - distance_desired) / 40.0;
                    double angle_distancing = distance_delta_factored / Math.sqrt(1.0 + distance_delta_factored * distance_delta_factored);
                    angle_distancing *= -0.7853981633974483;
                    if (i == 0) {
                        heading_desired = gf0_angle - 1.5707963267948966 + angle_distancing;
                        directions[i][2] = -1.0;
                    } else if (i == 1) {
                        heading_desired = gf0_angle + 1.5707963267948966 - angle_distancing;
                        directions[i][2] = 1.0;
                    } else {
                        heading_desired = gf0_angle;
                    }
                    double[] directions_new = this.goToAngle(velocity_current, heading_current, heading_desired);
                    directions[i][1] = directions_new[1];
                    directions[i][0] = directions_new[0];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.way_n) {
                    directions[i][2] = 1.0;
                    directions[i][1] = 1.0;
                    ++i;
                }
            }
        }
        return directions;
    }

    @Override
    public void onPaint(Graphics2D g, Movement robot) {
        super.onPaint(g, robot);
    }
}

