/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

class Enemy {
    public double pEnergy;
    public double pHeading;
    public double pVelocity;
    public double pX;
    public double pY;
    public long lastUpdated;
    public double bearing;
    public double distance;
    public double energy;
    public double heading;
    public double velocity;
    public double x;
    public double y;
    public String name;
    public boolean live;
    public Point2D.Double pos;

    public Enemy() {
        this.reset();
        this.name = "";
    }

    public Enemy(ScannedRobotEvent e, AdvancedRobot r) {
        this.reset();
        this.update(e, r);
    }

    public void reset() {
        this.pEnergy = 0.0;
        this.pHeading = 0.0;
        this.pVelocity = 0.0;
        this.pX = Double.NaN;
        this.pY = Double.NaN;
        this.lastUpdated = 0L;
        this.bearing = 0.0;
        this.distance = Double.POSITIVE_INFINITY;
        this.energy = 0.0;
        this.heading = 0.0;
        this.velocity = 0.0;
        this.x = Double.NaN;
        this.y = Double.NaN;
    }

    public boolean none() {
        return this.name.length() == 0;
    }

    public void update(ScannedRobotEvent e, AdvancedRobot r) {
        this.pEnergy = this.energy;
        this.pHeading = this.heading;
        this.pVelocity = this.velocity;
        this.pX = this.x;
        this.pY = this.y;
        this.lastUpdated = e.getTime();
        this.bearing = e.getBearingRadians();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.heading = e.getHeadingRadians();
        this.velocity = e.getVelocity();
        this.name = e.getName();
        double absBearing = r.getHeadingRadians() + e.getBearingRadians();
        this.x = r.getX() + Math.sin(absBearing) * e.getDistance();
        this.y = r.getY() + Math.cos(absBearing) * e.getDistance();
    }

    public boolean firedBullet() {
        return this.getEnergyChange() <= 3.0 && this.getEnergyChange() >= 0.1;
    }

    public double getEnergyChange() {
        return this.pEnergy - this.energy;
    }
}

