/*
 * Decompiled with CFR 0.152.
 */
package grav;

import grav.IGravitySource;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import math.Vect2d;

public class GravityCollection
implements IGravitySource {
    private List<IGravitySource> _entities = new ArrayList<IGravitySource>();

    public void Add(IGravitySource grav) {
        this._entities.add(grav);
    }

    public void Remove(IGravitySource grav) {
        if (this._entities.contains(grav)) {
            this._entities.remove(grav);
        }
    }

    @Override
    public Vect2d GetEffectiveGravity(long time) {
        Vect2d gravity = new Vect2d(0.0, 0.0);
        int entitiesSize = this._entities.size();
        for (int i = 0; i < entitiesSize; ++i) {
            IGravitySource grav = this._entities.get(i);
            gravity.add(grav.GetEffectiveGravity(time));
        }
        return gravity;
    }

    @Override
    public void Draw(Graphics2D e) {
        int entitiesSize = this._entities.size();
        for (int i = 0; i < entitiesSize; ++i) {
            IGravitySource grav = this._entities.get(i);
            grav.Draw(e);
        }
    }
}

