/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.geo;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.util.Utils;

public class Point {
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDistanceFrom(Point anotherPoint) {
        return Math.sqrt((this.x - anotherPoint.x) * (this.x - anotherPoint.x) + (this.y - anotherPoint.y) * (this.y - anotherPoint.y));
    }

    public Point getRelativePoint(double bearing, double distance) {
        return new Point(this.x + distance * Math.sin(Math.toRadians(bearing)), this.y + distance * Math.cos(Math.toRadians(bearing)));
    }

    public void paint(Graphics2D g, Color color, int radius) {
        g.setColor(color);
        g.fillOval((int)Math.round(this.x - (double)radius), (int)Math.round(this.y - (double)radius), radius * 2, radius * 2);
    }

    public double getBearingTowards(Point target) {
        double simpleResult = Math.toDegrees(Math.atan((target.x - this.x) / (target.y - this.y)));
        if (target.y < this.y) {
            return simpleResult + 180.0;
        }
        return Utils.normalAbsoluteAngleDegrees((double)simpleResult);
    }
}

